/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FileSystemElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.softwarecapabilities.FileSystemProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FileSystemConverter<B>
extends OMFConverter<B> {
    public FileSystemConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof FileSystemElement) {
                FileSystemElement bean = (FileSystemElement)returnBean;
                FileSystemProperties fileSystemProperties = new FileSystemProperties();
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    fileSystemProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    fileSystemProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    fileSystemProperties.setResourceName(this.removeName(instanceProperties));
                    fileSystemProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    fileSystemProperties.setDeployedImplementationType(this.removeCapabilityType(instanceProperties));
                    fileSystemProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    fileSystemProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    fileSystemProperties.setSource(this.removeSource(instanceProperties));
                    fileSystemProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    fileSystemProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties(OpenMetadataType.FILE_SYSTEM_CLASSIFICATION.typeName, entity);
                    fileSystemProperties.setFormat(this.getFormat(instanceProperties));
                    fileSystemProperties.setEncryption(this.getEncryption(instanceProperties));
                    bean.setFileSystemProperties(fileSystemProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

