/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GlossaryTermBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String summary = null;
    private String examples = null;
    private String abbreviation = null;
    private String usage = null;
    private String publishVersionIdentifier = null;

    GlossaryTermBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", repositoryHelper, serviceName, serverName);
    }

    GlossaryTermBuilder(String qualifiedName, String displayName, String description, String publishVersionIdentifier, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.publishVersionIdentifier = publishVersionIdentifier;
    }

    public GlossaryTermBuilder(String qualifiedName, String displayName, String description, String summary, String examples, String abbreviation, String usage, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.summary = summary;
        this.examples = examples;
        this.abbreviation = abbreviation;
        this.usage = usage;
    }

    public GlossaryTermBuilder(String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, String publishVersionIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", "GlossaryTerm", extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.summary = summary;
        this.description = description;
        this.examples = examples;
        this.abbreviation = abbreviation;
        this.usage = usage;
        this.publishVersionIdentifier = publishVersionIdentifier;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUMMARY.name, this.summary, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXAMPLES.name, this.examples, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ABBREVIATION.name, this.abbreviation, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, this.usage, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PUBLISH_VERSION_ID.name, this.publishVersionIdentifier, methodName);
        return properties;
    }

    InstanceProperties getActivityTypeProperties(int activityType, String methodName) throws InvalidParameterException {
        InstanceProperties properties;
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ACTIVITY_TYPE.name, GlossaryTermActivityType.getOpenTypeGUID(), GlossaryTermActivityType.getOpenTypeName(), activityType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), OpenMetadataProperty.ACTIVITY_TYPE.name);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getContextDescriptionProperties(String description, String scope, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "scope", scope, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getTermCategorizationProperties(String description, int relationshipStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, "42282652-7d60-435e-ad3e-7cfe5291bcc7", "TermRelationshipStatus", relationshipStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), OpenMetadataProperty.STARS.name);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getTermRelationshipProperties(String expression, String description, int relationshipStatus, String steward, String source, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.EXPRESSION.name, expression, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), relationshipStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)((Object)error), OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }
}

