/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionTypeHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceActionTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceActionType(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties, String governanceEngineGUID, String calledRequestType, Map<String, String> fixedRequestParameters, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "properties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "properties.getQualifiedName", methodName);
        GovernanceActionTypeBuilder builder = new GovernanceActionTypeBuilder(qualifiedName, domainIdentifier, displayName, description, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String governanceActionTypeGUID = this.createBeanInRepository(userId, null, null, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", builder, effectiveTime, methodName);
        if (governanceActionTypeGUID != null && governanceEngineGUID != null) {
            this.linkGovernanceActionExecutor(userId, governanceActionTypeGUID, governanceEngineGUID, calledRequestType, fixedRequestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return governanceActionTypeGUID;
    }

    private void linkGovernanceActionExecutor(String userId, String governanceActionTypeGUID, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionTypeGUIDParameterName = "governanceActionTypeGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.REQUEST_TYPE.name, requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, methodName);
        this.linkElementToElement(userId, null, null, governanceActionTypeGUID, "governanceActionTypeGUID", "GovernanceActionType", governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionExecutor", this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateGovernanceActionType(String userId, String governanceActionTypeGUID, boolean isMergeUpdate, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties, String governanceEngineGUID, String requestType, Map<String, String> requestParameters, int waitTime, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceActionTypeGUIDParameterName = "governanceActionTypeGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        String qualifiedNameParameterName = "properties.getQualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionTypeGUID, "governanceActionTypeGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "properties.getQualifiedName", methodName);
        }
        if (!isMergeUpdate || governanceEngineGUID != null || requestType != null || requestParameters != null) {
            Relationship executorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionTypeGUID, "GovernanceActionType", "f672245f-35b5-4ca7-b645-014cf61d5b75", "GovernanceActionExecutor", 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (executorRelationship == null) {
                this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
                this.linkGovernanceActionExecutor(userId, governanceActionTypeGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            } else if (governanceEngineGUID == null) {
                if (!isMergeUpdate) {
                    this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                } else {
                    this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, true, methodName);
                }
            } else if (governanceEngineGUID.equals(executorRelationship.getEntityTwoProxy().getGUID())) {
                this.updateExecutorRelationship(userId, executorRelationship, requestType, requestParameters, effectiveFrom, effectiveTo, isMergeUpdate, methodName);
            } else {
                this.repositoryHandler.removeRelationship(userId, null, null, executorRelationship, methodName);
                this.linkGovernanceActionExecutor(userId, governanceActionTypeGUID, governanceEngineGUID, requestType, requestParameters, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            }
        }
        GovernanceActionTypeBuilder builder = new GovernanceActionTypeBuilder(qualifiedName, domainIdentifier, displayName, description, waitTime, additionalProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, governanceActionTypeGUID, "governanceActionTypeGUID", "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    private void updateExecutorRelationship(String userId, Relationship executorRelationship, String requestType, Map<String, String> requestParameters, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        InstanceProperties relationshipProperties = null;
        if (isMergeUpdate) {
            relationshipProperties = executorRelationship.getProperties();
        }
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_TYPE.name, requestType, methodName);
        relationshipProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters, methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, executorRelationship, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), methodName);
    }

    public void removeGovernanceActionType(String userId, String governanceActionTypeGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceActionTypeGUID, "governanceActionTypeGUID", methodName);
        this.deleteBeanInRepository(userId, null, null, governanceActionTypeGUID, "governanceActionTypeGUID", "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> findGovernanceActionTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.getBeansByValue(userId, searchString, searchStringParameterName, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", null, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGovernanceActionTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, "92e20083-0393-40c0-a95b-090724a91ddc", "GovernanceActionType", specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getGovernanceActionTypeByGUID(String userId, String governanceActionTypeGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceActionTypeGUID";
        return this.getBeanFromRepository(userId, governanceActionTypeGUID, "governanceActionTypeGUID", "GovernanceActionType", false, false, serviceSupportedZones, effectiveTime, methodName);
    }
}

