/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDefinitionGraphConverter<B>
extends OMFConverter<B> {
    public GovernanceDefinitionGraphConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceDefinitionGraph) {
                GovernanceDefinitionGraph bean = (GovernanceDefinitionGraph)returnBean;
                if (primaryEntity != null) {
                    CertificationTypeProperties governanceDefinitionProperties;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, primaryEntity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    String typeName = primaryEntity.getType().getTypeDefName();
                    if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, "CertificationType")) {
                        governanceDefinitionProperties = new CertificationTypeProperties();
                        governanceDefinitionProperties.setDetails(this.removeDetails(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, "LicenseType")) {
                        governanceDefinitionProperties = new LicenseTypeProperties();
                        ((LicenseTypeProperties)governanceDefinitionProperties).setDetails(this.removeDetails(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, "SecurityGroup")) {
                        governanceDefinitionProperties = new SecurityGroupProperties();
                        ((SecurityGroupProperties)governanceDefinitionProperties).setDistinguishedName(this.removeDistinguishedName(instanceProperties));
                    } else {
                        governanceDefinitionProperties = new GovernanceDefinitionProperties();
                    }
                    governanceDefinitionProperties.setDocumentIdentifier(this.removeQualifiedName(instanceProperties));
                    governanceDefinitionProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceDefinitionProperties.setTitle(this.removeTitle(instanceProperties));
                    governanceDefinitionProperties.setScope(this.removeScope(instanceProperties));
                    governanceDefinitionProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceDefinitionProperties.setPriority(this.removePriority(instanceProperties));
                    governanceDefinitionProperties.setOutcomes(this.removeOutcomes(instanceProperties));
                    governanceDefinitionProperties.setResults(this.removeResults(instanceProperties));
                    governanceDefinitionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceDefinitionProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties((GovernanceDefinitionProperties)governanceDefinitionProperties);
                    if (relationships != null) {
                        ArrayList<RelatedElement> parents = new ArrayList<RelatedElement>();
                        ArrayList<RelatedElement> peers = new ArrayList<RelatedElement>();
                        ArrayList<RelatedElement> children = new ArrayList<RelatedElement>();
                        ArrayList<RelatedElement> metrics = new ArrayList<RelatedElement>();
                        ArrayList<RelatedElement> externalReferences = new ArrayList<RelatedElement>();
                        ArrayList<RelatedElement> others = new ArrayList<RelatedElement>();
                        for (Relationship relationship : relationships) {
                            if (relationship == null) continue;
                            EntityProxy otherEnd = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                            RelatedElement element = super.getRelatedElement(beanClass, relationship, otherEnd, methodName);
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)) {
                                externalReferences.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceDefinitionMetric")) {
                                metrics.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceDriverLink") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernancePolicyLink") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceControlLink")) {
                                peers.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceResponse") || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), "GovernanceImplementation")) {
                                if (primaryEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) {
                                    parents.add(element);
                                    continue;
                                }
                                children.add(element);
                                continue;
                            }
                            others.add(element);
                        }
                        if (!parents.isEmpty()) {
                            bean.setParents(parents);
                        }
                        if (!peers.isEmpty()) {
                            bean.setPeers(peers);
                        }
                        if (!children.isEmpty()) {
                            bean.setChildren(children);
                        }
                        if (!metrics.isEmpty()) {
                            bean.setMetrics(metrics);
                        }
                        if (!externalReferences.isEmpty()) {
                            bean.setExternalReferences(externalReferences);
                        }
                        if (!others.isEmpty()) {
                            bean.setOthers(others);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

