/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDomainElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDomainProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDomainConverter<B>
extends OMFConverter<B> {
    public GovernanceDomainConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceDomainElement) {
                GovernanceDomainElement bean = (GovernanceDomainElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    GovernanceDomainProperties governanceDomainProperties = new GovernanceDomainProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    governanceDomainProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    governanceDomainProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceDomainProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    governanceDomainProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceDomainProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceDomainProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceDomainProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(governanceDomainProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

