/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDomainSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDomainSetProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDomainSetConverter<B>
extends OMFConverter<B> {
    public GovernanceDomainSetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceDomainSetElement) {
                GovernanceDomainSetElement bean = (GovernanceDomainSetElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    GovernanceDomainSetProperties governanceDomainSetProperties = new GovernanceDomainSetProperties();
                    governanceDomainSetProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    governanceDomainSetProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceDomainSetProperties.setDisplayName(this.removeName(instanceProperties));
                    governanceDomainSetProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceDomainSetProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceDomainSetProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(governanceDomainSetProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

