/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceMetricBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceMetricHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public GovernanceMetricHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String measurement, String target, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = "GovernanceMetric";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceMetric", this.serviceName, methodName, this.repositoryHelper);
        GovernanceMetricBuilder builder = new GovernanceMetricBuilder(qualifiedName, displayName, description, measurement, target, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String qualifiedName, String displayName, String description, String measurement, String target, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceMetricGUID, governanceMetricGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String typeName = "GovernanceMetric";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceMetric", this.serviceName, methodName, this.repositoryHelper);
        GovernanceMetricBuilder builder = new GovernanceMetricBuilder(qualifiedName, displayName, description, measurement, target, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addGovernanceDefinitionMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String rationale, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "rationale", rationale, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, "GovernanceMetric", governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, "e076fbb3-54f5-46b8-8f1e-a7cb7e792673", "e076fbb3-54f5-46b8-8f1e-a7cb7e792673", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceDefinitionMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, "GovernanceMetric", governanceDefinitionGUID, governanceDefinitionGUIDParameterName, "578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", forLineage, forDuplicateProcessing, "e076fbb3-54f5-46b8-8f1e-a7cb7e792673", "e076fbb3-54f5-46b8-8f1e-a7cb7e792673", effectiveTime, methodName);
    }

    public void addGovernanceResults(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String dataSetGUID, String dataSetGUIDParameterName, String query, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "query", query, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, "GovernanceMetric", dataSetGUID, dataSetGUIDParameterName, OpenMetadataType.DATA_SET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, "89c3c695-9e8d-4660-9f44-ed971fd55f88", "89c3c695-9e8d-4660-9f44-ed971fd55f88", properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceResults(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String dataSetGUID, String dataSetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, "GovernanceMetric", dataSetGUID, dataSetGUIDParameterName, OpenMetadataType.DATA_SET.typeGUID, OpenMetadataType.DATA_SET.typeName, forLineage, forDuplicateProcessing, "89c3c695-9e8d-4660-9f44-ed971fd55f88", "89c3c695-9e8d-4660-9f44-ed971fd55f88", effectiveTime, methodName);
    }

    public void removeGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, "9ada8e7b-823c-40f7-adf8-f164aabda77e", "GovernanceMetric", null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGovernanceMetrics(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, "9ada8e7b-823c-40f7-adf8-f164aabda77e", "GovernanceMetric", startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAttachedGovernanceMetricImplementations(String userId, String guid, String guidParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getAttachedEntities(userId, guid, guidParameterName, "GovernanceDefinition", "e076fbb3-54f5-46b8-8f1e-a7cb7e792673", "GovernanceDefinitionMetric", "GovernanceMetric", null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                List<Relationship> relationships = this.getAllAttachmentLinks(userId, guid, guidParameterName, "GovernanceMetric", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getGovernanceMetricByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, "GovernanceMetric", forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

