/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceRoleProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceRoleConverter<B>
extends OMFConverter<B> {
    public GovernanceRoleConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceRoleElement) {
                GovernanceRoleElement bean = (GovernanceRoleElement)returnBean;
                GovernanceRoleProperties governanceRoleProperties = new GovernanceRoleProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    governanceRoleProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceRoleProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    governanceRoleProperties.setRoleId(this.removeIdentifier(instanceProperties));
                    governanceRoleProperties.setScope(this.removeScope(instanceProperties));
                    governanceRoleProperties.setTitle(this.removeName(instanceProperties));
                    governanceRoleProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceRoleProperties.setHeadCountLimitSet(instanceProperties.getPropertyValue(OpenMetadataProperty.HEAD_COUNT.name) != null);
                    governanceRoleProperties.setHeadCount(this.removeHeadCount(instanceProperties));
                    governanceRoleProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceRoleProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceRoleProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setRole(governanceRoleProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

