/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LicenseTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseTypeProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LicenseTypeConverter<B>
extends OMFConverter<B> {
    public LicenseTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail primaryEntity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof LicenseTypeElement) {
                LicenseTypeElement bean = (LicenseTypeElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, primaryEntity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    LicenseTypeProperties licenseTypeProperties = new LicenseTypeProperties();
                    licenseTypeProperties.setDocumentIdentifier(this.removeQualifiedName(instanceProperties));
                    licenseTypeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    licenseTypeProperties.setTitle(this.removeTitle(instanceProperties));
                    licenseTypeProperties.setScope(this.removeScope(instanceProperties));
                    licenseTypeProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    licenseTypeProperties.setPriority(this.removePriority(instanceProperties));
                    licenseTypeProperties.setOutcomes(this.removeOutcomes(instanceProperties));
                    licenseTypeProperties.setResults(this.removeResults(instanceProperties));
                    licenseTypeProperties.setDetails(this.removeDetails(instanceProperties));
                    licenseTypeProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    licenseTypeProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(licenseTypeProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(entity, relationship)";
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof LicenseTypeElement) {
            LicenseTypeElement bean = (LicenseTypeElement)returnBean;
            bean.setRelatedElement(super.getRelatedElement(beanClass, entity, relationship, methodName));
        }
        return returnBean;
    }
}

