/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LikeHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public LikeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getLikes(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, OpenMetadataType.LIKE.typeName, (String)null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public void saveLike(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            this.removeLike(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LikeBuilder builder = new LikeBuilder(isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, elementGUID, elementGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        String likeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.LIKE.typeGUID, OpenMetadataType.LIKE.typeName, builder, effectiveTime, methodName);
        if (likeGUID != null) {
            String likeGUIDParameterName = "likeGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, likeGUID, "likeGUID", OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, builder.getRelationshipInstanceProperties(methodName), methodName);
        }
    }

    public void removeLike(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String likeGUID = this.unlinkConnectedElement(userId, true, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, OpenMetadataType.LIKE.typeName, effectiveTime, methodName);
        if (likeGUID != null) {
            String ratingGUIDParameterName = "likeGUID";
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, likeGUID, "likeGUID", OpenMetadataType.LIKE.typeGUID, OpenMetadataType.LIKE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }
}

