/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private String displayName = null;
    private String description = null;

    LocationBuilder(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
    }

    LocationBuilder(String qualifiedName, String identifier, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, null, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
    }

    LocationBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IDENTIFIER.name, this.identifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        return properties;
    }

    InstanceProperties getFixedLocationProperties(String coordinates, String mapProjection, String postalAddress, String timeZone, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.COORDINATES.name, coordinates, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MAP_PROJECTION.name, mapProjection, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.POSTAL_ADDRESS.name, postalAddress, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TIME_ZONE.name, timeZone, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSecureLocationProperties(String description, String level, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LEVEL.name, level, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCyberLocationProperties(String networkAddress, String methodName) {
        return this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NETWORK_ADDRESS.name, networkAddress, methodName);
    }
}

