/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class NoteBuilder
extends ReferenceableBuilder {
    private final String title;
    private final String text;

    public NoteBuilder(String qualifiedName, String title, String text, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, OpenMetadataType.NOTE_ENTRY.typeGUID, OpenMetadataType.NOTE_ENTRY.typeName, repositoryHelper, serviceName, serverName);
        this.text = text;
        this.title = title;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TITLE.name, this.title, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TEXT.name, this.text, methodName);
        return properties;
    }
}

