/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIRootHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;

public class OpenMetadataAPIAnchorHandler<B>
extends OpenMetadataAPIRootHandler<B> {
    public OpenMetadataAPIAnchorHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public AnchorIdentifiers getAnchorGUIDFromAnchorsClassification(EntitySummary connectToEntity, String methodName) {
        AnchorIdentifiers anchorIdentifiers = null;
        try {
            Classification anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, connectToEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && anchorsClassification.getProperties() != null) {
                anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorTypeName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorDomainName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorsClassification.getProperties(), methodName);
                if (anchorIdentifiers.anchorGUID == null) {
                    anchorIdentifiers.anchorGUID = connectToEntity.getGUID();
                }
                if ("<unknown>".equals(anchorIdentifiers.anchorGUID)) {
                    String localMethodName = "getAnchorGUIDFromAnchorsClassification";
                    throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("getAnchorGUIDFromAnchorsClassification", this.serviceName, methodName), this.getClass().getName(), "getAnchorGUIDFromAnchorsClassification");
                }
            }
        }
        catch (ClassificationErrorException localMethodName) {
        }
        catch (PropertyServerException error) {
            try {
                this.errorHandler.handleUnsupportedAnchorsType((Exception)((Object)error), methodName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
            }
            catch (PropertyServerException propertyServerException) {
                // empty catch block
            }
        }
        return anchorIdentifiers;
    }

    private void maintainAnchorGUIDInClassification(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntitySummary targetEntity, AnchorIdentifiers anchorIdentifiers, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException {
        Classification anchorsClassification;
        InstanceProperties anchorsProperties = null;
        String currentAnchorGUID = null;
        String newAnchorGUID = null;
        if (anchorIdentifiers != null) {
            newAnchorGUID = anchorIdentifiers.anchorGUID;
        }
        if ("<unknown>".equals(newAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        try {
            anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, targetEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && (anchorsProperties = anchorsClassification.getProperties()) != null) {
                currentAnchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
            }
        }
        catch (ClassificationErrorException noAnchorsClassification) {
            anchorsClassification = null;
        }
        if ("<unknown>".equals(currentAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        if (currentAnchorGUID == null && newAnchorGUID != null || currentAnchorGUID != null && !currentAnchorGUID.equals(newAnchorGUID)) {
            try {
                if (anchorIdentifiers != null) {
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_GUID.name, anchorIdentifiers.anchorGUID, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorIdentifiers.anchorTypeName, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorIdentifiers.anchorDomainName, methodName);
                }
                if (anchorsClassification == null) {
                    this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (newAnchorGUID != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, targetGUID, targetGUIDParameterName, targetTypeName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (targetEntity instanceof EntityDetail) {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, (EntityDetail)targetEntity, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (Exception error) {
                String typeName = "<null>";
                String typeGUID = "<null>";
                if (targetEntity.getType() != null) {
                    typeName = targetEntity.getType().getTypeDefName();
                    typeGUID = targetEntity.getType().getTypeDefGUID();
                }
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, targetGUID, typeName, typeGUID, methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaType(String userId, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6", "APIHeader", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "4ab3b466-31bd-48ea-8aa2-75623476f2e2", "APIRequest", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "e8001de2-1bb1-442b-a66f-9addc3641eae", "APIResponse", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", false, "B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaAttribute(String userId, String attributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, false, "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueParentRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", true, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForConnection(String userId, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, OpenMetadataType.CONNECTION.typeName, true, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForEndpoint(String userId, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            if (relationships.size() == 1) {
                EntityProxy proxy = ((Relationship)relationships.get(0)).getEntityOneProxy();
                if (proxy != null && proxy.getGUID() != null && proxy.getType() != null) {
                    AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                    anchorIdentifiers.anchorGUID = proxy.getGUID();
                    anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                    return anchorIdentifiers;
                }
            } else {
                return null;
            }
        }
        if ((relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName)) != null && relationships.size() == 1) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForLike(String userId, String likeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, likeGUID, OpenMetadataType.LIKE.typeName, false, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForRating(String userId, String ratingGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, ratingGUID, OpenMetadataType.RATING.typeName, false, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForOpenDiscoveryAnalysisReport(String userId, String reportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, reportGUID, "OpenDiscoveryAnalysisReport", false, "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSurveyReport(String userId, String reportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, reportGUID, OpenMetadataType.SURVEY_REPORT.typeName, false, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotation(String userId, String annotationGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, annotationGUID, OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null || annotationGUID.equals(proxy.getGUID()) || !this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.SURVEY_REPORT.typeName)) continue;
                return this.getAnchorGUIDForSurveyReport(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotationReview(String userId, String annotationReviewGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, annotationReviewGUID, OpenMetadataType.ANNOTATION_REVIEW.typeName, false, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForDataField(String userId, String dataFieldGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, dataFieldGUID, OpenMetadataType.DATA_FIELD.typeName, false, "60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForComment(String userId, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, commentGUID, OpenMetadataType.COMMENT.typeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                AnchorIdentifiers parentAnchorIdentifiers;
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                if (!commentGUID.equals(proxy.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.COMMENT.typeName) && (parentAnchorIdentifiers = this.getAnchorGUIDForComment(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                    return parentAnchorIdentifiers;
                }
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForGlossaryTerm(String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryTermGUID, "GlossaryTerm", "1d43d661-bdc7-4a91-a996-3239b8f82e56", "TermAnchor", 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForGlossaryCategory(String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryCategoryGUID, "GlossaryCategory", "c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    AnchorIdentifiers deriveAnchorGUID(String targetGUID, String targetTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AnchorIdentifiers anchorIdentifiers = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SCHEMA_TYPE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaType(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaAttribute(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.CONNECTION.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForConnection(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ENDPOINT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForEndpoint(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.COMMENT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForComment(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.RATING.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForRating(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.LIKE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForLike(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "OpenDiscoveryAnalysisReport")) {
            anchorIdentifiers = this.getAnchorGUIDForOpenDiscoveryAnalysisReport(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SURVEY_REPORT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSurveyReport(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotation(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION_REVIEW.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotationReview(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.DATA_FIELD.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForDataField(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.GLOSSARY_TERM.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForGlossaryTerm(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, "GlossaryCategory")) {
            anchorIdentifiers = this.getAnchorGUIDForGlossaryCategory(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ASSET.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.PERSON.typeName)) {
            anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = targetGUID;
            anchorIdentifiers.anchorTypeName = targetTypeName;
        }
        if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null && anchorIdentifiers.anchorTypeName != null && anchorIdentifiers.anchorDomainName == null) {
            anchorIdentifiers.anchorDomainName = this.getDomainName(anchorIdentifiers.anchorTypeName);
        }
        return anchorIdentifiers;
    }

    String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail targetElement;
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && (targetElement = this.repositoryHandler.getEntityByGUID(this.localServerUserId, targetGUID, targetGUIDParameterName, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    public String getDomainName(EntitySummary instance) {
        return this.getDomainName(instance.getType().getTypeDefName());
    }

    public String getDomainName(String typeName) {
        String anchorDomainName = typeName;
        List superTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeName);
        if (superTypes != null) {
            for (TypeDefLink typeDefLink : superTypes) {
                if (OpenMetadataType.OPEN_METADATA_ROOT.typeName.equals(typeDefLink.getName()) || OpenMetadataType.REFERENCEABLE.typeName.equals(typeDefLink.getName())) continue;
                anchorDomainName = typeDefLink.getName();
            }
        }
        return anchorDomainName;
    }

    String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntityDetail targetElement, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && targetElement != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    public AnchorIdentifiers getAnchorGUIDForEntity(EntityDetail connectToEntity, String connectToGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateObject((Object)connectToEntity, connectToGUIDParameterName, methodName);
        AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)connectToEntity, methodName);
        if (anchorIdentifiers == null && (anchorIdentifiers = this.deriveAnchorGUID(connectToEntity.getGUID(), connectToEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(connectToEntity.getGUID(), connectToGUIDParameterName, connectToEntity.getType().getTypeDefName(), (EntitySummary)connectToEntity, anchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return anchorIdentifiers;
    }

    public void addAnchorsClassification(String userId, EntityDetail anchoredElement, String anchoredElementGUIDParameterName, String anchorGUID, String anchorTypeName, String anchorDomainName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)anchoredElement, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorIdentifiers == null) {
            this.repositoryHandler.classifyEntity(userId, null, null, anchoredElement.getGUID(), anchoredElement, anchoredElementGUIDParameterName, anchoredElement.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, builder.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.repositoryHandler.reclassifyEntity(userId, null, null, anchoredElement.getGUID(), anchoredElementGUIDParameterName, anchoredElement.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, null, builder.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public static class AnchorIdentifiers {
        public String anchorGUID = null;
        String anchorTypeName = null;
        String anchorDomainName = null;
    }
}

