/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class OpenMetadataAPIGenericBuilder {
    protected RepositoryErrorHandler errorHandler;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected Map<String, Object> extendedProperties;
    protected String typeGUID;
    protected String typeName;
    protected InstanceStatus instanceStatus;
    private Date effectiveFrom;
    private Date effectiveTo;
    protected List<Classification> existingClassifications;
    protected Map<String, Classification> newClassifications = new HashMap<String, Classification>();
    protected InstanceProperties templateProperties = null;

    public OpenMetadataAPIGenericBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this(typeGUID, typeName, null, null, null, repositoryHelper, serviceName, serverName);
    }

    protected OpenMetadataAPIGenericBuilder(String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this(typeGUID, typeName, extendedProperties, instanceStatus, null, null, existingClassifications, repositoryHelper, serviceName, serverName);
    }

    protected OpenMetadataAPIGenericBuilder(String typeGUID, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, Date effectiveFrom, Date effectiveTo, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        TypeDef typeDef;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.typeGUID = typeGUID;
        this.typeName = typeName;
        this.extendedProperties = extendedProperties;
        this.instanceStatus = instanceStatus;
        this.effectiveFrom = effectiveFrom;
        this.effectiveTo = effectiveTo;
        this.existingClassifications = existingClassifications;
        if (this.typeName == null) {
            this.typeName = OpenMetadataType.REFERENCEABLE.typeName;
        }
        if (this.typeGUID == null && (typeDef = repositoryHelper.getTypeDefByName(serviceName, this.typeName)) != null) {
            this.typeGUID = typeDef.getGUID();
        }
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public void setClassification(Classification newClassification) {
        this.newClassifications.put(newClassification.getName(), newClassification);
    }

    public boolean isClassificationSet(String classificationName) {
        return this.newClassifications.get(classificationName) != null;
    }

    public void setTemplateClassifications(String userId, String externalSourceGUID, String externalSourceName, List<Classification> templateClassifications, Map<String, String> placeholderProperties, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        if (templateClassifications == null) {
            this.newClassifications = new HashMap<String, Classification>();
        } else {
            InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
            if (externalSourceGUID != null) {
                instanceProvenanceType = InstanceProvenanceType.EXTERNAL_SOURCE;
            }
            for (Classification templateClassification : templateClassifications) {
                if (templateClassification == null || OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(templateClassification.getName()) || OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName.equals(templateClassification.getName())) continue;
                try {
                    InstanceProperties classificationProperties = templateClassification.getProperties();
                    if (classificationProperties != null) {
                        classificationProperties = this.replacePropertiesWithPlaceholders(classificationProperties, placeholderProperties);
                    }
                    Classification classification = templateClassification.getInstanceProvenanceType() == InstanceProvenanceType.LOCAL_COHORT ? this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, templateClassification.getName(), this.typeName, ClassificationOrigin.ASSIGNED, null, classificationProperties) : this.repositoryHelper.getNewClassification(this.serviceName, externalSourceGUID, externalSourceName, instanceProvenanceType, userId, templateClassification.getName(), this.typeName, ClassificationOrigin.ASSIGNED, null, classificationProperties);
                    this.newClassifications.put(classification.getName(), classification);
                }
                catch (TypeErrorException error) {
                    this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, templateClassification.getName());
                }
            }
        }
    }

    public void setTemplateSubstitute(String userId, String methodName) throws PropertyServerException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (Exception error) {
            this.errorHandler.handleUnsupportedAnchorsType(error, methodName, OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION.typeName);
        }
    }

    public void setAnchors(String userId, String anchorGUID, String anchorTypeName, String anchorDomainName, String methodName) throws PropertyServerException {
        String localMethodName = "setAnchors";
        try {
            if ("<unknown>".equals(anchorGUID)) {
                throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("setAnchors", this.serviceName, methodName), this.getClass().getName(), "setAnchors");
            }
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, this.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (Exception error) {
            this.errorHandler.handleUnsupportedAnchorsType(error, methodName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
        }
    }

    InstanceProperties getAnchorsProperties(String anchorGUID, String anchorTypeName, String anchorDomainName, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANCHOR_GUID.name, anchorGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorDomainName, methodName);
        return properties;
    }

    public void setEffectivityDates(Date effectiveFrom, Date effectiveTo) {
        this.effectiveFrom = effectiveFrom;
        this.effectiveTo = effectiveTo;
    }

    void setTemplateProperties(InstanceProperties templateProperties, Map<String, String> placeholderProperties) {
        this.templateProperties = this.replacePropertiesWithPlaceholders(templateProperties, placeholderProperties);
    }

    InstanceProperties replacePropertiesWithPlaceholders(InstanceProperties templateProperties, Map<String, String> placeholderProperties) {
        String methodName = "replacePropertiesWithPlaceholders";
        if (templateProperties != null) {
            if (templateProperties.getPropertyCount() == 0 || placeholderProperties == null || placeholderProperties.isEmpty()) {
                return new InstanceProperties(templateProperties);
            }
            InstanceProperties newTemplateProperties = new InstanceProperties(templateProperties);
            Map instancePropertyValueMap = templateProperties.getInstanceProperties();
            for (String propertyName : instancePropertyValueMap.keySet()) {
                InstancePropertyValue instancePropertyValue = newTemplateProperties.getPropertyValue(propertyName);
                if (instancePropertyValue instanceof PrimitivePropertyValue) {
                    String newProperty;
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) {
                        newProperty = this.replacePrimitiveStringWithPlaceholders(primitivePropertyValue, placeholderProperties);
                        if (newProperty != null) {
                            this.repositoryHelper.addStringPropertyToInstance(this.serviceName, newTemplateProperties, propertyName, newProperty, "replacePropertiesWithPlaceholders");
                            continue;
                        }
                        this.repositoryHelper.removeStringProperty(this.serviceName, propertyName, newTemplateProperties, "replacePropertiesWithPlaceholders");
                        continue;
                    }
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT) {
                        newProperty = this.replacePrimitiveStringWithPlaceholders(primitivePropertyValue, placeholderProperties);
                        if (newProperty != null && !newProperty.equals(primitivePropertyValue.valueAsString())) {
                            this.repositoryHelper.addIntPropertyToInstance(this.serviceName, newTemplateProperties, propertyName, Integer.getInteger(newProperty).intValue(), "replacePropertiesWithPlaceholders");
                            continue;
                        }
                        this.repositoryHelper.removeIntProperty(this.serviceName, propertyName, newTemplateProperties, "replacePropertiesWithPlaceholders");
                        continue;
                    }
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG) {
                        newProperty = this.replacePrimitiveStringWithPlaceholders(primitivePropertyValue, placeholderProperties);
                        if (newProperty != null && !newProperty.equals(primitivePropertyValue.valueAsString())) {
                            this.repositoryHelper.addLongPropertyToInstance(this.serviceName, newTemplateProperties, propertyName, Long.getLong(newProperty).longValue(), "replacePropertiesWithPlaceholders");
                            continue;
                        }
                        this.repositoryHelper.removeLongProperty(this.serviceName, propertyName, newTemplateProperties, "replacePropertiesWithPlaceholders");
                        continue;
                    }
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE) {
                        newProperty = this.replacePrimitiveStringWithPlaceholders(primitivePropertyValue, placeholderProperties);
                        if (newProperty != null && !newProperty.equals(primitivePropertyValue.valueAsString())) {
                            this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newTemplateProperties, propertyName, new Date(Long.getLong(newProperty)), "replacePropertiesWithPlaceholders");
                            continue;
                        }
                        this.repositoryHelper.removeDateProperty(this.serviceName, propertyName, newTemplateProperties, "replacePropertiesWithPlaceholders");
                        continue;
                    }
                    if (primitivePropertyValue.getPrimitiveDefCategory() != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN) continue;
                    newProperty = this.replacePrimitiveStringWithPlaceholders(primitivePropertyValue, placeholderProperties);
                    if (newProperty != null && !newProperty.equals(primitivePropertyValue.valueAsString())) {
                        this.repositoryHelper.addObjectPropertyToInstance(this.serviceName, newTemplateProperties, propertyName, (Object)newProperty, "replacePropertiesWithPlaceholders");
                        continue;
                    }
                    this.repositoryHelper.removeStringProperty(this.serviceName, propertyName, newTemplateProperties, "replacePropertiesWithPlaceholders");
                    continue;
                }
                if (instancePropertyValue instanceof ArrayPropertyValue) {
                    ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                    arrayPropertyValue.setArrayValues(this.replacePropertiesWithPlaceholders(arrayPropertyValue.getArrayValues(), placeholderProperties));
                    newTemplateProperties.setProperty(propertyName, (InstancePropertyValue)arrayPropertyValue);
                    continue;
                }
                if (!(instancePropertyValue instanceof MapPropertyValue)) continue;
                MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                mapPropertyValue.setMapValues(this.replacePropertiesWithPlaceholders(mapPropertyValue.getMapValues(), placeholderProperties));
                newTemplateProperties.setProperty(propertyName, (InstancePropertyValue)mapPropertyValue);
            }
            return newTemplateProperties;
        }
        return null;
    }

    private String replacePrimitiveStringWithPlaceholders(PrimitivePropertyValue primitivePropertyValue, Map<String, String> placeholderProperties) {
        Object propertyValue = primitivePropertyValue.valueAsString();
        if (propertyValue == null || !((String)propertyValue).contains("{{")) {
            return propertyValue;
        }
        if (placeholderProperties != null && !placeholderProperties.isEmpty()) {
            for (String placeholderName : placeholderProperties.keySet()) {
                String placeholderMatchString = "{{" + placeholderName + "}}";
                if (((String)propertyValue).equals(placeholderMatchString)) {
                    return placeholderProperties.get(placeholderName);
                }
                String regExMatchString = Pattern.quote(placeholderMatchString);
                String[] configBits = ((String)propertyValue).split(regExMatchString);
                if (configBits.length == 1) {
                    if (((String)propertyValue).equals(configBits[0])) continue;
                    if (placeholderProperties.get(placeholderName) != null) {
                        propertyValue = configBits[0] + placeholderProperties.get(placeholderName);
                        continue;
                    }
                    propertyValue = configBits[0];
                    continue;
                }
                if (configBits.length <= 1) continue;
                StringBuilder newConfigString = new StringBuilder();
                boolean firstPart = true;
                for (String configBit : configBits) {
                    if (!firstPart && placeholderProperties.get(placeholderName) != null) {
                        newConfigString.append(placeholderProperties.get(placeholderName));
                    }
                    firstPart = false;
                    if (configBit == null) continue;
                    newConfigString.append(configBit);
                }
                if (((String)propertyValue).endsWith(placeholderMatchString) && placeholderProperties.get(placeholderName) != null) {
                    newConfigString.append(placeholderProperties.get(placeholderName));
                }
                propertyValue = newConfigString.toString();
            }
        }
        return propertyValue;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeGUID() {
        return this.typeGUID;
    }

    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        InstanceProperties properties = this.templateProperties;
        if (this.extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, properties, this.extendedProperties, methodName);
            }
            catch (InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        return this.setEffectivityDates(properties, this.effectiveFrom, this.effectiveTo);
    }

    public InstanceProperties getInstanceProperties(Map<String, InstancePropertyValue> propertyMap, Date effectiveFrom, Date effectiveTo) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        InstanceProperties properties = null;
        if (propertyMap != null && !propertyMap.isEmpty()) {
            properties = new InstanceProperties();
            properties.setInstanceProperties(propertyMap);
        }
        return this.setEffectivityDates(properties, effectiveFrom, effectiveTo);
    }

    protected InstanceProperties updateInstanceProperties(InstanceProperties properties, Map<String, InstancePropertyValue> propertyMap) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        if (propertyMap != null) {
            try {
                if (properties == null) {
                    return this.getInstanceProperties(propertyMap, null, null);
                }
                Map existingProperties = properties.getInstanceProperties();
                if (existingProperties == null) {
                    properties.setInstanceProperties(propertyMap);
                } else {
                    existingProperties.putAll(propertyMap);
                    properties.setInstanceProperties(existingProperties);
                }
            }
            catch (OCFCheckedExceptionBase error) {
                String propertyName = "properties";
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(error, "properties");
            }
        }
        return properties;
    }

    InstanceProperties setEffectivityDates(InstanceProperties properties, Date effectiveFrom, Date effectiveTo) {
        if (effectiveFrom != null || effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        return properties;
    }

    protected InstanceProperties setEffectivityDates(InstanceProperties properties) {
        if (this.effectiveFrom != null || this.effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(this.effectiveFrom);
            properties.setEffectiveToTime(this.effectiveTo);
        }
        return properties;
    }

    public List<Classification> getEntityClassifications() {
        ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
        if (this.newClassifications != null && !this.newClassifications.isEmpty()) {
            entityClassifications = new ArrayList<Classification>(this.newClassifications.values());
        }
        if (this.existingClassifications != null && !this.existingClassifications.isEmpty()) {
            for (Classification classification : entityClassifications) {
                if (classification == null || this.newClassifications.get(classification.getName()) != null) continue;
                entityClassifications.add(classification);
            }
        }
        if (entityClassifications.isEmpty()) {
            return null;
        }
        return entityClassifications;
    }
}

