/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadataobservability.ffdc.OpenMetadataObservabilityAuditCode;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataAPIGenericHandler<B>
extends OpenMetadataAPIAnchorHandler<B> {
    private static final Logger log = LoggerFactory.getLogger(OpenMetadataAPIGenericHandler.class);

    public OpenMetadataAPIGenericHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void addAnchorGUIDToBuilder(String userId, String anchorGUID, String anchorGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, List<String> serviceSuppliedSupportedZones, OpenMetadataAPIGenericBuilder builder, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail anchorEntity;
        if (anchorGUID != null && (anchorEntity = this.getEntityFromRepository(userId, anchorGUID, anchorGUIDParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, forLineage, forDuplicateProcessing, serviceSuppliedSupportedZones, effectiveTime, methodName)) != null) {
            builder.setAnchors(userId, anchorEntity.getGUID(), anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), methodName);
        }
    }

    protected boolean visibleToUserThroughRelationship(String userId, Relationship relationship, String methodName) {
        if (relationship == null) {
            return false;
        }
        String relationshipTypeName = null;
        if (relationship.getType() != null) {
            relationshipTypeName = relationship.getType().getTypeDefName();
        }
        if (relationshipTypeName == null) {
            return false;
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName)) {
            if (userId.equals(relationship.getCreatedBy())) {
                return true;
            }
            return this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, relationship.getProperties(), methodName);
        }
        return true;
    }

    private void validateRetrievedEntityIsVisible(String userId, EntityDetail connectToEntity, String connectToGUIDParameterName, String connectToType, boolean isExplicitGetRequest, List<String> suppliedSupportedZones, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.INFORMAL_TAG.typeName)) {
            if (!this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, connectToEntity.getProperties(), methodName) && !userId.equals(connectToEntity.getCreatedBy())) {
                this.invalidParameterHandler.throwUnknownElement(userId, connectToEntity.getGUID(), connectToType, this.serviceName, this.serverName, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.ASSET.typeName)) {
            this.invalidParameterHandler.validateAssetInSupportedZone(connectToEntity.getGUID(), connectToGUIDParameterName, suppliedSupportedZones, this.securityVerifier.getSupportedZones(userId, suppliedSupportedZones), this.serviceName, methodName);
        }
        this.securityVerifier.validateUserForElementRead(userId, connectToEntity, this.repositoryHelper, this.serviceName, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.ASSET.typeName)) {
            if (isExplicitGetRequest) {
                this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_READ.getMessageDefinition(new String[]{userId, connectToEntity.getType().getTypeDefName(), connectToEntity.getGUID(), methodName, this.serviceName}));
            } else {
                this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_SEARCH.getMessageDefinition(new String[]{userId, connectToEntity.getType().getTypeDefName(), connectToEntity.getGUID(), methodName, this.serviceName}));
            }
        }
    }

    public EntityDetail validateEntityAndAnchorForRead(String userId, String connectToGUID, String connectToGUIDParameterName, String connectToType, boolean isExplicitGetRequest, boolean isUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(connectToGUID, connectToGUIDParameterName, methodName);
        EntityDetail connectToEntity = this.repositoryHandler.getEntityByGUID(userId, connectToGUID, connectToGUIDParameterName, connectToType, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.validateEntityAndAnchorForRead(userId, connectToType, connectToEntity, connectToGUIDParameterName, isExplicitGetRequest, isUpdate, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
    }

    public EntityDetail validateEntityAndAnchorForRead(String userId, String connectToType, EntityDetail connectToEntity, String connectToGUIDParameterName, boolean isExplicitGetRequest, boolean isUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateObject((Object)connectToEntity, connectToGUIDParameterName, methodName);
        this.validateRetrievedEntityIsVisible(userId, connectToEntity, connectToGUIDParameterName, connectToType, isExplicitGetRequest, suppliedSupportedZones, methodName);
        OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDForEntity(connectToEntity, connectToGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.validateAnchorGUID(userId, connectToEntity, anchorIdentifiers, isExplicitGetRequest, isUpdate, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> validateEntitiesAndAnchorsForRead(String userId, List<EntityDetail> retrievedEntities, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) {
        if (retrievedEntities != null) {
            String connectToGUIDParameterName = "retrievedEntity.getGUID";
            HashMap<String, EntityDetail> visibleEntities = new HashMap<String, EntityDetail>();
            ArrayList<String> extractedAnchorGUIDs = new ArrayList<String>();
            HashMap<String, OpenMetadataAPIAnchorHandler.AnchorIdentifiers> extractedAnchors = new HashMap<String, OpenMetadataAPIAnchorHandler.AnchorIdentifiers>();
            ArrayList<PropertyCondition> anchorRetrievalQuery = new ArrayList<PropertyCondition>();
            for (EntityDetail connectToEntity : retrievedEntities) {
                if (connectToEntity == null) continue;
                try {
                    this.validateRetrievedEntityIsVisible(userId, connectToEntity, "retrievedEntity.getGUID", connectToEntity.getType().getTypeDefName(), false, suppliedSupportedZones, methodName);
                    visibleEntities.put(connectToEntity.getGUID(), connectToEntity);
                    OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDForEntity(connectToEntity, "retrievedEntity.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    if (anchorIdentifiers == null) continue;
                    extractedAnchors.put(connectToEntity.getGUID(), anchorIdentifiers);
                    if (anchorIdentifiers.anchorGUID != null) {
                        if (extractedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) continue;
                        PropertyCondition propertyCondition = new PropertyCondition();
                        propertyCondition.setProperty(OpenMetadataProperty.GUID.name);
                        propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                        primitivePropertyValue.setPrimitiveValue((Object)anchorIdentifiers.anchorGUID);
                        propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
                        anchorRetrievalQuery.add(propertyCondition);
                        extractedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
                        continue;
                    }
                    if (extractedAnchorGUIDs.contains(connectToEntity.getGUID())) continue;
                    extractedAnchorGUIDs.add(connectToEntity.getGUID());
                }
                catch (Exception anchorIdentifiers) {}
            }
            Map<String, EntityDetail> retrievedAnchors = this.getEntityList(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, anchorRetrievalQuery, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            ArrayList<String> validatedAnchors = new ArrayList<String>();
            ArrayList<EntityDetail> validatedEntities = new ArrayList<EntityDetail>();
            for (EntityDetail connectToEntity : visibleEntities.values()) {
                if (connectToEntity == null) continue;
                try {
                    OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = (OpenMetadataAPIAnchorHandler.AnchorIdentifiers)extractedAnchors.get(connectToEntity.getGUID());
                    if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
                        EntityDetail anchorEntity = retrievedAnchors.get(anchorIdentifiers.anchorGUID);
                        if (anchorEntity == null) {
                            this.validateAnchorGUID(userId, connectToEntity, anchorIdentifiers, false, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                            validatedAnchors.add(anchorIdentifiers.anchorGUID);
                        } else if (!validatedAnchors.contains(anchorEntity.getGUID())) {
                            this.validateAnchorEntity(userId, connectToEntity, anchorEntity, false, false, suppliedSupportedZones, methodName);
                            validatedAnchors.add(anchorEntity.getGUID());
                        }
                    }
                    validatedEntities.add(connectToEntity);
                }
                catch (Exception exception) {}
            }
            return validatedEntities;
        }
        return null;
    }

    public EntityDetail validateAnchorGUID(String userId, EntityDetail connectToEntity, OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers, boolean isExplicitGetRequest, boolean isUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorIdentifiers == null) {
            return null;
        }
        if (anchorIdentifiers.anchorGUID != null) {
            String anchorGUIDParameterName = "anchorIdentifiers";
            if (!anchorIdentifiers.anchorGUID.equals(connectToEntity.getGUID())) {
                EntityDetail anchorEntity = this.repositoryHandler.getEntityByGUID(userId, anchorIdentifiers.anchorGUID, "anchorIdentifiers", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.validateAnchorEntity(userId, connectToEntity, anchorEntity, isExplicitGetRequest, isUpdate, suppliedSupportedZones, methodName);
                return anchorEntity;
            }
            return connectToEntity;
        }
        return connectToEntity;
    }

    public void validateAnchorEntity(String userId, EntityDetail connectToEntity, EntityDetail anchorEntity, boolean isExplicitGetRequest, boolean isUpdate, List<String> suppliedSupportedZones, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceType anchorEntityType;
        String anchorGUIDParameterName = "anchorIdentifiers";
        if (anchorEntity != null && (anchorEntityType = anchorEntity.getType()) != null) {
            boolean isFeedbackEntity;
            String connectToType = connectToEntity.getType().getTypeDefName();
            boolean bl = isFeedbackEntity = this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.INFORMAL_TAG.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.COMMENT.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.RATING.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, connectToType, OpenMetadataType.LIKE.typeName);
            if (OpenMetadataType.ASSET.typeName.equals(anchorEntityType.getTypeDefName())) {
                this.invalidParameterHandler.validateAssetInSupportedZone(anchorEntity.getGUID(), "anchorIdentifiers", suppliedSupportedZones, this.securityVerifier.getSupportedZones(userId, suppliedSupportedZones), this.serviceName, methodName);
            }
            if (isFeedbackEntity) {
                this.securityVerifier.validateUserForAnchorAddFeedback(userId, anchorEntity, connectToEntity, this.repositoryHelper, this.serviceName, methodName);
            } else if (isUpdate) {
                this.securityVerifier.validateUserForAnchorMemberUpdate(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForAnchorMemberRead(userId, anchorEntity, connectToEntity, this.repositoryHelper, this.serviceName, methodName);
            }
            if (OpenMetadataType.ASSET.typeName.equals(anchorEntityType.getTypeDefName())) {
                if (isUpdate) {
                    if (isFeedbackEntity) {
                        this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE_FEEDBACK.getMessageDefinition(new String[]{userId, anchorEntityType.getTypeDefName(), anchorEntity.getGUID(), methodName, this.serviceName}));
                    } else {
                        this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE_ATTACHMENT.getMessageDefinition(new String[]{userId, anchorEntityType.getTypeDefName(), anchorEntity.getGUID(), methodName, this.serviceName}));
                    }
                } else if (isExplicitGetRequest) {
                    this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_READ_ATTACHMENT.getMessageDefinition(new String[]{userId, anchorEntityType.getTypeDefName(), anchorEntity.getGUID(), methodName, this.serviceName}));
                } else {
                    this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_SEARCH_ATTACHMENT.getMessageDefinition(new String[]{userId, anchorEntityType.getTypeDefName(), anchorEntity.getGUID(), methodName, this.serviceName}));
                }
            }
        }
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, boolean isMergeUpdate, Map<String, Object> classificationProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, classificationProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, instanceProperties, isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void setClassificationInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail beanEntity, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, InstanceProperties classificationProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (beanEntity != null) {
            int latestChangeActionOrdinal;
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (anchorEntity != null) {
                this.securityVerifier.validateUserForAnchorClassify(userId, anchorEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForElementClassify(userId, beanEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            }
            Classification existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName);
            if (existingClassification == null) {
                latestChangeActionOrdinal = 0;
                this.repositoryHandler.classifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, ClassificationOrigin.ASSIGNED, null, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                latestChangeActionOrdinal = 1;
                InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, classificationProperties, existingClassification.getProperties());
                if (newProperties == null && existingClassification.getProperties() == null) {
                    this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_CLASSIFICATION_UPDATE.getMessageDefinition(classificationTypeName, beanEntity.getGUID(), methodName, userId));
                    return;
                }
                if (newProperties != null && newProperties.equals((Object)existingClassification.getProperties())) {
                    this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_CLASSIFICATION_UPDATE.getMessageDefinition(classificationTypeName, beanEntity.getGUID(), methodName, userId));
                    return;
                }
                this.repositoryHandler.reclassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            String actionDescriptionTemplate = "Adding %s classification to %s %s";
            String actionDescription = String.format("Adding %s classification to %s %s", classificationTypeName, beanGUIDTypeName, beanEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, latestChangeActionOrdinal, classificationTypeName, beanEntity.getGUID(), beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 2, latestChangeActionOrdinal, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    Classification getExistingClassification(EntitySummary beanEntity, String classificationTypeName) {
        List existingClassifications;
        Classification existingClassification = null;
        if (beanEntity != null && (existingClassifications = beanEntity.getClassifications()) != null) {
            for (Classification classification : existingClassifications) {
                if (classification == null || !classificationTypeName.equals(classification.getName())) continue;
                existingClassification = classification;
            }
        }
        return existingClassification;
    }

    public void removeClassificationFromRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void removeClassificationFromRepository(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null) {
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (anchorEntity != null) {
                this.securityVerifier.validateUserForAnchorDeclassify(userId, anchorEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForElementDeclassify(userId, beanEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            }
            Classification existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName);
            if (existingClassification != null) {
                this.repositoryHandler.declassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                String actionDescriptionTemplate = "Removing %s classification from %s %s";
                String actionDescription = String.format("Removing %s classification from %s %s", classificationTypeName, beanGUIDTypeName, beanGUID);
                if (anchorEntity != null) {
                    this.addLatestChangeToAnchor(anchorEntity, 7, 2, classificationTypeName, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(beanEntity, 2, 2, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
        }
    }

    public void updateClassificationEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null) {
            if (anchorEntity != null) {
                this.securityVerifier.validateUserForAnchorClassify(userId, anchorEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForElementClassify(userId, beanEntity, classificationTypeName, this.repositoryHelper, this.serviceName, methodName);
            }
            Classification existingClassification = this.getExistingClassification((EntitySummary)beanEntity, classificationTypeName);
            this.invalidParameterHandler.validateObject((Object)existingClassification, classificationTypeName, methodName);
            int latestChangeActionOrdinal = 1;
            InstanceProperties newProperties = existingClassification.getProperties();
            if (newProperties == null) {
                newProperties = new InstanceProperties();
            }
            this.repositoryHandler.reclassifyEntity(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, (InstanceAuditHeader)existingClassification, this.setUpEffectiveDates(newProperties, effectiveFrom, effectiveTo), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String actionDescriptionTemplate = "Updating effectivity dates for %s classification to %s %s";
            String actionDescription = String.format("Updating effectivity dates for %s classification to %s %s", classificationTypeName, beanGUIDTypeName, beanGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, latestChangeActionOrdinal, classificationTypeName, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 2, latestChangeActionOrdinal, classificationTypeName, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateBeanEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeGUID, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(beanGUID, beanGUIDParameterName, methodName);
        EntityDetail beanEntity = this.getEntityFromRepository(userId, beanGUID, beanGUIDParameterName, beanGUIDTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, beanGUIDTypeName, beanEntity, beanGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (beanEntity != null) {
            InstanceProperties newProperties = this.setUpEffectiveDates(null, effectiveFrom, effectiveTo);
            if (anchorEntity != null) {
                this.securityVerifier.validateUserForAnchorMemberUpdate(userId, anchorEntity, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForElementDetailUpdate(userId, beanEntity, newProperties, this.repositoryHelper, this.serviceName, methodName);
            }
            this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, beanEntity.getGUID(), beanEntity, beanGUIDTypeGUID, beanGUIDTypeName, newProperties, methodName);
            String actionDescriptionTemplate = "Updating effectivity dates for %s %s";
            String actionDescription = String.format("Updating effectivity dates for %s %s", beanGUIDTypeName, beanGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, beanGUID, beanGUIDTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(methodName, beanEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(beanEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private InstanceProperties setUpNewProperties(boolean isMergeUpdate, InstanceProperties suppliedProperties, InstanceProperties existingProperties) {
        InstanceProperties newProperties;
        if (isMergeUpdate) {
            newProperties = existingProperties;
            if (newProperties == null) {
                newProperties = suppliedProperties;
            } else if (suppliedProperties != null) {
                Map propertyMap = suppliedProperties.getInstanceProperties();
                for (String propertyName : propertyMap.keySet()) {
                    if (propertyName == null) continue;
                    newProperties.setProperty(propertyName, (InstancePropertyValue)propertyMap.get(propertyName));
                }
                if (suppliedProperties.getEffectiveFromTime() != null) {
                    newProperties.setEffectiveFromTime(suppliedProperties.getEffectiveFromTime());
                }
                if (suppliedProperties.getEffectiveToTime() != null) {
                    newProperties.setEffectiveToTime(suppliedProperties.getEffectiveToTime());
                }
            }
        } else {
            newProperties = suppliedProperties;
            if (existingProperties != null) {
                if (existingProperties.getEffectiveFromTime() != null) {
                    newProperties.setEffectiveFromTime(existingProperties.getEffectiveFromTime());
                }
                if (existingProperties.getEffectiveToTime() != null) {
                    newProperties.setEffectiveToTime(existingProperties.getEffectiveToTime());
                }
            }
        }
        return newProperties;
    }

    private Map<String, EntityDetail> getEntityList(String userId, String typeGUID, List<PropertyCondition> conditions, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) {
        HashMap<String, EntityDetail> retrievedAnchors = new HashMap<String, EntityDetail>();
        if (!conditions.isEmpty()) {
            SearchProperties searchProperties = new SearchProperties();
            searchProperties.setConditions(conditions);
            searchProperties.setMatchCriteria(MatchCriteria.ANY);
            try {
                List retrievedEntities = this.repositoryHandler.findEntities(userId, typeGUID, null, searchProperties, null, null, null, null, SequencingOrder.GUID, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
                if (retrievedEntities != null) {
                    for (EntityDetail entity : retrievedEntities) {
                        if (entity == null) continue;
                        retrievedAnchors.put(entity.getGUID(), entity);
                    }
                }
            }
            catch (Exception error) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.FAILED_TO_RETRIEVE_ENTITIES.getMessageDefinition(methodName, error.getClass().getName(), error.getMessage()));
            }
        }
        return retrievedAnchors;
    }

    public void validateUniqueProperty(String entityGUID, String entityTypeName, String uniqueParameterValue, String uniqueParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> existingEntities;
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(uniqueParameterName);
        String owningEntityTypeGUID = null;
        String owningEntityTypeName = null;
        String entityTypeNameToCheck = entityTypeName;
        while (owningEntityTypeGUID == null) {
            TypeDefLink superTypeDefLink;
            TypeDef potentialOwningEntityTypeDef = this.repositoryHelper.getTypeDefByName(methodName, entityTypeNameToCheck);
            List typeDefAttributes = potentialOwningEntityTypeDef.getPropertiesDefinition();
            if (typeDefAttributes != null && !typeDefAttributes.isEmpty()) {
                for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                    if (!typeDefAttribute.isUnique() || !typeDefAttribute.getAttributeName().equals(uniqueParameterName)) continue;
                    owningEntityTypeGUID = potentialOwningEntityTypeDef.getGUID();
                    owningEntityTypeName = potentialOwningEntityTypeDef.getName();
                    break;
                }
            }
            if ((superTypeDefLink = potentialOwningEntityTypeDef.getSuperType()) == null) break;
            entityTypeNameToCheck = superTypeDefLink.getName();
        }
        if ((existingEntities = this.getEntitiesByValue(this.localServerUserId, uniqueParameterValue, uniqueParameterName, owningEntityTypeGUID, owningEntityTypeName, propertyNames, true, false, null, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) != null && !existingEntities.isEmpty()) {
            if (entityGUID != null) {
                for (EntityDetail existingEntity : existingEntities) {
                    if (existingEntity == null || entityGUID.equals(existingEntity.getGUID())) continue;
                    this.invalidParameterHandler.throwUniqueNameInUse(uniqueParameterValue, uniqueParameterName, entityTypeName, this.serviceName, methodName);
                }
            } else {
                this.invalidParameterHandler.throwUniqueNameInUse(uniqueParameterValue, uniqueParameterName, entityTypeName, this.serviceName, methodName);
            }
        }
    }

    private void validateUniqueProperties(String entityGUID, String entityTypeName, InstanceProperties newProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Iterator uniquePropertyNames;
        InstanceProperties uniqueProperties = this.repositoryHelper.getUniqueProperties(this.serviceName, entityTypeName, newProperties);
        if (uniqueProperties != null && uniqueProperties.getPropertyCount() > 0 && (uniquePropertyNames = uniqueProperties.getPropertyNames()) != null) {
            while (uniquePropertyNames.hasNext()) {
                String uniquePropertyName = (String)uniquePropertyNames.next();
                if (uniquePropertyName == null) continue;
                InstancePropertyValue uniquePropertyValue = uniqueProperties.getPropertyValue(uniquePropertyName);
                this.validateUniqueProperty(entityGUID, entityTypeName, uniquePropertyValue.valueAsString(), uniquePropertyName, effectiveTime, methodName);
            }
        }
    }

    void validateNewEntityRequest(String userId, String entityTypeGUID, String entityTypeName, InstanceProperties newProperties, List<Classification> classifications, InstanceStatus instanceStatus, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.validateUniqueProperties(null, entityTypeName, newProperties, effectiveTime, methodName);
        this.securityVerifier.validateUserForElementCreate(userId, entityTypeGUID, entityTypeName, newProperties, classifications, instanceStatus, this.repositoryHelper, this.serviceName, methodName);
    }

    private InstanceProperties getLatestChangeClassificationProperties(int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, String methodName) throws TypeErrorException {
        InstanceProperties properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CHANGE_TARGET.name, "a0b7d7a0-4af5-4539-9b81-cbef52d8cc5d", "LatestChangeTarget", latestChangeTargetOrdinal, methodName);
        properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CHANGE_ACTION.name, "032d844b-868f-4c4a-bc5d-81f0f9704c4d", "LatestChangeAction", latestChangeActionOrdinal, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CLASSIFICATION_NAME.name, classificationName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ATTACHMENT_GUID.name, attachmentGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ATTACHMENT_TYPE.name, attachmentTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RELATIONSHIP_TYPE.name, relationshipTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USER.name, userId, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_DESCRIPTION.name, actionDescription, methodName);
        return properties;
    }

    private void addLatestChangeToAnchor(EntityDetail anchorEntity, int latestChangeTargetOrdinal, int latestChangeActionOrdinal, String classificationName, String attachmentGUID, String attachmentTypeName, String relationshipTypeName, String userId, String actionDescription, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        OpenMetadataAPIAnchorHandler.AnchorIdentifiers parentAnchorIdentifiers;
        String guidParameterName = "anchorEntity.getGUID()";
        InstanceProperties newProperties = null;
        String anchorTypeName = anchorEntity.getType().getTypeDefName();
        if ((this.repositoryHelper.isTypeOf(this.serviceName, anchorTypeName, OpenMetadataType.ASSET.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, anchorTypeName, OpenMetadataType.ROOT_SCHEMA_TYPE.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, anchorTypeName, "Glossary")) && !OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classificationName)) {
            try {
                this.invalidParameterHandler.validateObject((Object)anchorEntity, "anchorEntity.getGUID()", methodName);
                newProperties = this.getLatestChangeClassificationProperties(latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, methodName);
                Classification classification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)anchorEntity, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, methodName);
                if (classification != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), "anchorEntity.getGUID()", anchorEntity.getType().getTypeDefName(), OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeGUID, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, (InstanceAuditHeader)classification, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (ClassificationErrorException newClassificationNeeded) {
                try {
                    this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, anchorEntity.getGUID(), anchorEntity, "anchorEntity.getGUID()", anchorEntity.getType().getTypeDefName(), OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeGUID, OpenMetadataType.LATEST_CHANGE_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, newProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                catch (PropertyServerException propertyServerException) {}
            }
            catch (PropertyServerException newClassificationNeeded) {
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | TypeErrorException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
        }
        if ((parentAnchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)anchorEntity, methodName)) != null && !anchorEntity.getGUID().equals(parentAnchorIdentifiers.anchorGUID)) {
            try {
                String parentAnchorGUIDParameterName = "parentAnchorGUID";
                EntityDetail parentAnchorEntity = this.repositoryHandler.getEntityByGUID(userId, parentAnchorIdentifiers.anchorGUID, "parentAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                this.addLatestChangeToAnchor(parentAnchorEntity, latestChangeTargetOrdinal, latestChangeActionOrdinal, classificationName, attachmentGUID, attachmentTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
                throw new PropertyServerException((OCFCheckedExceptionBase)error);
            }
        }
    }

    private String getSupplementaryPropertiesGlossary(boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryGUID = this.getEntityGUIDByValue(this.localServerUserId, "Supplementary Properties Glossary", "supplementaryPropertiesGlossaryName", "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", this.qualifiedNamePropertyNamesList, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryGUID == null) {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, "Supplementary Properties Glossary", methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, "Supplementary Properties Glossary", methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, "This glossary contains glossary terms containing the business-oriented descriptive names and related properties for open metadata assets.", methodName);
            glossaryGUID = this.repositoryHandler.createEntity(this.localServerUserId, "36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", null, null, properties, null, InstanceStatus.ACTIVE, methodName);
        }
        return glossaryGUID;
    }

    private InstanceProperties getSupplementaryInstanceProperties(InstanceProperties existingProperties, String qualifiedName, String displayName, String summary, String description, String abbreviation, String usage, String methodName) {
        InstanceProperties properties = existingProperties;
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUMMARY.name, summary, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ABBREVIATION.name, abbreviation, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, usage, methodName);
        return properties;
    }

    public void maintainSupplementaryProperties(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String elementDomainName, String elementQualifiedName, String displayName, String summary, String description, String abbreviation, String usage, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail glossaryTerm = this.getAttachedEntity(this.localServerUserId, elementGUID, elementGUIDParameterName, elementTypeName, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", OpenMetadataType.GLOSSARY_TERM.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (glossaryTerm == null) {
            String glossaryGUID;
            InstanceProperties glossaryTermProperties;
            if ((displayName != null || summary != null || description != null || abbreviation != null || usage != null) && (glossaryTermProperties = this.getSupplementaryInstanceProperties(null, elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName)) != null && (glossaryGUID = this.getSupplementaryPropertiesGlossary(forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                ArrayList<Classification> initialClassifications = new ArrayList<Classification>();
                try {
                    InstanceProperties classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANCHOR_GUID.name, elementGUID, methodName);
                    classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, elementTypeName, methodName);
                    classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, elementDomainName, methodName);
                    Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, OpenMetadataType.GLOSSARY_TERM.typeName, ClassificationOrigin.ASSIGNED, null, classificationProperties);
                    initialClassifications.add(classification);
                    classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "ElementSupplement", OpenMetadataType.GLOSSARY_TERM.typeName, ClassificationOrigin.ASSIGNED, null, null);
                    initialClassifications.add(classification);
                }
                catch (TypeErrorException error) {
                    throw new PropertyServerException((OCFCheckedExceptionBase)error);
                }
                String glossaryTermGUID = this.repositoryHandler.createEntity(this.localServerUserId, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, glossaryTermProperties, initialClassifications, InstanceStatus.ACTIVE, methodName);
                this.repositoryHandler.createRelationship(userId, OpenMetadataType.TERM_ANCHOR.typeGUID, null, null, glossaryGUID, glossaryTermGUID, null, methodName);
                this.repositoryHandler.createRelationship(userId, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", null, null, elementGUID, glossaryTermGUID, null, methodName);
            }
        } else {
            InstanceProperties glossaryTermProperties = isMergeUpdate ? this.getSupplementaryInstanceProperties(glossaryTerm.getProperties(), elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName) : this.getSupplementaryInstanceProperties(null, elementQualifiedName + " Supplementary Properties", displayName, summary, description, abbreviation, usage, methodName);
            this.repositoryHandler.updateEntityProperties(userId, null, null, glossaryTerm.getGUID(), glossaryTerm, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, glossaryTermProperties, methodName);
        }
    }

    public EntityDetail getSupplementaryProperties(String elementGUID, String elementGUIDParameterName, String elementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedEntity(this.localServerUserId, elementGUID, elementGUIDParameterName, elementTypeName, "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", OpenMetadataType.GLOSSARY_TERM.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String createBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityTypeGUID, String entityTypeName, OpenMetadataAPIGenericBuilder propertyBuilder, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, entityTypeGUID, entityTypeName, null, propertyBuilder, false, effectiveTime, methodName);
    }

    public String createBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityTypeGUID, String entityTypeName, String entityDomainName, OpenMetadataAPIGenericBuilder propertyBuilder, boolean isOwnAnchor, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (isOwnAnchor) {
            propertyBuilder.setAnchors(userId, null, entityTypeName, entityDomainName, methodName);
        }
        this.validateNewEntityRequest(userId, entityTypeGUID, entityTypeName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(), propertyBuilder.getInstanceStatus(), effectiveTime, methodName);
        String entityGUID = this.repositoryHandler.createEntity(userId, entityTypeGUID, entityTypeName, externalSourceGUID, externalSourceName, propertyBuilder.getInstanceProperties(methodName), propertyBuilder.getEntityClassifications(), propertyBuilder.getInstanceStatus(), methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.ASSET.typeName)) {
            this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_CREATE.getMessageDefinition(new String[]{userId, entityTypeName, entityGUID, methodName, this.serviceName}));
        }
        return entityGUID;
    }

    public void updateBeanPropertyInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String propertyName, String propertyValue, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyParameterName = "propertyValue";
        String propertyNameParameterName = "propertyName";
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        this.invalidParameterHandler.validateObject((Object)propertyValue, "propertyValue", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, propertyName, propertyValue, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, true, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, InstanceProperties properties, boolean isMergeUpdate, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, false, false, (List<String>)this.supportedZones, properties, isMergeUpdate, new Date(), methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, updateProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, updateProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail originalEntity, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceProperties updateProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, updateProperties, originalEntity.getProperties());
            if (newProperties == null && originalEntity.getProperties() == null) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_ENTITY_UPDATE.getMessageDefinition(originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, userId));
                return;
            }
            if (newProperties != null && newProperties.equals((Object)originalEntity.getProperties())) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_ENTITY_UPDATE.getMessageDefinition(originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, userId));
                return;
            }
            this.validateUniqueProperties(originalEntity.getGUID(), entityTypeName, updateProperties, effectiveTime, methodName);
            this.securityVerifier.validateUserForElementDetailUpdate(userId, originalEntity, newProperties, this.repositoryHelper, this.serviceName, methodName);
            this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), originalEntity, entityTypeGUID, entityTypeName, newProperties, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE.getMessageDefinition(new String[]{userId, originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, this.serviceName}));
            }
            String actionDescriptionTemplate = "Updating properties in %s %s";
            String actionDescription = String.format("Updating properties in %s %s", entityTypeName, originalEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, originalEntity.getGUID(), entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            String entityGUID = "<null>";
            if (originalEntity != null) {
                entityGUID = originalEntity.getGUID();
            }
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    public void updateBeanStatusInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, InstanceStatus newStatus, String newStatusParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, forLineage, forDuplicateProcessing, this.supportedZones, newStatus, newStatusParameterName, effectiveTime, methodName);
    }

    public void updateBeanStatusInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceStatus newStatus, String newStatusParameterName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail originalEntity;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)newStatus, newStatusParameterName, methodName);
        if (newStatus == InstanceStatus.DELETED || newStatus == InstanceStatus.UNKNOWN) {
            this.invalidParameterHandler.throwInvalidParameter((Object)newStatus, newStatusParameterName, methodName);
        }
        if ((originalEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.securityVerifier.validateUserForAnchorMemberStatusUpdate(userId, anchorEntity, originalEntity, newStatus, this.repositoryHelper, this.serviceName, methodName);
            this.repositoryHandler.updateEntityStatus(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), originalEntity, entityTypeGUID, entityTypeName, newStatus, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE.getMessageDefinition(new String[]{userId, originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, this.serviceName}));
            }
            String actionDescriptionTemplate = "Updating instance status in %s %s";
            String actionDescription = String.format("Updating instance status in %s %s", entityTypeName, entityGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 5, 1, null, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 0, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.undoBeanUpdateInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.undoBeanUpdateInRepository(userId, externalSourceGUID, externalSourceName, startingEntity, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B undoBeanUpdateInRepository(String userId, String externalSourceGUID, String externalSourceName, EntityDetail originalEntity, String entityGUIDParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String originalEntityParameterName = "originalEntity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (originalEntity != null && originalEntity.getType() != null) {
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityTypeName, originalEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            EntityDetail recoveredEntity = this.repositoryHandler.undoEntityUpdate(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), methodName);
            try {
                this.securityVerifier.validateUserForElementDetailUpdate(userId, originalEntity, recoveredEntity.getProperties(), this.repositoryHelper, this.serviceName, methodName);
            }
            catch (UserNotAuthorizedException notAuth) {
                this.repositoryHandler.updateEntity(userId, externalSourceGUID, externalSourceName, originalEntity.getGUID(), "originalEntity", originalEntity.getType().getTypeDefGUID(), originalEntity.getType().getTypeDefName(), originalEntity.getProperties(), originalEntity.getClassifications(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                throw notAuth;
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, originalEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName)) {
                this.auditLog.logMessage("userAssetMonitoring", OpenMetadataObservabilityAuditCode.ASSET_ACTIVITY_UPDATE.getMessageDefinition(new String[]{userId, originalEntity.getType().getTypeDefName(), originalEntity.getGUID(), methodName, this.serviceName}));
            }
            String actionDescriptionTemplate = "Undo last update of properties in %s %s";
            String actionDescription = String.format("Undo last update of properties in %s %s", entityTypeName, originalEntity.getGUID());
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 6, 1, null, originalEntity.getGUID(), entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(originalEntity, 1, 1, null, null, null, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (recoveredEntity != null) {
                return this.converter.getNewBean(this.beanClass, recoveredEntity, methodName);
            }
        } else {
            String entityGUID = "<null>";
            if (originalEntity != null) {
                entityGUID = originalEntity.getGUID();
            }
            this.invalidParameterHandler.throwUnknownElement(userId, entityGUID, entityTypeName, this.serviceName, this.serverName, methodName);
        }
        return null;
    }

    private void archiveAnchoredEntity(String userId, String externalSourceGUID, String externalSourceName, EntityDetail anchorEntity, EntityProxy potentialAnchoredEntity, String classificationOriginGUID, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorEntity != null) {
            EntityDetail entity;
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers;
            String guidParameterName = "potentialAnchoredEntity";
            if (potentialAnchoredEntity != null && potentialAnchoredEntity.getType() != null && (anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)(entity = this.repositoryHandler.getEntityByGUID(userId, potentialAnchoredEntity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)), methodName)) != null && anchorIdentifiers.anchorGUID.equals(anchorEntity.getGUID())) {
                this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefName(), ClassificationOrigin.PROPAGATED, classificationOriginGUID, classificationProperties, anchorEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, classificationProperties, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, InstanceProperties classificationProperties, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityGUID, entityGUIDParameterName, entityTypeName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        this.invalidParameterHandler.validateAnchorGUID(entityGUID, entityGUIDParameterName, anchorEntity, entityGUID, entityTypeName, methodName);
        EntityDetail entity = this.archiveBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeName, ClassificationOrigin.ASSIGNED, entityGUID, classificationProperties, anchorEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
            String actionDescriptionTemplate = "Classifying as Memento %s %s";
            String actionDescription = String.format("Classifying as Memento %s %s", entityTypeName, entityGUID);
            if (anchorEntity != null) {
                this.addLatestChangeToAnchor(anchorEntity, 7, 0, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (entity != null) {
                this.addLatestChangeToAnchor(entity, 2, 0, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    private EntityDetail archiveBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties, EntityDetail anchorEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail targetEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (targetEntity != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, targetEntity, entityTypeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (anchorEntity == null) {
                    this.archiveAnchoredEntity(userId, externalSourceGUID, externalSourceName, targetEntity, this.repositoryHandler.getOtherEnd(targetEntity.getGUID(), entityTypeName, relationship, 0, methodName), classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    continue;
                }
                this.archiveAnchoredEntity(userId, externalSourceGUID, externalSourceName, anchorEntity, this.repositoryHandler.getOtherEnd(targetEntity.getGUID(), entityTypeName, relationship, 0, methodName), classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.repositoryHandler.classifyEntity(userId, null, null, targetEntity.getGUID(), targetEntity, entityGUIDParameterName, entityTypeName, OpenMetadataType.MEMENTO_CLASSIFICATION.typeGUID, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, classificationOrigin, classificationOriginGUID, classificationProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                String qualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, targetEntity.getProperties(), methodName) + "_archivedOn_" + new Date();
                String entityTypeGUID = this.invalidParameterHandler.validateTypeName(entityTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
                this.updateBeanPropertyInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return targetEntity;
    }

    public void deleteAnchoredEntity(List<String> anchoredEntityGUIDs, String externalSourceGUID, String externalSourceName, EntityProxy potentialAnchoredEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchoredEntityGUIDs != null && !anchoredEntityGUIDs.isEmpty()) {
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers derivedAnchorGUID;
            String entityTypeName;
            String entityGUID;
            EntityDetail entity;
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers;
            String guidParameterName = "potentialAnchoredEntity";
            if (potentialAnchoredEntity != null && potentialAnchoredEntity.getType() != null && (anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)(entity = this.repositoryHandler.getEntityByGUID(this.localServerUserId, entityGUID = potentialAnchoredEntity.getGUID(), "potentialAnchoredEntity", entityTypeName = potentialAnchoredEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)), methodName)) != null && anchoredEntityGUIDs.contains(anchorIdentifiers.anchorGUID) && (derivedAnchorGUID = this.deriveAnchorGUID(entity.getGUID(), entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) {
                this.deleteBeanInRepository(this.localServerUserId, externalSourceGUID, externalSourceName, entity.getGUID(), "potentialAnchoredEntity", potentialAnchoredEntity.getType().getTypeDefGUID(), potentialAnchoredEntity.getType().getTypeDefName(), null, null, anchoredEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityTypeName, entity, entityGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
        if (anchorEntity != null) {
            anchorEntityGUIDs.add(anchorEntity.getGUID());
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (!entityGUID.equals(anchorEntity.getGUID())) {
                String actionDescriptionTemplate = "Deleting %s %s";
                String actionDescription = String.format("Deleting %s %s", entityTypeName, entityGUID);
                int latestChangeTarget = 4;
                this.addLatestChangeToAnchor(anchorEntity, latestChangeTarget, 2, null, entityGUID, entityTypeName, null, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            anchorEntityGUIDs.add(entity.getGUID());
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void deleteBeanInRepository(String userId, String externalSourceGUID, String externalSourceName, String entityGUID, String entityGUIDParameterName, String entityTypeGUID, String entityTypeName, String validatingPropertyName, String validatingPropertyValue, List<String> anchorEntityGUIDs, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (anchorEntityGUIDs == null) {
            anchorEntityGUIDs = new ArrayList<String>();
        }
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, entityGUID, entityGUIDParameterName, entityTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, entityTypeName, startingEntity, entityGUIDParameterName, true, true, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
        if (anchorEntity != null && anchorEntity.getGUID().equals(startingEntity.getGUID())) {
            this.securityVerifier.validateUserForElementDelete(userId, startingEntity, this.repositoryHelper, this.serviceName, methodName);
        } else {
            this.securityVerifier.validateUserForAnchorMemberDelete(userId, anchorEntity, startingEntity, this.repositoryHelper, this.serviceName, methodName);
        }
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntity, entityTypeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            this.deleteAnchoredEntity(anchorEntityGUIDs, externalSourceGUID, externalSourceName, this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), entityTypeName, relationship, 0, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.repositoryHandler.removeEntity(userId, externalSourceGUID, externalSourceName, entityGUID, entityGUIDParameterName, entityTypeGUID, entityTypeName, validatingPropertyName, validatingPropertyValue, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelatedEntityGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, relationshipPath, relatedEntityTypeName, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public void updateRelationshipEffectivityDates(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipGUIDTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipTypeParameterName = "relationshipGUIDTypeName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(relationshipGUIDTypeName, "relationshipGUIDTypeName", methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipGUIDTypeName, effectiveTime, methodName);
        if (relationship != null) {
            InstanceProperties newProperties = this.setUpEffectiveDates(relationship.getProperties(), effectiveFrom, effectiveTo);
            this.validateRelationshipChange(userId, relationship, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationshipGUID, newProperties, methodName);
        }
    }

    protected void validateRelationship(String userId, Relationship relationship, List<String> validatedAnchorGUIDs, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            this.validateEntityProxyAnchor(userId, relationship.getEntityOneProxy(), "relationship.getEntityOneProxy().getGUID()", validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.validateEntityProxyAnchor(userId, relationship.getEntityTwoProxy(), "relationship.getEntityTwoProxy().getGUID()", validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
    }

    private void validateEntityProxyAnchor(String userId, EntityProxy entityProxy, String entityProxyParameterName, List<String> validatedAnchorGUIDs, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entityProxy, methodName);
        if (anchorIdentifiers == null) {
            EntityDetail connectToEntity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), entityProxyParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            anchorIdentifiers = this.getAnchorGUIDFromAnchorsClassification((EntitySummary)entityProxy, methodName);
            if (anchorIdentifiers == null || anchorIdentifiers.anchorGUID == null || !validatedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) {
                this.validateEntityAndAnchorForRead(userId, entityProxyParameterName, connectToEntity, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null) {
                    validatedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
                }
            }
        } else if (anchorIdentifiers.anchorGUID == null || !validatedAnchorGUIDs.contains(anchorIdentifiers.anchorGUID)) {
            this.validateEntityAndAnchorForRead(userId, entityProxy.getGUID(), entityProxyParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (anchorIdentifiers.anchorGUID != null) {
                validatedAnchorGUIDs.add(anchorIdentifiers.anchorGUID);
            }
        }
    }

    private void validateRelationshipChange(String userId, Relationship relationship, boolean isDelete, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            String relationshipGUIDTypeName = relationship.getType().getTypeDefName();
            EntityDetail bean1Entity = this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail anchor1Entity = this.validateEntityAndAnchorForRead(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, bean1Entity, "relationship.getEntityOneProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            EntityDetail bean2Entity = this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail anchor2Entity = this.validateEntityAndAnchorForRead(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeName, bean2Entity, "relationship.getEntityTwoProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipGUIDTypeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipGUIDTypeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipGUIDTypeName, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationshipGUIDTypeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName)) {
                if (anchor1Entity != null) {
                    if (isDelete) {
                        this.securityVerifier.validateUserForAnchorDeleteFeedback(userId, anchor1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                    } else {
                        this.securityVerifier.validateUserForAnchorAddFeedback(userId, anchor1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                    }
                } else if (isDelete) {
                    this.securityVerifier.validateUserForElementDeleteFeedback(userId, bean1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                } else {
                    this.securityVerifier.validateUserForElementAddFeedback(userId, bean1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                }
            } else if (anchor1Entity != null) {
                if (anchor1Entity.getGUID().equals(anchor2Entity.getGUID())) {
                    this.securityVerifier.validateUserForAnchorMemberUpdate(userId, anchor1Entity, this.repositoryHelper, this.serviceName, methodName);
                } else if (isDelete) {
                    this.securityVerifier.validateUserForAnchorDetach(userId, anchor1Entity, bean2Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
                } else {
                    this.securityVerifier.validateUserForAnchorAttach(userId, anchor1Entity, bean2Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
                }
            } else if (anchor2Entity == null) {
                if (isDelete) {
                    this.securityVerifier.validateUserForElementDetach(userId, bean1Entity, bean2Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
                } else {
                    this.securityVerifier.validateUserForElementAttach(userId, bean1Entity, bean2Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
                }
            } else if (isDelete) {
                this.securityVerifier.validateUserForAnchorDetach(userId, anchor2Entity, bean1Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForAnchorAttach(userId, anchor2Entity, bean1Entity, relationshipGUIDTypeName, this.repositoryHelper, this.serviceName, methodName);
            }
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, relationship.getGUID(), relationship.getType().getTypeDefName(), this.serviceName, this.serverName, methodName);
        }
    }

    public void updateRelationshipProperties(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean isMergeUpdate, InstanceProperties relationshipProperties, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (relationship != null) {
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            this.validateRelationshipChange(userId, relationship, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (newProperties == null && relationship.getProperties() == null) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_RELATIONSHIP_UPDATE.getMessageDefinition(relationship.getType().getTypeDefName(), relationship.getGUID(), methodName, userId));
                return;
            }
            if (newProperties != null && newProperties.equals((Object)relationship.getProperties())) {
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.IGNORING_UNNECESSARY_RELATIONSHIP_UPDATE.getMessageDefinition(relationship.getType().getTypeDefName(), relationship.getGUID(), methodName, userId));
                return;
            }
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
        }
    }

    public void deleteRelationship(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (relationship != null) {
            this.validateRelationshipChange(userId, relationship, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
    }

    List<String> getRelatedEntityGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<String> relationshipPath, String relatedEntityTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public Relationship getAttachmentLink(String userId, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLink(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, null, false, false, this.supportedZones, effectiveTime, methodName);
    }

    public Relationship getAttachmentLink(String userId, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = asOfTime == null ? this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName) : this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, asOfTime, effectiveTime, methodName);
        if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
            String entityOneParameterName = "relationship.getEntityOneProxy().getGUID()";
            String entityTwoParameterName = "relationship.getEntityTwoProxy().getGUID()";
            this.validateEntityAndAnchorForRead(userId, relationship.getEntityOneProxy().getGUID(), "relationship.getEntityOneProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.validateEntityAndAnchorForRead(userId, relationship.getEntityTwoProxy().getGUID(), "relationship.getEntityTwoProxy().getGUID()", OpenMetadataType.OPEN_METADATA_ROOT.typeName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            return relationship;
        }
        return null;
    }

    public Relationship getUniqueAttachmentLink(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getUniqueAttachmentLink(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public Relationship getUniqueAttachmentLink(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        if (relationships.size() == 1) {
            return relationships.get(0);
        }
        this.errorHandler.handleAmbiguousRelationships(startingGUID, startingTypeName, attachmentRelationshipTypeName, relationships, methodName);
        return null;
    }

    public List<Relationship> getAllAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, null, null, 0, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.getEntityFromRepository(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getAttachmentLinks(userId, startingEntity, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityGUID, attachmentEntityTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<Relationship> getAttachmentLinks(String userId, EntityDetail startingEntity, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityGUID, String attachmentEntityTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)startingEntity, startingGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List retrievedRelationships = this.repositoryHandler.getRelationshipsByType(userId, startingEntity, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, startingFrom, queryPageSize, effectiveTime, methodName);
        if (retrievedRelationships == null) {
            return null;
        }
        Map<String, EntityDetail> retrievedEntities = this.getValidatedEntities(userId, startingEntity.getGUID(), startingEntity.getType().getTypeDefName(), retrievedRelationships, attachmentEntityTypeName, null, null, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        if (retrievedEntities != null) {
            retrievedEntities.put(startingEntity.getGUID(), startingEntity);
            for (Relationship relationship : retrievedRelationships) {
                if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
                EntityProxy otherEnd = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingTypeName, relationship, attachmentEntityEnd, methodName);
                if (this.repositoryHelper.isTypeOf(this.serviceName, otherEnd.getType().getTypeDefName(), attachmentEntityTypeName)) {
                    if (attachmentEntityGUID == null || attachmentEntityGUID.equals(otherEnd.getGUID())) {
                        EntityDetail retrievedEntity = retrievedEntities.get(otherEnd.getGUID());
                        if (retrievedEntity != null) {
                            log.debug("Accepting relationship: " + relationship.getGUID());
                            results.add(relationship);
                            continue;
                        }
                        log.debug("Ignoring relationship as other end is not authorized: " + relationship.getGUID());
                        continue;
                    }
                    log.debug("Ignoring relationship based on entity instance: " + relationship.getGUID());
                    continue;
                }
                log.debug("Ignoring relationship based on type of attachment: " + relationship.getGUID());
            }
        }
        return results;
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, String guidParameterName, Date fromTime, Date toTime, int startingFrom, int pageSize, HistorySequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        List relationships = this.repositoryHandler.getRelationshipHistory(userId, guid, fromTime, toTime, startingFrom, pageSize, sequencingOrder, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                this.validateRelationship(userId, relationship, new ArrayList<String>(), forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                break;
            }
        }
        return relationships;
    }

    public List<Relationship> findAttachmentLinks(String userId, String relationshipTypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List retrievedRelationships;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        if ((retrievedRelationships = this.repositoryHandler.findRelationships(userId, relationshipTypeGUID, null, searchProperties, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forDuplicateProcessing, startingFrom, queryPageSize, effectiveTime, methodName)) != null) {
            ArrayList<Relationship> results = new ArrayList<Relationship>();
            ArrayList<String> validatedAnchorGUIDs = new ArrayList<String>();
            for (Relationship relationship : retrievedRelationships) {
                try {
                    this.validateRelationship(userId, relationship, validatedAnchorGUIDs, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    results.add(relationship);
                }
                catch (Exception exception) {}
            }
            return results;
        }
        return null;
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntity(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, 0, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getAttachedEntity(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.getEntityFromRepository(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, startingEntity, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, null, 0, resultingElementTypeName, attachmentEntityEnd, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity != null) {
            this.validateEntityAndAnchorForRead(userId, resultingElementTypeName, entity, startingElementGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return entity;
    }

    public int countAttachments(String userId, String elementGUID, String elementTypeName, String attachmentTypeGUID, String attachmentTypeName, int attachmentEntityEnd, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        int count = 0;
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, elementGUID, elementTypeName, attachmentTypeGUID, attachmentTypeName, attachmentEntityEnd, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
            ++count;
        }
        return count;
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.getEntityFromRepository(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getAttachedEntities(userId, startingEntity, startingGUIDParameterName, startingTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getAttachedEntities(String userId, EntityDetail startingElement, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)startingElement, startingElementGUIDParameterName, methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, startingElement, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null) {
            return null;
        }
        Map<String, EntityDetail> retrievedEntities = this.getValidatedEntities(userId, startingElement.getGUID(), startingElementTypeName, relationships, resultingElementTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList<EntityDetail> visibleEntities = new ArrayList<EntityDetail>();
        if (retrievedEntities != null) {
            retrievedEntities.put(startingElement.getGUID(), startingElement);
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (!this.visibleToUserThroughRelationship(userId, relationship, methodName) || (entityProxy = this.repositoryHandler.getOtherEnd(startingElement.getGUID(), startingElementTypeName, relationship, attachmentEntityEnd, methodName)) == null || entityProxy.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, entityProxy.getType().getTypeDefName(), resultingElementTypeName)) continue;
                try {
                    String guidParameterName = "entityProxy.getGUID()";
                    visibleEntities.add(this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxy.getGUID()", resultingElementTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName));
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException inaccessibleEntity) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
                }
            }
        }
        return visibleEntities;
    }

    public List<EntityDetail> getAttachedEntities(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, String requiredClassificationName, String omittedClassificationName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedEntities(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, requiredClassificationName, omittedClassificationName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getAttachedElementGUIDs(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "relationship.end.guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, null, attachmentEntityTypeName, 0, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Relationship relationship : relationships) {
            EntityProxy entityProxy;
            if (relationship == null || (entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, 0, methodName)) == null) continue;
            try {
                this.validateEntityAndAnchorForRead(userId, entityProxy.getGUID(), "relationship.end.guid", attachmentEntityTypeName, false, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                results.add(entityProxy.getGUID());
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException nonAccessibleEntity) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping entity: " + (OCFCheckedExceptionBase)nonAccessibleEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUID(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, selectionEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getAttachedElementGUID(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, int selectionEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> attachedEntities = this.getAttachedEntities(userId, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, null, null, selectionEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (attachedEntities == null || attachedEntities.isEmpty()) {
            return null;
        }
        String result = null;
        for (EntityDetail attachedEntity : attachedEntities) {
            if (attachedEntity == null) continue;
            if (result == null) {
                result = attachedEntity.getGUID();
                continue;
            }
            this.errorHandler.handleAmbiguousAttachedEntities(startingGUID, startingTypeName, attachmentRelationshipTypeName, attachedEntities, methodName);
        }
        return result;
    }

    public B getAttachedElement(String userId, String startingElementGUID, String startingElementGUIDParameterName, String startingElementTypeName, String relationshipTypeGUID, String relationshipTypeName, String resultingElementTypeName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> attachedEntities = this.getAttachedEntities(userId, startingElementGUID, startingElementGUIDParameterName, startingElementTypeName, relationshipTypeGUID, relationshipTypeName, resultingElementTypeName, null, null, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (attachedEntities == null || attachedEntities.isEmpty()) {
            return null;
        }
        EntityDetail result = null;
        for (EntityDetail attachedEntity : attachedEntities) {
            if (attachedEntity == null) continue;
            if (result == null) {
                result = attachedEntity;
                continue;
            }
            this.errorHandler.handleAmbiguousAttachedEntities(startingElementGUID, startingElementTypeName, resultingElementTypeName, attachedEntities, methodName);
        }
        if (result != null) {
            return this.converter.getNewBean(this.beanClass, result, methodName);
        }
        return null;
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, List<Integer> limitResultsByEnumValues, String enumPropertyName, int attachmentEntityEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, startingGUID, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        if (relationships == null) {
            return null;
        }
        Map<String, EntityDetail> retrievedEntities = this.getValidatedEntities(userId, startingGUID, startingTypeName, relationships, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, 0, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        if (retrievedEntities != null) {
            for (Relationship relationship : relationships) {
                if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
                try {
                    Object bean;
                    EntityProxy entityProxy;
                    EntityDetail retrievedEntity;
                    Integer relationshipOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, enumPropertyName, relationship.getProperties(), methodName);
                    if (!limitResultsByEnumValues.contains(relationshipOrdinal) || (retrievedEntity = retrievedEntities.get((entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, 0, methodName)).getGUID())) == null || (bean = this.converter.getNewBean(this.beanClass, retrievedEntity, relationship, methodName)) == null) continue;
                    results.add(bean);
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException inaccessibleEntity) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
                }
            }
        }
        return results;
    }

    public List<B> getAttachedElements(String userId, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAttachedElements(String userId, String anchorGUID, String anchorGUIDParameterName, String startingGUID, String startingGUIDParameterName, String startingTypeName, String attachmentRelationshipTypeGUID, String attachmentRelationshipTypeName, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity;
        List relationships;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        if (anchorGUID != null) {
            EntityDetail anchorEntity = this.validateEntityAndAnchorForRead(userId, startingGUID, startingGUIDParameterName, startingTypeName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            this.invalidParameterHandler.validateAnchorGUID(anchorGUID, anchorGUIDParameterName, anchorEntity, startingGUID, startingTypeName, methodName);
        }
        if ((relationships = this.repositoryHandler.getRelationshipsByType(userId, startingEntity = this.getEntityFromRepository(userId, startingGUID, startingGUIDParameterName, startingTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName), startingTypeName, attachmentRelationshipTypeGUID, attachmentRelationshipTypeName, selectionEnd, limitResultsByStatus, asOfTime, sequencingOrder, sequencingProperty, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName)) == null) {
            return null;
        }
        Map<String, EntityDetail> retrievedEntities = this.getValidatedEntities(userId, startingGUID, startingTypeName, relationships, attachmentEntityTypeName, requiredClassificationName, omittedClassificationName, selectionEnd, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        if (retrievedEntities != null) {
            retrievedEntities.put(startingEntity.getGUID(), startingEntity);
            for (Relationship relationship : relationships) {
                if (!this.visibleToUserThroughRelationship(userId, relationship, methodName)) continue;
                try {
                    Object bean;
                    EntityDetail retrievedEntity;
                    EntityProxy entityProxy = null;
                    if (selectionEnd == 0) {
                        entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, selectionEnd, methodName);
                    } else if (selectionEnd == 1) {
                        entityProxy = relationship.getEntityOneProxy();
                    } else if (selectionEnd == 2) {
                        entityProxy = relationship.getEntityTwoProxy();
                    }
                    if (entityProxy == null || (retrievedEntity = retrievedEntities.get(entityProxy.getGUID())) == null || (bean = this.converter.getNewBean(this.beanClass, retrievedEntity, relationship, methodName)) == null) continue;
                    results.add(bean);
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException inaccessibleEntity) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skipping inaccessible entity: " + (OCFCheckedExceptionBase)inaccessibleEntity);
                }
            }
        }
        return results;
    }

    public Map<String, EntityDetail> getValidatedEntities(String userId, String startingGUID, String startingTypeName, List<Relationship> retrievedRelationships, String attachmentEntityTypeName, String requiredClassificationName, String omittedClassificationName, int selectionEnd, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        if (retrievedRelationships != null) {
            String guidParameterName = "relationship.end.guid";
            String connectToGUIDParameterName = "relationship.entityProxy.guid";
            ArrayList<String> extractedEntityGUIDs = new ArrayList<String>();
            ArrayList<PropertyCondition> entityRetrievalQuery = new ArrayList<PropertyCondition>();
            for (Relationship relationship : retrievedRelationships) {
                if (relationship == null) continue;
                try {
                    EntityProxy entityProxy = null;
                    if (selectionEnd == 0) {
                        entityProxy = this.repositoryHandler.getOtherEnd(startingGUID, startingTypeName, relationship, selectionEnd, methodName);
                    } else if (selectionEnd == 1) {
                        entityProxy = relationship.getEntityOneProxy();
                    } else if (selectionEnd == 2) {
                        entityProxy = relationship.getEntityTwoProxy();
                    }
                    if (entityProxy == null || extractedEntityGUIDs.contains(entityProxy.getGUID())) continue;
                    PropertyCondition propertyCondition = new PropertyCondition();
                    propertyCondition.setProperty(OpenMetadataProperty.GUID.name);
                    propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                    PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    primitivePropertyValue.setPrimitiveValue((Object)entityProxy.getGUID());
                    propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
                    entityRetrievalQuery.add(propertyCondition);
                    extractedEntityGUIDs.add(entityProxy.getGUID());
                }
                catch (Exception entityProxy) {}
            }
            Map<Object, Object> retrievedEntities = new HashMap();
            if (!extractedEntityGUIDs.isEmpty()) {
                if (attachmentEntityTypeName == null) {
                    retrievedEntities = this.getEntityList(userId, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, entityRetrievalQuery, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else {
                    String typeGUID = this.invalidParameterHandler.validateTypeName(attachmentEntityTypeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
                    retrievedEntities = this.getEntityList(userId, typeGUID, entityRetrievalQuery, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            ArrayList<String> validatedAnchors = new ArrayList<String>();
            HashMap<String, EntityDetail> visibleEntities = new HashMap<String, EntityDetail>();
            for (EntityDetail retrievedEntity : retrievedEntities.values()) {
                if (retrievedEntity == null || visibleEntities.containsKey(retrievedEntity.getGUID())) continue;
                try {
                    boolean beanValid = true;
                    if (requiredClassificationName != null) {
                        try {
                            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, requiredClassificationName, methodName) == null) {
                                beanValid = false;
                            }
                        }
                        catch (ClassificationErrorException error) {
                            beanValid = false;
                        }
                    }
                    if (omittedClassificationName != null) {
                        try {
                            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, omittedClassificationName, methodName) != null) {
                                beanValid = false;
                            }
                        }
                        catch (ClassificationErrorException error) {
                            // empty catch block
                        }
                    }
                    if (!beanValid) continue;
                    OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorGUIDForEntity(retrievedEntity, "relationship.entityProxy.guid", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    if (anchorIdentifiers != null) {
                        String anchorGUID = anchorIdentifiers.anchorGUID;
                        if (anchorGUID == null) {
                            anchorGUID = retrievedEntity.getGUID();
                        }
                        if (!validatedAnchors.contains(anchorGUID)) {
                            validatedAnchors.add(anchorGUID);
                            this.validateEntityAndAnchorForRead(userId, attachmentEntityTypeName, retrievedEntity, "relationship.end.guid", true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                        }
                    } else {
                        this.validateRetrievedEntityIsVisible(userId, retrievedEntity, "relationship.entityProxy.guid", retrievedEntity.getType().getTypeDefName(), false, suppliedSupportedZones, methodName);
                    }
                    visibleEntities.put(retrievedEntity.getGUID(), retrievedEntity);
                }
                catch (Exception exception) {}
            }
            return visibleEntities;
        }
        return null;
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityFromRepository(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntityFromRepository(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, null, effectiveTime, methodName);
    }

    public EntityDetail getEntityFromRepository(String userId, String requestedEntityGUID, String requestedEntityGUIDParameterName, String requestedEntityTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date asOfTime, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(requestedEntityGUID, requestedEntityGUIDParameterName, methodName);
        EntityDetail retrievedEntity = this.repositoryHandler.getEntityByGUID(userId, requestedEntityGUID, requestedEntityGUIDParameterName, requestedEntityTypeName, forLineage, forDuplicateProcessing, asOfTime, effectiveTime, methodName);
        this.validateEntityAndAnchorForRead(userId, requestedEntityTypeName, retrievedEntity, requestedEntityGUIDParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        boolean beanValid = true;
        if (requiredClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, requiredClassificationName, methodName) == null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException error) {
                beanValid = false;
            }
        }
        if (omittedClassificationName != null) {
            try {
                if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)retrievedEntity, omittedClassificationName, methodName) != null) {
                    beanValid = false;
                }
            }
            catch (ClassificationErrorException classificationErrorException) {
                // empty catch block
            }
        }
        if (!beanValid) {
            return null;
        }
        return retrievedEntity;
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String resultTypeName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, resultTypeName, false, false, this.supportedZones, new Date(), methodName);
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, entityTypeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, entityTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    public B getBeanFromRepository(String userId, String guid, String guidParameterName, String entityTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date asOfTime, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, entityTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, asOfTime, effectiveTime, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    public B getBeanFromEntity(String userId, EntityDetail entity, String entityParameterName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)entity, entityParameterName, methodName);
        if (entity != null) {
            return this.converter.getNewBean(this.beanClass, entity, methodName);
        }
        return null;
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanStringPropertyFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, propertyName, false, false, this.supportedZones, effectiveTime, methodName);
    }

    String getBeanStringPropertyFromRepository(String userId, String entityGUID, String entityGUIDParameterName, String entityTypeName, String propertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyNameParameter = "propertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, entityGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        String property = null;
        EntityDetail entityDetail = this.getEntityFromRepository(userId, entityGUID, entityGUIDParameterName, entityTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (entityDetail != null) {
            property = this.repositoryHelper.getStringProperty(this.serviceName, propertyName, entityDetail.getProperties(), methodName);
        }
        return property;
    }

    private InstanceProperties getSearchInstanceProperties(String searchValue, List<String> specificMatchPropertyNames, String methodName) {
        InstanceProperties properties = new InstanceProperties();
        for (String propertyName : specificMatchPropertyNames) {
            if (propertyName == null) continue;
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, propertyName, searchValue, methodName);
        }
        return properties;
    }

    public String getBeanGUIDByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDByUniqueName(userId, name, nameParameterName, namePropertyName, resultTypeGUID, resultTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getBeanGUIDByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, namePropertyName, name, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, resultTypeGUID, limitResultsByStatus, null, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        String guid = null;
        HashSet<String> duplicateEntities = new HashSet<String>();
        String entityParameterName = "Entity from search of value " + name;
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null) continue;
                duplicateEntities.add(entity.getGUID());
                try {
                    this.validateEntityAndAnchorForRead(userId, resultTypeName, entity, entityParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    if (guid != null) continue;
                    guid = entity.getGUID();
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
            }
        }
        if (guid == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return guid;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByUniqueName(userId, name, nameParameterName, namePropertyName, resultTypeGUID, resultTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanByUniqueName(String userId, String name, String nameParameterName, String namePropertyName, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, namePropertyName, name, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, resultTypeGUID, limitResultsByStatus, null, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        B bean = null;
        HashSet<String> duplicateEntities = new HashSet<String>();
        String entityParameterName = "Entity from search of value " + name;
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null) continue;
                duplicateEntities.add(entity.getGUID());
                try {
                    this.validateEntityAndAnchorForRead(userId, resultTypeName, entity, entityParameterName, true, false, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                    if (bean != null) continue;
                    bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                }
                catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException throwable) {}
            }
        }
        if (bean == null) {
            return null;
        }
        if (duplicateEntities.size() == 1) {
            return bean;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_ENTITIES_FOUND.getMessageDefinition(resultTypeName, name, ((Object)duplicateEntities).toString(), methodName, nameParameterName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getBeanHistory(String userId, String guid, String guidParameterName, String entityTypeName, Date fromTime, Date toTime, int startingFrom, int pageSize, HistorySequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, guidParameterName, methodName);
        this.validateEntityAndAnchorForRead(userId, guid, guidParameterName, entityTypeName, true, true, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        List entities = this.repositoryHandler.getEntityDetailHistory(userId, guid, fromTime, toTime, startingFrom, pageSize, sequencingOrder, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getBeanByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, false, false, null, null, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return this.converter.getNewBean(this.beanClass, results.get(0), methodName);
        }
        this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
        return null;
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeans(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, null, null, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findBeans(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, pageSize, serviceSupportedZones, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<EntityDetail> findEntities(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findEntities(userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, pageSize, this.supportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> findEntities(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications searchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        String typeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        if (metadataElementTypeName != null) {
            typeName = metadataElementTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, this.serviceName, methodName, this.repositoryHelper);
        ArrayList<String> subTypeGUIDs = null;
        if (metadataElementSubtypeNames != null) {
            subTypeGUIDs = new ArrayList<String>();
            for (String subTypeName : metadataElementSubtypeNames) {
                String subTypeGUID;
                if (subTypeName == null || (subTypeGUID = this.invalidParameterHandler.validateTypeName(subTypeName, typeName, this.serviceName, methodName, this.repositoryHelper)) == null) continue;
                subTypeGUIDs.add(subTypeGUID);
            }
        }
        if (searchClassifications != null && searchClassifications.getConditions() != null) {
            for (ClassificationCondition classificationCondition : searchClassifications.getConditions()) {
                if (classificationCondition == null) continue;
                this.invalidParameterHandler.validateTypeDefName(classificationCondition.getName(), null, this.serviceName, methodName, this.repositoryHelper);
            }
        }
        List retrievedEntities = this.repositoryHandler.findEntities(userId, typeGUID, subTypeGUIDs, searchProperties, limitResultsByStatus, searchClassifications, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, startingFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidatedEntities(userId, retrievedEntities, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByIntValue(String userId, int value, String resultTypeGUID, String resultTypeName, String propertyName, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByIntValue(userId, value, resultTypeGUID, resultTypeName, propertyName, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> getBeansByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
            return results;
        }
        return null;
    }

    public List<EntityDetail> getEntitiesByType(String userId, String resultTypeGUID, String resultTypeName, boolean forLineage, boolean forDuplicateProcessing, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByType(userId, resultTypeGUID, resultTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByType(String userId, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesForType(userId, resultTypeGUID, resultTypeName, limitResultsByStatus, null, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.validateEntitiesAndAnchorsForRead(userId, retrievedEntities, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> findEntities(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findEntities(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, requiredClassificationName, omittedClassificationName, startFrom, pageSize, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> findEntities(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        return this.getEntitiesByValue(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, null, false, false, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByIntValue(String userId, int value, String resultTypeGUID, String resultTypeName, String propertyName, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String propertyParameterName = "propertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(propertyName, "propertyName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<String> limitResultsByClassification = null;
        if (requiredClassificationName != null) {
            limitResultsByClassification = new ArrayList<String>();
            limitResultsByClassification.add(requiredClassificationName);
        }
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, propertyName, value, methodName), resultTypeGUID, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidatedEntities(userId, retrievedEntities, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<EntityDetail> getEntitiesByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, boolean caseInsensitive, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(value, valueParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<String> limitResultsByClassifications = null;
        if (requiredClassificationName != null) {
            limitResultsByClassifications = new ArrayList<String>();
            limitResultsByClassifications.add(requiredClassificationName);
        }
        String searchValue = value;
        if (exactValueMatch) {
            searchValue = this.repositoryHelper.getExactMatchRegex(value, caseInsensitive);
        }
        List retrievedEntities = specificMatchPropertyNames == null || specificMatchPropertyNames.isEmpty() ? this.repositoryHandler.getEntitiesByValue(userId, searchValue, resultTypeGUID, limitResultsByStatus, limitResultsByClassifications, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName) : this.repositoryHandler.getEntitiesByName(userId, this.getSearchInstanceProperties(searchValue, specificMatchPropertyNames, methodName), resultTypeGUID, limitResultsByStatus, limitResultsByClassifications, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidatedEntities(userId, retrievedEntities, omittedClassificationName, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public List<EntityDetail> getValidatedEntities(String userId, List<EntityDetail> retrievedEntities, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> validatedEntities = this.validateEntitiesAndAnchorsForRead(userId, retrievedEntities, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (validatedEntities != null) {
            ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
            for (EntityDetail entity : validatedEntities) {
                if (entity == null) continue;
                boolean beanValid = true;
                if (omittedClassificationName != null) {
                    try {
                        if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, omittedClassificationName, methodName) != null) {
                            beanValid = false;
                        }
                    }
                    catch (ClassificationErrorException classificationErrorException) {
                        // empty catch block
                    }
                }
                if (!beanValid) continue;
                results.add(entity);
            }
            return results;
        }
        return null;
    }

    public List<String> getEntityGUIDsByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, boolean exactValueMatch, String requiredClassificationName, String omittedClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, exactValueMatch, false, requiredClassificationName, omittedClassificationName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<String> results = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(entity.getGUID());
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public EntityDetail getEntityByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getEntityByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public EntityDetail getEntityByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> results = this.getEntitiesByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, false, null, null, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results != null) {
            if (results.size() == 1) {
                return results.get(0);
            }
            if (results.size() > 1) {
                this.errorHandler.handleAmbiguousEntityName(value, valueParameterName, resultTypeName, results, methodName);
            }
        }
        return null;
    }

    public String getEntityGUIDByValue(String userId, String value, String valueParameterName, String resultTypeGUID, String resultTypeName, List<String> specificMatchPropertyNames, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail result = this.getEntityByValue(userId, value, valueParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (result != null) {
            return result.getGUID();
        }
        return null;
    }

    public List<B> getValidatedBeans(String userId, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, String methodName, List<EntityDetail> retrievedEntities) throws PropertyServerException {
        List<EntityDetail> validatedEntities = this.validateEntitiesAndAnchorsForRead(userId, retrievedEntities, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (validatedEntities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : validatedEntities) {
                if (entity == null) continue;
                results.add(this.converter.getNewBean(this.beanClass, entity, methodName));
            }
            return results;
        }
        return null;
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, int startFrom, int pageSize, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByType(userId, resultTypeGUID, resultTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getBeansByType(String userId, String resultTypeGUID, String resultTypeName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, resultTypeGUID, resultTypeName, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null && !entities.isEmpty()) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                Object bean;
                if (entity == null || (bean = this.converter.getNewBean(this.beanClass, entity, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> getBeanGUIDsByClassification(String userId, String resultTypeGUID, String resultClassificationName, List<InstanceStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingPropertyName, boolean forLineage, boolean forDuplicateProcessing, int startFrom, int pageSize, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, resultClassificationName, null, null, limitResultsByStatus, asOfTime, sequencingOrder, sequencingPropertyName, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<String> entityGUID = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                entityGUID.add(entity.getGUID());
            }
            if (!entityGUID.isEmpty()) {
                return entityGUID;
            }
        }
        return null;
    }

    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String relationshipTypeGUID, String relationshipTypeName, InstanceProperties relationshipProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String relationshipTypeGUID, String relationshipTypeName, Date effectiveFrom, Date effectiveTo, Map<String, Object> relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, relationshipProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, relationshipTypeGUID, relationshipTypeName, this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String linkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingElementGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Iterator iterator;
        Object guids;
        EntityDetail bean2Entity;
        EntityDetail bean1Entity;
        block33: {
            Relationship newRelationship;
            int actionOrdinal;
            String actionDescriptionTemplate;
            EntityDetail anchor2Entity;
            EntityDetail anchor1Entity;
            block29: {
                block36: {
                    String attachingElementAnchorGUID;
                    String anchorGUIDParameterName;
                    block37: {
                        block28: {
                            block34: {
                                String startingElementAnchorGUID;
                                block35: {
                                    block32: {
                                        block30: {
                                            List existingRelationships;
                                            block31: {
                                                this.invalidParameterHandler.validateUserId(userId, methodName);
                                                this.invalidParameterHandler.validateGUID(startingElementGUID, startingGUIDParameterName, methodName);
                                                this.invalidParameterHandler.validateGUID(attachingElementGUID, attachingGUIDParameterName, methodName);
                                                bean1Entity = this.repositoryHandler.getEntityByGUID(userId, startingElementGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                                anchor1Entity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, bean1Entity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                                                bean2Entity = this.repositoryHandler.getEntityByGUID(userId, attachingElementGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                                anchor2Entity = this.validateEntityAndAnchorForRead(userId, attachingElementTypeName, bean2Entity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
                                                if (this.repositoryHelper.isTypeOf(this.serviceName, attachmentTypeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, attachmentTypeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, attachmentTypeName, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, attachmentTypeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName)) {
                                                    if (anchor1Entity != null) {
                                                        this.securityVerifier.validateUserForAnchorAddFeedback(userId, anchor1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                                                    } else {
                                                        this.securityVerifier.validateUserForElementAddFeedback(userId, bean1Entity, bean2Entity, this.repositoryHelper, this.serviceName, methodName);
                                                    }
                                                } else if (anchor1Entity != null) {
                                                    if (anchor2Entity != null) {
                                                        if (anchor1Entity.getGUID().equals(anchor2Entity.getGUID())) {
                                                            this.securityVerifier.validateUserForAnchorMemberUpdate(userId, anchor1Entity, this.repositoryHelper, this.serviceName, methodName);
                                                        } else {
                                                            this.securityVerifier.validateUserForAnchorAttach(userId, anchor1Entity, bean2Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
                                                        }
                                                    }
                                                } else if (anchor2Entity == null) {
                                                    this.securityVerifier.validateUserForElementAttach(userId, bean1Entity, bean2Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
                                                } else {
                                                    this.securityVerifier.validateUserForAnchorAttach(userId, anchor2Entity, bean1Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
                                                }
                                                existingRelationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, bean1Entity, startingElementTypeName, bean2Entity.getGUID(), attachmentTypeGUID, attachmentTypeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, true, methodName);
                                                if (existingRelationships == null) break block30;
                                                if (existingRelationships.size() != 1) break block31;
                                                actionDescriptionTemplate = "Updating link from %s %s to %s %s";
                                                actionOrdinal = 1;
                                                newRelationship = this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, (Relationship)existingRelationships.get(0), relationshipProperties, methodName);
                                                break block32;
                                            }
                                            guids = null;
                                            iterator = existingRelationships.iterator();
                                            break block33;
                                        }
                                        actionDescriptionTemplate = "Linking %s %s to %s %s";
                                        actionOrdinal = 0;
                                        newRelationship = this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, bean1Entity.getGUID(), bean2Entity.getGUID(), relationshipProperties, methodName);
                                    }
                                    if (anchor1Entity != null) break block28;
                                    startingElementAnchorGUID = this.reEvaluateAnchorGUID(bean1Entity.getGUID(), startingGUIDParameterName, startingElementTypeName, bean1Entity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                    if (startingElementAnchorGUID == null) break block34;
                                    if (anchor2Entity == null || !anchor2Entity.getGUID().equals(startingElementAnchorGUID)) break block35;
                                    anchor1Entity = anchor2Entity;
                                    break block28;
                                }
                                if (startingElementAnchorGUID.equals(bean1Entity.getGUID())) {
                                    anchor1Entity = bean1Entity;
                                    break block28;
                                } else if (startingElementAnchorGUID.equals(bean2Entity.getGUID())) {
                                    anchor1Entity = bean2Entity;
                                    break block28;
                                } else {
                                    anchorGUIDParameterName = "startingElementAnchorGUID";
                                    anchor1Entity = this.repositoryHandler.getEntityByGUID(userId, startingElementAnchorGUID, "startingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                                }
                                break block28;
                            }
                            anchor1Entity = bean1Entity;
                        }
                        if (anchor2Entity != null) break block29;
                        attachingElementAnchorGUID = this.reEvaluateAnchorGUID(bean2Entity.getGUID(), attachingGUIDParameterName, attachingElementTypeName, bean2Entity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                        if (attachingElementAnchorGUID == null) break block36;
                        if (!attachingElementAnchorGUID.equals(anchor1Entity.getGUID())) break block37;
                        anchor2Entity = anchor1Entity;
                        break block29;
                    }
                    if (attachingElementAnchorGUID.equals(bean1Entity.getGUID())) {
                        anchor2Entity = bean1Entity;
                        break block29;
                    } else if (attachingElementAnchorGUID.equals(bean2Entity.getGUID())) {
                        anchor2Entity = bean2Entity;
                        break block29;
                    } else {
                        anchorGUIDParameterName = "attachingElementAnchorGUID";
                        anchor2Entity = this.repositoryHandler.getEntityByGUID(userId, attachingElementAnchorGUID, "attachingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                    }
                    break block29;
                }
                anchor2Entity = bean2Entity;
            }
            String actionDescription = String.format(actionDescriptionTemplate, startingElementTypeName, bean1Entity.getGUID(), attachingElementTypeName, bean2Entity.getGUID());
            if (!anchor1Entity.getGUID().equals(bean1Entity.getGUID())) {
                this.addLatestChangeToAnchor(anchor1Entity, 8, actionOrdinal, null, bean2Entity.getGUID(), attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(bean1Entity, 3, actionOrdinal, null, bean2Entity.getGUID(), attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (!anchor2Entity.getGUID().equals(bean2Entity.getGUID())) {
                this.addLatestChangeToAnchor(anchor2Entity, 8, actionOrdinal, null, bean1Entity.getGUID(), startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else if (!bean1Entity.getGUID().equals(bean2Entity.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, attachingElementTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(bean2Entity, 3, actionOrdinal, null, bean1Entity.getGUID(), startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (newRelationship != null) {
                return newRelationship.getGUID();
            }
            return null;
        }
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (relationship == null) continue;
            guids = guids == null ? "[" : ", ";
            guids = (String)guids + relationship.getGUID() + " ";
        }
        guids = guids == null ? "[]" : (String)guids + "]";
        throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.MULTIPLE_RELATIONSHIPS_FOUND.getMessageDefinition(new String[]{attachmentTypeName, startingElementTypeName, bean1Entity.getGUID(), attachingElementTypeName, bean2Entity.getGUID(), guids, methodName, this.serverName}), this.getClass().getName(), methodName, attachmentTypeName);
    }

    public String uncheckedLinkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String attachingElementGUID, String attachingGUIDParameterName, String attachmentTypeGUID, InstanceProperties relationshipProperties, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingElementGUID, attachingGUIDParameterName, methodName);
        Relationship newRelationship = this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingElementGUID, attachingElementGUID, relationshipProperties, methodName);
        if (newRelationship != null) {
            return newRelationship.getGUID();
        }
        return null;
    }

    public String multiLinkElementToElement(String userId, String externalSourceGUID, String externalSourceName, String startingElementGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingElementGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String anchorGUIDParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingElementGUID, attachingGUIDParameterName, methodName);
        EntityDetail bean1Entity = this.repositoryHandler.getEntityByGUID(userId, startingElementGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail anchor1Entity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, bean1Entity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        EntityDetail bean2Entity = this.repositoryHandler.getEntityByGUID(userId, attachingElementGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail anchor2Entity = this.validateEntityAndAnchorForRead(userId, attachingElementTypeName, bean2Entity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        if (anchor1Entity != null) {
            if (anchor1Entity.getGUID().equals(anchor2Entity.getGUID())) {
                this.securityVerifier.validateUserForAnchorMemberUpdate(userId, anchor1Entity, this.repositoryHelper, this.serviceName, methodName);
            } else {
                this.securityVerifier.validateUserForAnchorAttach(userId, anchor1Entity, bean2Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
            }
        } else if (anchor2Entity == null) {
            this.securityVerifier.validateUserForElementAttach(userId, bean1Entity, bean2Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
        } else {
            this.securityVerifier.validateUserForAnchorAttach(userId, anchor2Entity, bean1Entity, attachmentTypeName, this.repositoryHelper, this.serviceName, methodName);
        }
        String actionDescriptionTemplate = "Linking %s %s to %s %s";
        int actionOrdinal = 0;
        Relationship newRelationship = this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, bean1Entity.getGUID(), bean2Entity.getGUID(), relationshipProperties, methodName);
        if (anchor1Entity == null) {
            String startingElementAnchorGUID = this.reEvaluateAnchorGUID(bean1Entity.getGUID(), startingGUIDParameterName, startingElementTypeName, bean1Entity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (startingElementAnchorGUID != null) {
                if (anchor2Entity != null && anchor2Entity.getGUID().equals(startingElementAnchorGUID)) {
                    anchor1Entity = anchor2Entity;
                } else if (startingElementAnchorGUID.equals(bean1Entity.getGUID())) {
                    anchor1Entity = bean1Entity;
                } else if (startingElementAnchorGUID.equals(bean2Entity.getGUID())) {
                    anchor1Entity = bean2Entity;
                } else {
                    anchorGUIDParameterName = "startingElementAnchorGUID";
                    anchor1Entity = this.repositoryHandler.getEntityByGUID(userId, startingElementAnchorGUID, "startingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                anchor1Entity = bean1Entity;
            }
        }
        if (anchor2Entity == null) {
            String attachingElementAnchorGUID = this.reEvaluateAnchorGUID(bean2Entity.getGUID(), attachingGUIDParameterName, attachingElementTypeName, bean2Entity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (attachingElementAnchorGUID != null) {
                if (attachingElementAnchorGUID.equals(anchor1Entity.getGUID())) {
                    anchor2Entity = anchor1Entity;
                } else if (attachingElementAnchorGUID.equals(bean1Entity.getGUID())) {
                    anchor2Entity = bean1Entity;
                } else if (attachingElementAnchorGUID.equals(bean2Entity.getGUID())) {
                    anchor2Entity = bean2Entity;
                } else {
                    anchorGUIDParameterName = "attachingElementAnchorGUID";
                    anchor2Entity = this.repositoryHandler.getEntityByGUID(userId, attachingElementAnchorGUID, "attachingElementAnchorGUID", OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                anchor2Entity = bean2Entity;
            }
        }
        String actionDescription = String.format(actionDescriptionTemplate, startingElementTypeName, bean1Entity.getGUID(), attachingElementTypeName, bean2Entity.getGUID());
        if (!anchor1Entity.getGUID().equals(bean1Entity.getGUID())) {
            this.addLatestChangeToAnchor(anchor1Entity, 8, actionOrdinal, null, bean2Entity.getGUID(), attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(bean1Entity, 3, actionOrdinal, null, bean2Entity.getGUID(), attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (!anchor2Entity.getGUID().equals(bean2Entity.getGUID())) {
            this.addLatestChangeToAnchor(anchor2Entity, 8, actionOrdinal, null, bean1Entity.getGUID(), startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (!bean1Entity.getGUID().equals(bean2Entity.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, attachingElementTypeName, OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(bean2Entity, 3, actionOrdinal, null, bean1Entity.getGUID(), startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newRelationship != null) {
            return newRelationship.getGUID();
        }
        return null;
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, boolean isMergeUpdate, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachingGUID, attachingGUIDParameterName, methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, attachingGUIDParameterName, attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail attachingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, attachingElementTypeName, attachingElementEntity, attachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, startingGUID, startingElementTypeName, attachingGUID, attachmentTypeGUID, attachmentTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
            String actionDescriptionTemplate = "Updating link from %s %s to %s %s";
            String actionDescription = String.format("Updating link from %s %s to %s %s", startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 1, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(startingElementEntity, 3, 1, null, attachingGUID, attachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (attachingElementAnchorEntity != null) {
                if (!attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, 8, 1, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(attachingElementEntity, 3, 1, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(attachingGUID, attachingGUIDParameterName, attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, Map<String, Object> relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties instanceProperties = null;
        try {
            instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, relationshipProperties, methodName);
        }
        catch (InvalidParameterException error) {
            String propertyName = "relationshipProperties";
            this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "relationshipProperties");
        }
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, forLineage, forDuplicateProcessing, this.supportedZones, isMergeUpdate, this.setUpEffectiveDates(instanceProperties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void updateElementToElementLink(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, String relationshipGUIDParameterName, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, boolean isMergeUpdate, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, relationshipGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, relationshipGUID, relationshipGUIDParameterName, relationshipTypeName, effectiveTime, methodName);
        if (relationship != null) {
            String startingGUIDParameterName = "relationship.getEntityOneProxy().getGUID()";
            String attachingGUIDParameterName = "relationship.getEntityTwoProxy().getGUID()";
            String startingGUID = relationship.getEntityOneProxy().getGUID();
            String attachingGUID = relationship.getEntityTwoProxy().getGUID();
            String startingElementTypeName = relationship.getEntityOneProxy().getType().getTypeDefName();
            String attachingElementTypeName = relationship.getEntityTwoProxy().getType().getTypeDefName();
            EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, "relationship.getEntityOneProxy().getGUID()", startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail startingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, startingElementEntity, "relationship.getEntityOneProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
            String startingElementAnchorGUID = startingGUID;
            if (startingElementAnchorEntity != null) {
                startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
            }
            EntityDetail attachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachingGUID, "relationship.getEntityTwoProxy().getGUID()", attachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            EntityDetail attachingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, attachingElementTypeName, attachingElementEntity, "relationship.getEntityTwoProxy().getGUID()", true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
            InstanceProperties newProperties = this.setUpNewProperties(isMergeUpdate, relationshipProperties, relationship.getProperties());
            this.validateRelationshipChange(userId, relationship, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, newProperties, methodName);
            String actionDescriptionTemplate = "Updating link from %s %s to %s %s";
            String actionDescription = String.format("Updating link from %s %s to %s %s", startingElementTypeName, startingGUID, attachingElementTypeName, attachingGUID);
            if (startingElementAnchorEntity != null) {
                this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 1, null, attachingGUID, attachingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(startingElementEntity, 3, 1, null, attachingGUID, attachingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(startingGUID, "relationship.getEntityOneProxy().getGUID()", startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if (attachingElementAnchorEntity != null) {
                if (!attachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                    this.addLatestChangeToAnchor(attachingElementAnchorEntity, 8, 1, null, startingGUID, startingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            } else {
                if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                    this.addLatestChangeToAnchor(attachingElementEntity, 3, 1, null, startingGUID, startingElementTypeName, relationshipTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                this.reEvaluateAnchorGUID(attachingGUID, "relationship.getEntityTwoProxy().getGUID()", attachingElementTypeName, attachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, startAtEnd1, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, forLineage, forDuplicateProcessing, this.supportedZones, attachmentTypeGUID, attachmentTypeName, relationshipProperties, effectiveTime, methodName);
    }

    public void relinkElementToNewElement(String userId, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean startAtEnd1, String newAttachingGUID, String newAttachingGUIDParameterName, String newAttachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, InstanceProperties relationshipProperties, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(newAttachingGUID, newAttachingGUIDParameterName, methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail newAttachingElementEntity = this.repositoryHandler.getEntityByGUID(userId, newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail newAttachingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, newAttachingElementTypeName, newAttachingElementEntity, newAttachingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        int attachmentEntityEnd = 1;
        if (startAtEnd1) {
            attachmentEntityEnd = 2;
        }
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, startingGUID, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, attachmentEntityEnd, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String oldAttachingGUID = "<null>";
        String oldAttachingElementTypeName = "<null";
        if (relationship != null) {
            EntityProxy proxy = startAtEnd1 ? relationship.getEntityOneProxy() : relationship.getEntityTwoProxy();
            if (proxy != null) {
                oldAttachingGUID = proxy.getGUID();
                if (proxy.getType() != null) {
                    oldAttachingElementTypeName = proxy.getType().getTypeDefName();
                }
            }
            this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
        }
        if (startAtEnd1) {
            this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, startingGUID, newAttachingGUID, relationshipProperties, methodName);
        } else {
            this.repositoryHandler.createRelationship(userId, attachmentTypeGUID, externalSourceGUID, externalSourceName, newAttachingGUID, startingGUID, relationshipProperties, methodName);
        }
        String actionDescriptionTemplate = "Relinking %s %s from %s %s to %s %s";
        String actionDescription = String.format("Relinking %s %s from %s %s to %s %s", startingElementTypeName, startingGUID, oldAttachingElementTypeName, oldAttachingGUID, newAttachingElementTypeName, newAttachingGUID);
        if (startingElementAnchorEntity != null) {
            this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 0, null, newAttachingGUID, newAttachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, startingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            if (this.repositoryHelper.isTypeOf(this.serviceName, startingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(startingElementEntity, 3, 0, null, newAttachingGUID, newAttachingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAttachingElementAnchorEntity != null) {
            if (!newAttachingElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                this.addLatestChangeToAnchor(newAttachingElementAnchorEntity, 8, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, newAttachingElementEntity, newAttachingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            if (this.repositoryHelper.isTypeOf(this.serviceName, newAttachingElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
                this.addLatestChangeToAnchor(newAttachingElementEntity, 3, 0, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.reEvaluateAnchorGUID(newAttachingGUID, newAttachingGUIDParameterName, newAttachingElementTypeName, newAttachingElementEntity, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachingGUID, String attachingGUIDParameterName, String attachingElementTypeGUID, String attachingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachingGUID, attachingGUIDParameterName, attachingElementTypeGUID, attachingElementTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachedGUID, attachedGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, startingGUID, startingElementTypeName, attachedGUID, attachmentTypeGUID, attachmentTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeName, relationship, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, String attachmentTypeName, Relationship relationship, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, attachmentTypeName, relationship, effectiveTime, methodName);
    }

    public void unlinkElementFromElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, String attachedGUID, String attachedGUIDParameterName, String attachedElementTypeGUID, String attachedElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeName, Relationship relationship, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String relationshipParameterName = "relationship";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(attachedGUID, attachedGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)relationship, "relationship", methodName);
        this.validateRelationshipChange(userId, relationship, true, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        EntityDetail startingElementEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail startingElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, startingElementTypeName, startingElementEntity, startingGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        String startingElementAnchorGUID = startingGUID;
        String newStartingAnchorGUID = null;
        String newAttachedAnchorGUID = null;
        if (startingElementAnchorEntity != null) {
            startingElementAnchorGUID = startingElementAnchorEntity.getGUID();
        }
        EntityDetail attachedElementEntity = this.repositoryHandler.getEntityByGUID(userId, attachedGUID, attachedGUIDParameterName, attachedElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail attachedElementAnchorEntity = this.validateEntityAndAnchorForRead(userId, attachedElementTypeName, attachedElementEntity, attachedGUIDParameterName, true, false, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
        if (!onlyCreatorPermitted || userId.equals(relationship.getCreatedBy())) {
            if (this.visibleToUserThroughRelationship(userId, relationship, methodName)) {
                this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, relationship, methodName);
            }
        } else {
            throw new UserNotAuthorizedException(GenericHandlersErrorCode.ONLY_CREATOR_CAN_DELETE.getMessageDefinition(methodName, startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID, userId), this.getClass().getName(), methodName, userId);
        }
        String actionDescriptionTemplate = "Unlinking %s %s from %s %s";
        String actionDescription = String.format("Unlinking %s %s from %s %s", startingElementTypeName, startingGUID, attachedElementTypeName, attachedGUID);
        if (startingElementAnchorEntity != null && !startingElementEntity.getGUID().equals(startingElementAnchorEntity.getGUID())) {
            this.addLatestChangeToAnchor(startingElementAnchorEntity, 8, 2, null, attachedGUID, attachedElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            newStartingAnchorGUID = this.reEvaluateAnchorGUID(startingGUID, startingGUIDParameterName, startingElementTypeName, startingElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, attachedElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(startingElementEntity, 3, 2, null, attachedGUID, attachedElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (attachedElementAnchorEntity != null && !attachedElementAnchorEntity.getGUID().equals(attachedElementEntity.getGUID())) {
            if (!attachedElementAnchorEntity.getGUID().equals(startingElementAnchorGUID)) {
                this.addLatestChangeToAnchor(attachedElementAnchorEntity, 8, 2, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            newAttachedAnchorGUID = this.reEvaluateAnchorGUID(attachedGUID, attachedGUIDParameterName, attachedElementTypeName, attachedElementAnchorEntity.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, attachedElementEntity.getType().getTypeDefName(), OpenMetadataType.REFERENCEABLE.typeName)) {
            this.addLatestChangeToAnchor(startingElementEntity, 3, 2, null, startingGUID, startingElementTypeName, attachmentTypeName, userId, actionDescription, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (attachedElementAnchorEntity != null && newAttachedAnchorGUID == null) {
            try {
                ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
                anchorEntityGUIDs.add(attachedElementAnchorEntity.getGUID());
                this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, attachedGUID, attachedGUIDParameterName, attachedElementTypeGUID, attachedElementTypeName, null, null, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_DELETE_UNANCHORED_BEAN.getMessageDefinition(this.serviceName, attachedGUID, attachedElementTypeName, attachedElementTypeGUID, methodName, error.getClass().getName(), error.getMessage()), error);
            }
        }
        if (startingElementAnchorEntity != null && newStartingAnchorGUID == null) {
            String startingElementTypeGUID = this.repositoryHelper.getTypeDefByName(methodName, startingElementTypeName).getGUID();
            try {
                ArrayList<String> anchorEntityGUIDs = new ArrayList<String>();
                anchorEntityGUIDs.add(startingElementAnchorEntity.getGUID());
                this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeGUID, startingElementTypeName, null, null, anchorEntityGUIDs, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_DELETE_UNANCHORED_BEAN.getMessageDefinition(this.serviceName, startingGUID, startingElementTypeName, startingElementTypeGUID, methodName, error.getClass().getName(), error.getMessage()), error);
            }
        }
    }

    public void unlinkAllElements(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, startingEntity, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        while (iterator.moreToReceive()) {
            Relationship relationship = iterator.getNext();
            EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingElementTypeName, relationship, 2, methodName);
            if (entityProxy == null || entityProxy.getType() == null) continue;
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
        }
    }

    public String unlinkConnectedElement(String userId, boolean onlyCreatorPermitted, String externalSourceGUID, String externalSourceName, String startingGUID, String startingGUIDParameterName, String startingElementTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, String attachmentTypeGUID, String attachmentTypeName, String detachedElementTypeName, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> links;
        String entityProxyParameterName = "entityProxy.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingGUID, startingGUIDParameterName, methodName);
        EntityDetail startingEntity = this.repositoryHandler.getEntityByGUID(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, startingGUID, startingGUIDParameterName, startingElementTypeName, attachmentTypeGUID, attachmentTypeName, null, detachedElementTypeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships == null) {
            return null;
        }
        if (onlyCreatorPermitted) {
            links = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                if (relationship == null || !userId.equals(relationship.getCreatedBy())) continue;
                links.add(relationship);
            }
        } else {
            links = relationships;
        }
        if (links.size() > 1) {
            this.errorHandler.handleAmbiguousRelationships(startingGUID, startingElementTypeName, attachmentTypeName, links, methodName);
        }
        EntityProxy entityProxy = this.repositoryHandler.getOtherEnd(startingEntity.getGUID(), startingElementTypeName, links.get(0), 0, methodName);
        String detachedElementGUID = null;
        if (entityProxy != null && entityProxy.getType() != null) {
            detachedElementGUID = entityProxy.getGUID();
            this.unlinkElementFromElement(userId, onlyCreatorPermitted, externalSourceGUID, externalSourceName, startingGUID, startingGUIDParameterName, startingElementTypeName, entityProxy.getGUID(), "entityProxy.getGUID()", entityProxy.getType().getTypeDefGUID(), entityProxy.getType().getTypeDefName(), forLineage, forDuplicateProcessing, suppliedSupportedZones, attachmentTypeGUID, attachmentTypeName, effectiveTime, methodName);
        }
        return detachedElementGUID;
    }

    InstanceProperties setUpEffectiveDates(InstanceProperties currentProperties, Date effectiveFrom, Date effectiveTo) {
        InstanceProperties properties = currentProperties;
        if (effectiveFrom != null || effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        return properties;
    }

    public void verifyExternalSourceIdentity(String userId, String externalSourceGUID, String externalSourceName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "externalSourceGUID";
        if (externalSourceGUID == null && externalSourceName == null) {
            return;
        }
        try {
            EntityDetail integrator = this.getEntityFromRepository(userId, externalSourceGUID, "externalSourceGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (integrator == null) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, null), this.getClass().getName(), methodName, externalSourceGUID);
            }
            String qualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, integrator.getProperties(), methodName);
            if (!externalSourceName.equals(qualifiedName)) {
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.BAD_INTEGRATOR_NAME.getMessageDefinition(this.serviceName, methodName, externalSourceName, qualifiedName, externalSourceGUID), this.getClass().getName(), methodName, externalSourceGUID);
            }
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(GenericHandlersErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(this.serviceName, methodName, externalSourceGUID, externalSourceName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error, externalSourceGUID);
        }
    }

    public Map<String, List<Map<String, String>>> getSpecification(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSpecification";
        String parameterName = "refDataRelationship.getEntityTwoProxy().getGUID()";
        EntityDetail startingEntity = this.getEntityFromRepository(userId, elementGUID, elementGUIDParameterName, elementTypeName, null, null, false, false, new Date(), "getSpecification");
        List refDataRelationships = this.repositoryHandler.getRelationshipsByType(userId, elementGUID, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 0, new Date(), "getSpecification");
        if (refDataRelationships == null) {
            return null;
        }
        Map<String, EntityDetail> retrievedEntities = this.getValidatedEntities(userId, startingEntity.getGUID(), startingEntity.getType().getTypeDefName(), refDataRelationships, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, 0, false, false, serviceSupportedZones, new Date(), "getSpecification");
        if (retrievedEntities != null) {
            HashMap<String, List<Map<String, String>>> specification = new HashMap<String, List<Map<String, String>>>();
            retrievedEntities.put(startingEntity.getGUID(), startingEntity);
            for (Relationship refDataRelationship : refDataRelationships) {
                EntityDetail specificationDetail;
                String propertyType;
                if (refDataRelationship == null || (propertyType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROPERTY_TYPE.name, refDataRelationship.getProperties(), "getSpecification")) == null || (specificationDetail = retrievedEntities.get(refDataRelationship.getEntityTwoProxy().getGUID())) == null) continue;
                HashMap<CallSite, String> additionalProperties = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, specificationDetail.getProperties(), "getSpecification");
                if (additionalProperties == null) {
                    additionalProperties = new HashMap<CallSite, String>();
                }
                additionalProperties.put((CallSite)((Object)(propertyType + "Name")), this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PREFERRED_VALUE.name, specificationDetail.getProperties(), "getSpecification"));
                ArrayList<HashMap<CallSite, String>> properties = (ArrayList<HashMap<CallSite, String>>)specification.get(propertyType);
                if (properties == null) {
                    properties = new ArrayList<HashMap<CallSite, String>>();
                }
                properties.add(additionalProperties);
                specification.put(propertyType, properties);
            }
            return specification;
        }
        return null;
    }
}

