/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OperatingPlatformBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OperatingPlatformHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public OperatingPlatformHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void createOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, String operatingSystem, int byteOrdering, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = OpenMetadataType.OPERATING_PLATFORM.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.OPERATING_PLATFORM.typeName, this.serviceName, methodName, this.repositoryHelper);
        OperatingPlatformBuilder builder = new OperatingPlatformBuilder(qualifiedName, name, description, operatingSystem, byteOrdering, additionalProperties, typeGUID, suppliedTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, builder, effectiveTime, methodName);
    }

    public void updateOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, String qualifiedName, String name, String description, String operatingSystem, int byteOrdering, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(operatingPlatformGUID, operatingPlatformGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.OPERATING_PLATFORM.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.OPERATING_PLATFORM.typeName, this.serviceName, methodName, this.repositoryHelper);
        OperatingPlatformBuilder builder = new OperatingPlatformBuilder(qualifiedName, name, description, operatingSystem, byteOrdering, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, operatingPlatformGUID, operatingPlatformGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void setupHostOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, operatingPlatformGUID, operatingPlatformGUIDParameterName, OpenMetadataType.OPERATING_PLATFORM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.OPERATING_PLATFORM_USE.typeGUID, OpenMetadataType.OPERATING_PLATFORM_USE.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearNestedOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String hostGUID, String hostGUIDParameterName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, hostGUID, hostGUIDParameterName, OpenMetadataType.HOST.typeName, operatingPlatformGUID, operatingPlatformGUIDParameterName, OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.OPERATING_PLATFORM_USE.typeGUID, OpenMetadataType.OPERATING_PLATFORM_USE.typeName, effectiveTime, methodName);
    }

    public void removeOperatingPlatform(String userId, String externalSourceGUID, String externalSourceName, String operatingPlatformGUID, String operatingPlatformGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, operatingPlatformGUID, operatingPlatformGUIDParameterName, OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getOperatingPlatform(String userId, String qualifiedName, String qualifiedNameParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanByUniqueName(userId, qualifiedName, qualifiedNameParameter, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getOperatingPlatforms(String userId, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }
}

