/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private String name = null;
    private String description = null;
    private String scope = null;
    private int headCount = 1;
    private boolean headCountLimitSet = false;
    private int domainIdentifier = 0;
    private boolean domainIdentifierSet = false;

    PersonRoleBuilder(String qualifiedName, String identifier, String name, String description, String scope, int headCount, boolean headCountLimitSet, int domainIdentifier, boolean domainIdentifierSet, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.scope = scope;
        this.headCount = headCount;
        this.headCountLimitSet = headCountLimitSet;
        this.domainIdentifier = domainIdentifier;
        this.domainIdentifierSet = domainIdentifierSet;
    }

    PersonRoleBuilder(String qualifiedName, String identifier, String name, String description, int headCount, boolean headCountLimitSet, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.headCount = headCount;
        this.headCountLimitSet = headCountLimitSet;
    }

    PersonRoleBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IDENTIFIER.name, this.identifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "scope", this.scope, methodName);
        if (this.headCountLimitSet) {
            properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.HEAD_COUNT.name, this.headCount, methodName);
        }
        if (this.domainIdentifierSet && (properties == null || properties.getPropertyValue("domainIdentifier") == null)) {
            properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "domainIdentifier", this.domainIdentifier, methodName);
        }
        return properties;
    }

    InstanceProperties getTeamLeadershipProperties(String position, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ROLE_POSITION.name, position, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getTeamMembershipProperties(String position, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ROLE_POSITION.name, position, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getAppointmentProperties(boolean isPublic, Date effectiveFrom, Date effectiveTo, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IS_PUBLIC.name, isPublic, methodName);
        return this.setEffectivityDates(properties, effectiveFrom, effectiveTo);
    }
}

