/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleHandler<B>
extends ReferenceableHandler<B> {
    public PersonRoleHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createPersonRole(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String name, String description, String scope, int headCount, boolean headCountLimitSet, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.PERSON_ROLE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PERSON_ROLE.typeName, this.serviceName, methodName, this.repositoryHelper);
        boolean domainIdentifierSet = this.repositoryHelper.isTypeOf(this.serviceName, typeName, "GovernanceRole");
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, scope, headCount, headCountLimitSet, domainIdentifier, domainIdentifierSet, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        roleBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, roleBuilder, effectiveTime, methodName);
    }

    public String createPersonRoleFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String identifier, String name, String description, int headCount, boolean headCountLimitSet, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, headCount, headCountLimitSet, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, roleBuilder, this.supportedZones, true, false, null, methodName);
    }

    public String appointPersonToRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        return this.linkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, OpenMetadataType.PERSON.typeName, roleGUID, roleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeGUID, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, builder.getAppointmentProperties(isPublic, effectiveFrom, effectiveTo, methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateAppointment(String userId, String externalSourceGUID, String externalSourceName, String appointmentGUID, String appointmentGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, appointmentGUID, appointmentGUIDParameterName, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, isMergeUpdate, builder.getAppointmentProperties(isPublic, effectiveFrom, effectiveTo, methodName), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public void relievePersonFromRole(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String roleGUID, String roleGUIDParameterName, String appointmentGUID, String appointmentGUIDParameterName, Date endDate, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(appointmentGUID, appointmentGUIDParameterName, methodName);
        Relationship relationship = this.repositoryHandler.getRelationshipByGUID(userId, appointmentGUID, appointmentGUIDParameterName, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, effectiveTime, methodName);
        if (relationship != null && relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null) {
            if (roleGUID != null && !roleGUID.equals(relationship.getEntityTwoProxy().getGUID())) {
                String relationshipTypeName = "<Unknown>";
                String proxyTypeName = "<Unknown>";
                if (relationship.getType() != null) {
                    relationshipTypeName = relationship.getType().getTypeDefName();
                }
                if (relationship.getEntityTwoProxy().getType() != null) {
                    proxyTypeName = relationship.getEntityTwoProxy().getType().getTypeDefName();
                }
                throw new InvalidParameterException(GenericHandlersErrorCode.WRONG_END_GUID.getMessageDefinition(roleGUIDParameterName, roleGUID, proxyTypeName, relationship.getEntityTwoProxy().getGUID(), Integer.toString(2), relationshipTypeName, appointmentGUIDParameterName, appointmentGUID), this.getClass().getName(), methodName, roleGUIDParameterName);
            }
            if (profileGUID != null && !profileGUID.equals(relationship.getEntityOneProxy().getGUID())) {
                String relationshipTypeName = "<Unknown>";
                String proxyTypeName = "<Unknown>";
                if (relationship.getType() != null) {
                    relationshipTypeName = relationship.getType().getTypeDefName();
                }
                if (relationship.getEntityOneProxy().getType() != null) {
                    proxyTypeName = relationship.getEntityOneProxy().getType().getTypeDefName();
                }
                throw new InvalidParameterException(GenericHandlersErrorCode.WRONG_END_GUID.getMessageDefinition(profileGUIDParameterName, profileGUID, proxyTypeName, relationship.getEntityOneProxy().getGUID(), Integer.toString(1), relationshipTypeName, appointmentGUIDParameterName, appointmentGUID), this.getClass().getName(), methodName, roleGUIDParameterName);
            }
            InstanceProperties properties = new InstanceProperties(relationship.getProperties());
            if (endDate == null) {
                properties.setEffectiveToTime(new Date());
            } else {
                properties.setEffectiveToTime(endDate);
            }
            this.repositoryHandler.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, relationship, properties, methodName);
        }
    }

    public void addTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamLeadershipProperties(position, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeTeamLeader(String userId, String externalSourceGUID, String externalSourceName, String teamLeaderRoleGUID, String teamLeaderRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamLeaderRoleGUID, teamLeaderRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeGUID, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, String position, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        PersonRoleBuilder builder = new PersonRoleBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamMembershipProperties(position, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeTeamMember(String userId, String externalSourceGUID, String externalSourceName, String teamMemberRoleGUID, String teamMemberRoleGUIDParameterName, String teamGUID, String teamGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, teamMemberRoleGUID, teamMemberRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeGUID, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addGovernanceResponsibility(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, String personRoleGUIDParameterName, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, personRoleGUID, personRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceResponsibility(String userId, String externalSourceGUID, String externalSourceName, String personRoleGUID, String personRoleGUIDParameterName, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, personRoleGUID, personRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, "89a76b24-deb8-45bf-9304-a578a610326f", "GovernanceResponsibility", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", effectiveTime, methodName);
    }

    public List<B> getRolesWithGovernanceResponsibility(String userId, String governanceResponsibilityGUID, String governanceResponsibilityGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, governanceResponsibilityGUID, governanceResponsibilityGUIDParameterName, "GovernanceResponsibility", "cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", OpenMetadataType.PERSON_ROLE.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void updatePersonRole(String userId, String externalSourceGUID, String externalSourceName, String roleGUID, String roleGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String identifier, String name, String nameParameterName, String description, String scope, int headCount, boolean headCountLimitSet, int domainIdentifier, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(roleGUID, roleGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
            this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PERSON_ROLE.typeName, this.serviceName, methodName, this.repositoryHelper);
        boolean domainIdentifierSet = typeName != null && !isMergeUpdate && domainIdentifier == 0 && this.repositoryHelper.isTypeOf(this.serviceName, typeName, "GovernanceRole");
        PersonRoleBuilder roleBuilder = new PersonRoleBuilder(qualifiedName, identifier, name, description, scope, headCount, headCountLimitSet, domainIdentifier, domainIdentifierSet, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        roleBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, roleGUID, roleGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, roleBuilder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removePersonRole(String userId, String externalSourceGUID, String externalSourceName, String roleGUID, String roleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, roleGUID, roleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findPersonRoles(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getPersonRolesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.IDENTIFIER.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getProjectManagerRoles(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName, OpenMetadataType.PERSON_ROLE.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTeamLeaderRoles(String userId, String teamGUID, String teamGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeName, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeName, OpenMetadataType.PERSON_ROLE.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getTeamMemberRoles(String userId, String teamGUID, String teamGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, teamGUID, teamGUIDParameterName, OpenMetadataType.TEAM.typeName, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataType.PERSON_ROLE.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCommunityRoles(String userId, String communityGUID, String communityGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, communityGUID, communityGUIDParameterName, OpenMetadataType.COMMUNITY.typeName, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataType.PERSON_ROLE.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public B getPersonRoleByGUID(String userId, String personRoleGUID, String personRoleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, personRoleGUID, personRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForRoleId(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForTitle(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPersonRolesForDomainId(String userId, int domainIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getBeansByType(userId, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return this.getBeansByIntValue(userId, domainIdentifier, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, "domainIdentifier", null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

