/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class RatingBuilder
extends OpenMetadataAPIGenericBuilder {
    private final int starRating;
    private final String review;
    private final boolean isPublic;

    public RatingBuilder(int starRating, String review, boolean isPublic, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.RATING.typeGUID, OpenMetadataType.RATING.typeName, repositoryHelper, serviceName, serverName);
        this.starRating = starRating;
        this.review = review;
        this.isPublic = isPublic;
    }

    public InstanceProperties getRelationshipInstanceProperties(String methodName) {
        return this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IS_PUBLIC.name, this.isPublic, methodName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STARS.name, StarRating.getOpenTypeGUID(), StarRating.getOpenTypeName(), this.starRating, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OCFCheckedExceptionBase)error, OpenMetadataProperty.STARS.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REVIEW.name, this.review, methodName);
        return properties;
    }
}

