/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RatingBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public RatingHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getRatings(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, OpenMetadataType.RATING.typeName, (String)null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public String saveRating(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, int starRating, String review, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            this.removeRating(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RatingBuilder builder = new RatingBuilder(starRating, review, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, elementGUID, elementGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        String ratingGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.RATING.typeGUID, OpenMetadataType.RATING.typeName, builder, effectiveTime, methodName);
        if (ratingGUID != null) {
            String ratingGUIDParameterName = "ratingGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, ratingGUID, "ratingGUID", OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, builder.getRelationshipInstanceProperties(methodName), methodName);
        }
        return ratingGUID;
    }

    public void removeRating(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ratingGUID = this.unlinkConnectedElement(userId, true, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, OpenMetadataType.RATING.typeName, effectiveTime, methodName);
        if (ratingGUID != null) {
            String ratingGUIDParameterName = "ratingGUID";
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, ratingGUID, "ratingGUID", OpenMetadataType.RATING.typeGUID, OpenMetadataType.RATING.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }
}

