/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SubjectAreaElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SubjectAreaConverter<B>
extends OMFConverter<B> {
    public SubjectAreaConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SubjectAreaElement) {
                SubjectAreaElement bean = (SubjectAreaElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName));
                    SubjectAreaProperties subjectAreaProperties = new SubjectAreaProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    subjectAreaProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    subjectAreaProperties.setSubjectAreaName(this.removeSubjectAreaName(instanceProperties));
                    subjectAreaProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    subjectAreaProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    subjectAreaProperties.setDescription(this.removeDescription(instanceProperties));
                    subjectAreaProperties.setUsage(this.removeUsage(instanceProperties));
                    subjectAreaProperties.setScope(this.removeScope(instanceProperties));
                    subjectAreaProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    subjectAreaProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    subjectAreaProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(subjectAreaProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

