/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SurveyReportBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SurveyReportHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public SurveyReportHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createSurveyReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, String assetGUID, String governanceEngineGUID, String governanceServiceGUID, Map<String, String> additionalProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String governanceEngineGUIDParameterName = "governanceEngineGUID";
        String governanceServiceGUIDParameterName = "governanceServiceGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", methodName);
        this.repositoryHandler.getEntityByGUID(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.repositoryHandler.getEntityByGUID(userId, "governanceEngineGUID", assetGUID, OpenMetadataType.OPEN_DISCOVERY_ENGINE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SurveyReportBuilder builder = new SurveyReportBuilder(qualifiedName, displayName, description, creationDate, analysisParameters, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        if (assetGUID != null) {
            this.addAnchorGUIDToBuilder(userId, assetGUID, "assetGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
        }
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String reportGUID = this.repositoryHandler.createEntity(userId, "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", null, null, builder.getInstanceProperties(methodName), null, InstanceStatus.ACTIVE, methodName);
        if (reportGUID != null) {
            this.repositoryHandler.createRelationship(userId, "7eded424-f176-4258-9ae6-138a46b2845f", null, null, assetGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "2c318c3a-5dc2-42cd-a933-0087d852f67f", null, null, governanceEngineGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "1744d72b-903d-4273-9229-de20372a17e2", null, null, governanceServiceGUID, reportGUID, null, methodName);
        }
        return reportGUID;
    }

    public void updateSurveyReport(String userId, String surveyReportGUID, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, Map<String, String> additionalProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String surveyReportGUIDParameterName = "surveyReportGUID";
        SurveyReportBuilder builder = new SurveyReportBuilder(qualifiedName, displayName, description, creationDate, analysisParameters, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, surveyReportGUID, "surveyReportGUID", "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public B getSurveyReport(String userId, String surveyReportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "surveyReportGUID";
        return this.getBeanFromRepository(userId, surveyReportGUID, "surveyReportGUID", OpenMetadataType.SURVEY_REPORT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<B> getSurveyReports(String userId, String assetGUID, int startingFrom, int maximumResults, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        return this.getAttachedElements(userId, assetGUID, "assetGUID", OpenMetadataType.ASSET.typeName, "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", OpenMetadataType.SURVEY_REPORT.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startingFrom, maximumResults, effectiveTime, methodName);
    }
}

