/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class UserIdentityHandler<B>
extends ReferenceableHandler<B> {
    public UserIdentityHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String qualifiedName, String elementUserId, String distinguishedName, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.USER_IDENTITY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.USER_IDENTITY.typeName, this.serviceName, methodName, this.repositoryHelper);
        UserIdentityBuilder builder = new UserIdentityBuilder(qualifiedName, elementUserId, distinguishedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, profileGUID, profileGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
        String userIdentityGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (userIdentityGUID != null && profileGUID != null) {
            String userIdentityGUIDParameterName = "userIdentityGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, userIdentityGUID, "userIdentityGUID", OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeGUID, null, methodName);
        }
        return userIdentityGUID;
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String qualifiedName, String elementUserId, String distinguishedName, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(userIdentityGUID, userIdentityGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.USER_IDENTITY.typeName, this.serviceName, methodName, this.repositoryHelper);
        UserIdentityBuilder builder = new UserIdentityBuilder(qualifiedName, elementUserId, distinguishedName, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addIdentityToProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String profileGUID, String profileGUIDParameterName, String roleTypeName, String roleGUID, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ROLE_TYPE_NAME.name, roleTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ROLE_GUID.name, roleGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.relinkElementToNewElement(userId, externalSourceGUID, externalSourceName, userIdentityGUID, userIdentityGUIDParameterName, OpenMetadataType.USER_IDENTITY.typeName, false, profileGUID, profileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void updateIdentityProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String profileGUID, String profileGUIDParameterName, String roleTypeName, String roleGUID, String description, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ROLE_TYPE_NAME.name, roleTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ROLE_GUID.name, roleGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, userIdentityGUID, userIdentityGUIDParameterName, OpenMetadataType.USER_IDENTITY.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, isMergeUpdate, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void removeIdentifyFromProfile(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, String userIdentityGUIDParameterName, String profileGUID, String profileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, userIdentityGUID, userIdentityGUIDParameterName, OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getUserIdentitiesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.USER_ID.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getUserIdentityByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.USER_IDENTITY.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

