/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValueConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueMappingElement;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueMappingConverter<B>
extends ValidValueConverter<B> {
    public ValidValueMappingConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ValidValueMappingElement) {
                ValidValueMappingElement bean = (ValidValueMappingElement)returnBean;
                ValidValueElement definition = new ValidValueElement();
                super.updateSimpleMetadataElement(beanClass, definition, entity, methodName);
                bean.setValidValueElement(definition);
                if (relationship != null) {
                    InstanceProperties instanceProperties = relationship.getProperties();
                    bean.setAssociationDescription(this.getAssociationDescription(instanceProperties));
                    bean.setConfidence(this.getConfidence(instanceProperties));
                    bean.setSteward(this.getSteward(instanceProperties));
                    bean.setStewardTypeName(this.getStewardTypeName(instanceProperties));
                    bean.setStewardPropertyName(this.getStewardPropertyName(instanceProperties));
                    bean.setNotes(this.getNotes(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

