/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ValidValueSetElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueSetProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValueSetConverter<B>
extends OMFConverter<B> {
    public ValidValueSetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ValidValueSetElement) {
                ValidValueSetElement bean = (ValidValueSetElement)returnBean;
                ValidValueSetProperties validValueProperties = new ValidValueSetProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    validValueProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    validValueProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    validValueProperties.setDisplayName(this.removeName(instanceProperties));
                    validValueProperties.setDescription(this.removeDescription(instanceProperties));
                    validValueProperties.setCategory(this.removeCategory(instanceProperties));
                    validValueProperties.setUsage(this.removeUsage(instanceProperties));
                    validValueProperties.setScope(this.removeScope(instanceProperties));
                    validValueProperties.setPreferredValue(this.removePreferredValue(instanceProperties));
                    validValueProperties.setDataType(this.removeDataType(instanceProperties));
                    validValueProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
                    validValueProperties.setIsCaseSensitive(this.removeIsCaseSensitive(instanceProperties));
                    validValueProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    validValueProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(validValueProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

