/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ValidValuesBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesHandler<B>
extends ReferenceableHandler<B> {
    public ValidValuesHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createValidValue(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String category, String usage, String scope, boolean isDeprecated, boolean isCaseSensitive, String preferredValue, String dataType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, null, suppliedTypeName, false, qualifiedName, displayName, description, category, usage, scope, preferredValue, dataType, isDeprecated, isCaseSensitive, additionalProperties, extendedProperties, suppliedSupportedZones, effectiveFrom, effectiveTo, false, false, effectiveTime, methodName);
    }

    public String createValidValueSet(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String category, String usage, String scope, boolean isDeprecated, boolean isCaseSensitive, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, null, OpenMetadataType.VALID_VALUE_SET.typeName, false, qualifiedName, displayName, description, category, usage, scope, null, null, isDeprecated, isCaseSensitive, additionalProperties, extendedProperties, suppliedSupportedZones, effectiveFrom, effectiveTo, false, false, effectiveTime, methodName);
    }

    public String createValidValueDefinition(String userId, String externalSourceGUID, String externalSourceName, String setGUID, boolean isDefaultValue, String qualifiedName, String displayName, String description, String category, String usage, String scope, String preferredValue, String dataType, boolean isDeprecated, boolean isCaseSensitive, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createValidValue(userId, externalSourceGUID, externalSourceName, null, setGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, isDefaultValue, qualifiedName, displayName, description, category, usage, scope, preferredValue, dataType, isDeprecated, isCaseSensitive, additionalProperties, extendedProperties, suppliedSupportedZones, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createValidValue(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String setGUID, String suppliedTypeName, boolean isDefaultValue, String qualifiedName, String displayName, String description, String category, String usage, String scope, String preferredValue, String dataType, boolean isDeprecated, boolean isCaseSensitive, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        String setParameter = "setGUID";
        String anchorGUIDParameter = "anchorGUID";
        String definitionParameter = "definitionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.VALID_VALUE_SET.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, this.serviceName, methodName, this.repositoryHelper);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, category, usage, scope, preferredValue, dataType, isDeprecated, isCaseSensitive, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", false, false, effectiveTime, suppliedSupportedZones, builder, methodName);
        String definitionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (definitionGUID != null && setGUID != null) {
            InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isDefaultValue", isDefaultValue, methodName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", definitionGUID, "definitionGUID", OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID, relationshipProperties, methodName);
        }
        return definitionGUID;
    }

    public void updateValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, String displayName, String description, String category, String usage, String scope, boolean isDeprecated, boolean isCaseSensitive, String preferredValue, String dataType, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, category, usage, scope, preferredValue, dataType, isDeprecated, isCaseSensitive, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void deleteValidValue(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void attachValidValueToSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, boolean isDefaultValue, Date effectiveFrom, Date effectiveTo, List<String> suppliedSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isDefaultValue", isDefaultValue, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, setGUID, "setGUID", OpenMetadataType.VALID_VALUE_SET.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void detachValidValueFromSet(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String validValueGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, setGUID, "setGUID", OpenMetadataType.VALID_VALUE_SET.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void attachConsistentValidValues(String userId, String externalSourceGUID, String externalSourceName, String validValue1GUID, String validValue2GUID, Date effectiveFrom, Date effectiveTo, List<String> suppliedSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, validValue1GUID, "validValue1GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValue2GUID, "validValue2GUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeGUID, OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void assignValidValueToConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, boolean strictRequirement, Date effectiveFrom, Date effectiveTo, List<String> suppliedSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "strictRequirement", strictRequirement, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", OpenMetadataType.REFERENCEABLE.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unassignValidValueFromConsumer(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String consumerGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, consumerGUID, "consumerGUID", OpenMetadataType.REFERENCEABLE.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void assignReferenceValueToItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, String attributeName, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes, List<String> suppliedSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, "attributeName", attributeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, relationshipProperties, OpenMetadataProperty.NOTES.name, notes, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", OpenMetadataType.REFERENCEABLE.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unassignReferenceValueFromItem(String userId, String externalSourceGUID, String externalSourceName, String validValueGUID, String referenceableGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, referenceableGUID, "referenceableGUID", OpenMetadataType.REFERENCEABLE.typeName, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public B getValidValueByGUID(String userId, String validValueGUID, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        return this.getBeanFromRepository(userId, validValueGUID, "validValueGUID", OpenMetadataType.VALID_VALUE_DEFINITION.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
    }

    public List<B> getValidValueByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PREFERRED_VALUE.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findValidValues(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getValidValueSetMembers(String userId, String validValueSetGUID, String validValueSetGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueSetGUID, validValueSetGUIDParameter, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getConsistentValidValues(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeGUID, OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, (String)null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSetsForValidValue(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, validValueGUID, validValueGUIDParameter, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getAssignedValidValues(String userId, String referenceableGUID, String referenceableGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, referenceableGUID, referenceableGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, effectiveTime, methodName);
    }

    public List<B> getReferenceValues(String userId, String referenceableGUID, String referenceableGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, null, null, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getValidValues(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> suppliedSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, suppliedSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

