/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class APIOperationHandler<B>
extends ReferenceableHandler<B> {
    public APIOperationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiGUID, apiGUIDParameterName, methodName);
        String typeName = OpenMetadataType.API_OPERATION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.API_OPERATION.typeName, this.serviceName, methodName, this.repositoryHelper);
        String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
        String apiSchemaTypeGUID = this.getAPISchemaTypeGUID(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, apiGUID, apiGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String apiOperationGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (apiOperationGUID != null) {
            String apiOperationGUIDParameterName = "apiOperationGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiSchemaTypeGUID, "apiSchemaTypeGUID", apiOperationGUID, "apiOperationGUID", OpenMetadataType.API_OPERATIONS_RELATIONSHIP.typeGUID, null, methodName);
        }
        return apiOperationGUID;
    }

    public String createAPIOperationFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
        String apiSchemaTypeGUID = this.getAPISchemaTypeGUID(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String apiOperationGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.API_OPERATION.typeGUID, OpenMetadataType.API_OPERATION.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        String apiOperationGUIDParameterName = "apiOperationGUID";
        this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, apiSchemaTypeGUID, "apiSchemaTypeGUID", apiOperationGUID, "apiOperationGUID", OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, null, methodName);
        return apiOperationGUID;
    }

    public void updateAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(apiOperationGUID, apiOperationGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.API_OPERATION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.API_OPERATION.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeAPIOperation(String userId, String externalSourceGUID, String externalSourceName, String apiOperationGUID, String apiOperationGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, apiOperationGUID, apiOperationGUIDParameterName, OpenMetadataType.API_OPERATION.typeGUID, OpenMetadataType.API_OPERATION.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findAPIOperations(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.API_OPERATION.typeGUID, OpenMetadataType.API_OPERATION.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.API_OPERATION.typeGUID, OpenMetadataType.API_OPERATION.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsForAPI(String userId, String apiGUID, String apiGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAPIOperationsForAPI(userId, apiGUID, apiGUIDParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAPIOperationsForAPI(String userId, String apiGUID, String apiGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail apiSchemaTypeEntity = this.getAttachedEntity(userId, apiGUID, apiGUIDParameterName, OpenMetadataType.DEPLOYED_API.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.API_SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity != null) {
            String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
            return this.getAttachedElements(userId, null, null, apiSchemaTypeEntity.getGUID(), "apiSchemaTypeGUID", OpenMetadataType.API_SCHEMA_TYPE.typeName, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeName, OpenMetadataType.API_OPERATION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    public List<B> getAPIOperationsForAPISchemaType(String userId, String apiSchemaTypeGUID, String apiSchemaTypeGUIDParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail apiSchemaTypeEntity = this.getEntityFromRepository(userId, apiSchemaTypeGUID, apiSchemaTypeGUIDParameterName, OpenMetadataType.API_SCHEMA_TYPE.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity != null) {
            return this.getAttachedElements(userId, null, null, apiSchemaTypeEntity.getGUID(), apiSchemaTypeGUIDParameterName, OpenMetadataType.API_SCHEMA_TYPE.typeName, OpenMetadataType.API_OPERATIONS_RELATIONSHIP.typeGUID, OpenMetadataType.API_OPERATIONS_RELATIONSHIP.typeName, OpenMetadataType.API_OPERATION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    private String getAPISchemaTypeGUID(String userId, String externalSourceGUID, String externalSourceName, String apiGUID, String apiGUIDParameterName, String topicQualifiedName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String apiSchemaTypeGUID;
        EntityDetail apiSchemaTypeEntity = this.getAttachedEntity(userId, apiGUID, apiGUIDParameterName, OpenMetadataType.DEPLOYED_API.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.API_SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (apiSchemaTypeEntity == null) {
            SchemaTypeBuilder builder = new SchemaTypeBuilder(topicQualifiedName + "_EventList", OpenMetadataType.API_SCHEMA_TYPE.typeGUID, OpenMetadataType.API_SCHEMA_TYPE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, apiGUID, apiGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
            apiSchemaTypeGUID = this.repositoryHandler.createEntity(userId, OpenMetadataType.API_SCHEMA_TYPE.typeGUID, OpenMetadataType.API_SCHEMA_TYPE.typeName, externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), builder.getEntityClassifications(), builder.getInstanceStatus(), methodName);
            if (apiSchemaTypeGUID != null) {
                String apiSchemaTypeGUIDParameterName = "apiSchemaTypeGUID";
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, apiGUID, apiGUIDParameterName, OpenMetadataType.DEPLOYED_API.typeName, apiSchemaTypeGUID, "apiSchemaTypeGUID", OpenMetadataType.API_SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            } else {
                this.errorHandler.logNullInstance(OpenMetadataType.API_SCHEMA_TYPE.typeName, methodName);
            }
        } else {
            apiSchemaTypeGUID = apiSchemaTypeEntity.getGUID();
        }
        return apiSchemaTypeGUID;
    }

    public B getAPIOperationByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.API_OPERATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

