/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ContributionRecordElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProfileIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProfileLocationElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ContactMethodProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ContributionRecord;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ProfileIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.locations.ProfileLocationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileConverter<B>
extends OMFConverter<B> {
    public ActorProfileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ActorProfileElement) {
                ActorProfileElement bean = (ActorProfileElement)returnBean;
                ActorProfileProperties profileProperties = new ActorProfileProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    profileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    profileProperties.setKnownName(this.removeName(instanceProperties));
                    profileProperties.setDescription(this.removeDescription(instanceProperties));
                    profileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    profileProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    profileProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    profileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    profileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProfileProperties(profileProperties);
                    HashMap<String, UserIdentityElement> userIdentities = new HashMap<String, UserIdentityElement>();
                    if (supplementaryEntities != null) {
                        ArrayList<ContactMethodElement> contactMethods = new ArrayList<ContactMethodElement>();
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity != null && entity.getType() != null) {
                                InstanceProperties entityProperties;
                                String entityTypeName = entity.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.USER_IDENTITY.typeName)) {
                                    UserIdentityElement userBean = new UserIdentityElement();
                                    UserIdentityProperties userProperties = new UserIdentityProperties();
                                    userBean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    userProperties.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    userProperties.setUserId(this.removeUserId(entityProperties));
                                    userProperties.setDistinguishedName(this.removeDistinguishedName(entityProperties));
                                    userProperties.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    userProperties.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                                    userProperties.setEffectiveTo(entityProperties.getEffectiveToTime());
                                    userProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    userProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    userBean.setProperties(userProperties);
                                    userIdentities.put(entity.getGUID(), userBean);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.CONTRIBUTION_RECORD.typeName)) {
                                    ContributionRecordElement contributionBean = new ContributionRecordElement();
                                    ContributionRecord contributionRecord = new ContributionRecord();
                                    contributionBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                    entityProperties = new InstanceProperties(entity.getProperties());
                                    contributionRecord.setQualifiedName(this.removeQualifiedName(entityProperties));
                                    contributionRecord.setAdditionalProperties(this.removeAdditionalProperties(entityProperties));
                                    contributionRecord.setKarmaPoints(this.removeKarmaPoints(entityProperties));
                                    if (contributionRecord.getKarmaPoints() > 0L && this.karmaPointPlateau > 0L) {
                                        contributionRecord.setKarmaPointPlateau(contributionRecord.getKarmaPoints() / this.karmaPointPlateau);
                                    }
                                    contributionRecord.setIsPublic(this.removeIsPublic(entityProperties));
                                    contributionRecord.setTypeName(bean.getElementHeader().getType().getTypeName());
                                    contributionRecord.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                    contributionBean.setProperties(contributionRecord);
                                    bean.setContributionRecord(contributionBean);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, OpenMetadataType.CONTACT_DETAILS.typeName)) continue;
                                ContactMethodElement contactMethodBean = new ContactMethodElement();
                                ContactMethodProperties contactMethodProperties = new ContactMethodProperties();
                                contactMethodBean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                                entityProperties = new InstanceProperties(entity.getProperties());
                                contactMethodProperties.setName(this.removeName(entityProperties));
                                contactMethodProperties.setContactType(this.removeContactType(entityProperties));
                                contactMethodProperties.setContactMethodType(this.getContactMethodTypeFromProperties(entityProperties));
                                contactMethodProperties.setContactMethodService(this.removeContactMethodService(entityProperties));
                                contactMethodProperties.setContactMethodValue(this.removeContactMethodValue(entityProperties));
                                contactMethodProperties.setEffectiveFrom(entityProperties.getEffectiveFromTime());
                                contactMethodProperties.setEffectiveTo(entityProperties.getEffectiveToTime());
                                contactMethodProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                                contactMethodProperties.setExtendedProperties(this.getRemainingExtendedProperties(entityProperties));
                                contactMethodBean.setProperties(contactMethodProperties);
                                contactMethods.add(contactMethodBean);
                                continue;
                            }
                            this.handleBadEntity(beanClass.getName(), entity, methodName);
                        }
                        if (!contactMethods.isEmpty()) {
                            bean.setContactMethods(contactMethods);
                        }
                    }
                    if (relationships != null) {
                        ArrayList<ElementStub> peers = new ArrayList<ElementStub>();
                        ElementStub superTeam = null;
                        ArrayList<ElementStub> subTeams = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> teamLeaders = new ArrayList<ElementStub>();
                        ArrayList<ElementStub> teamMembers = new ArrayList<ElementStub>();
                        ArrayList<ProfileIdentityElement> profileIdentities = new ArrayList<ProfileIdentityElement>();
                        ArrayList<ProfileLocationElement> locations = new ArrayList<ProfileLocationElement>();
                        ArrayList<ElementStub> roles = new ArrayList<ElementStub>();
                        ArrayList<RelatedElementStub> businessCapabilities = new ArrayList<RelatedElementStub>();
                        ArrayList<ElementStub> linkedInfrastructure = new ArrayList<ElementStub>();
                        for (Relationship relationship : relationships) {
                            if (relationship != null && relationship.getType() != null) {
                                ElementStub elementStub;
                                EntityProxy entityProxy;
                                String relationshipTypeName = relationship.getType().getTypeDefName();
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.PEER_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    peers.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    teamMembers.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    teamLeaders.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    roles.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.TEAM_ROLE_APPOINTMENT_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    roles.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.IT_PROFILE_ROLE_APPOINTMENT_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    roles.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.IT_INFRASTRUCTURE_PROFILE_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    linkedInfrastructure.add(elementStub);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.ORGANIZATIONAL_CAPABILITY_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    RelatedElementStub relatedElement = super.getRelatedElement(beanClass, relationship, entityProxy, methodName);
                                    businessCapabilities.add(relatedElement);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName)) {
                                    entityProxy = relationship.getEntityTwoProxy();
                                    elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                                    ProfileLocationElement locationElement = new ProfileLocationElement();
                                    ProfileLocationProperties locationProperties = new ProfileLocationProperties();
                                    locationProperties.setAssociationType(this.removeAssociationType(relationship.getProperties()));
                                    locationElement.setLocation(elementStub);
                                    locationElement.setProperties(locationProperties);
                                    locations.add(locationElement);
                                    continue;
                                }
                                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName)) {
                                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                                    ProfileIdentityElement profileIdentityElement = new ProfileIdentityElement();
                                    ProfileIdentityProperties profileIdentityProperties = new ProfileIdentityProperties();
                                    InstanceProperties relationshipProperties = relationship.getProperties();
                                    profileIdentityProperties.setRoleTypeName(this.removeDescription(relationshipProperties));
                                    profileIdentityProperties.setRoleGUID(this.removeDescription(relationshipProperties));
                                    profileIdentityProperties.setDescription(this.removeDescription(relationshipProperties));
                                    profileIdentityElement.setProfileIdentity(profileIdentityProperties);
                                    profileIdentityElement.setUserIdentity((UserIdentityElement)userIdentities.get(entityProxy.getGUID()));
                                    profileIdentities.add(profileIdentityElement);
                                    continue;
                                }
                                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeName)) continue;
                                entityProxy = relationship.getEntityOneProxy();
                                if (primaryEntity.getGUID().equals(entityProxy.getGUID())) {
                                    elementStub = super.getElementStub(beanClass, relationship.getEntityTwoProxy(), methodName);
                                    subTeams.add(elementStub);
                                    continue;
                                }
                                superTeam = super.getElementStub(beanClass, entityProxy, methodName);
                                continue;
                            }
                            this.handleBadRelationship(beanClass.getName(), relationship, methodName);
                        }
                        if (!profileIdentities.isEmpty()) {
                            bean.setUserIdentities(profileIdentities);
                        }
                        bean.setSuperTeam(superTeam);
                        if (!subTeams.isEmpty()) {
                            bean.setSubTeams(subTeams);
                        }
                        if (!peers.isEmpty()) {
                            bean.setPeers(peers);
                        }
                        if (!teamLeaders.isEmpty()) {
                            bean.setTeamLeaderRoles(teamLeaders);
                        }
                        if (!teamMembers.isEmpty()) {
                            bean.setTeamMemberRoles(teamMembers);
                        }
                        if (!roles.isEmpty()) {
                            bean.setPersonRoles(roles);
                        }
                        if (!businessCapabilities.isEmpty()) {
                            bean.setBusinessCapability(businessCapabilities);
                        }
                        if (!locations.isEmpty()) {
                            bean.setLocations(locations);
                        }
                        if (!linkedInfrastructure.isEmpty()) {
                            bean.setLinkedInfrastructure(linkedInfrastructure);
                        }
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

