/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ActorProfileHandler<B>
extends ReferenceableHandler<B> {
    public ActorProfileHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createActorProfile(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.ACTOR_PROFILE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ACTOR_PROFILE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(profileGUID, profileGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ACTOR_PROFILE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ActorProfileBuilder builder = new ActorProfileBuilder(qualifiedName, name, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void linkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, boolean delegationEscalationAuthority, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ActorProfileBuilder builder = new ActorProfileBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getTeamStructureProperties(delegationEscalationAuthority, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, OpenMetadataType.TEAM.typeName, subTeamGUID, subTeamGUIDParameterName, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeName, this.setUpEffectiveDates(relationshipProperties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void unlinkTeamHierarchy(String userId, String externalSourceGUID, String externalSourceName, String superTeamGUID, String superTeamGUIDParameterName, String subTeamGUID, String subTeamGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, superTeamGUID, superTeamGUIDParameterName, OpenMetadataType.TEAM.typeName, subTeamGUID, subTeamGUIDParameterName, OpenMetadataType.TEAM.typeGUID, OpenMetadataType.TEAM.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeGUID, OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeActorProfile(String userId, String externalSourceGUID, String externalSourceName, String profileGUID, String profileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, profileGUID, profileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeGUID, OpenMetadataType.ACTOR_PROFILE.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findActorProfiles(String userId, String searchString, String searchStringParameterName, String typeGUID, String typeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, typeGUID, typeName, null, null, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullProfileBean(userId, entity, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    public List<B> getActorProfilesByName(String userId, String name, String nameParameterName, String typeGUID, String typeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, typeGUID, typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getFullBeans(userId, entities, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getActorsForProject(String userId, String projectGUID, String projectGUIDParameterName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName, OpenMetadataType.ACTOR_PROFILE.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getActorProfilesByLocation(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getAttachedEntities(userId, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.ACTOR_PROFILE.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startingFrom, pageSize, effectiveTime, methodName);
        return this.getFullBeans(userId, entities, elementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getActorProfiles(String userId, String elementTypeGUID, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, elementTypeGUID, elementTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
        return this.getFullBeans(userId, entities, elementTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getActorProfileByGUID(String userId, String guid, String guidParameterName, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullProfileBean(userId, entity, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public EntityDetail getActorProfileEntityForUser(String userId, String profileUserId, String profileUserIdParameterName, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String userGUIDParameterName = "userIdentity.getGUID";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.USER_ID.name);
        EntityDetail userIdentity = this.getEntityByValue(userId, profileUserId, profileUserIdParameterName, OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (userIdentity != null) {
            return this.getAttachedEntity(userId, userIdentity.getGUID(), "userIdentity.getGUID", OpenMetadataType.USER_IDENTITY.typeName, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, typeName, 1, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        }
        return null;
    }

    public B getActorProfileForUser(String userId, String profileUserId, String profileUserIdParameterName, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getActorProfileEntityForUser(userId, profileUserId, profileUserIdParameterName, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullProfileBean(userId, entity, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private List<B> getFullBeans(String userId, List<EntityDetail> entities, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (entities != null) {
            ArrayList<B> beans = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullProfileBean(userId, entity, typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                beans.add(bean);
            }
            if (!beans.isEmpty()) {
                return beans;
            }
        }
        return null;
    }

    private B getFullProfileBean(String userId, EntityDetail primaryEntity, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String profileGUIDParameterName = "profileGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String contributionRecordGUIDParameterName = "contributionRecordGUID";
        String contactDetailsGUIDParameterName = "contactDetailsGUID";
        ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
        List<Relationship> relationships = this.getAllAttachmentLinks(userId, primaryEntity.getGUID(), "profileGUID", typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityDetail entity;
                EntityProxy entityProxy;
                if (relationship == null || relationship.getType() == null) continue;
                String relationshipTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName)) {
                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                    entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "userIdentityGUID", OpenMetadataType.USER_IDENTITY.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                    if (entity == null) continue;
                    supplementaryEntities.add(entity);
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeName)) {
                    entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                    entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "contactDetailsGUID", OpenMetadataType.CONTACT_DETAILS.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                    if (entity == null) continue;
                    supplementaryEntities.add(entity);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationshipTypeName, OpenMetadataType.CONTRIBUTION_RELATIONSHIP.typeName) || (entity = this.getEntityFromRepository(userId, (entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship)).getGUID(), "contributionRecordGUID", OpenMetadataType.CONTRIBUTION_RECORD.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) == null) continue;
                supplementaryEntities.add(entity);
            }
        }
        return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
    }
}

