/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String annotationType;
    private final String summary;
    private final int confidenceLevel;
    private final String expression;
    private final String explanation;
    private final String analysisStep;
    private final String jsonProperties;
    private final Map<String, String> additionalProperties;
    private Map<String, String> candidateClassifications = null;
    private List<String> candidateDataClassGUIDs = null;
    private long matchingValues = 0L;
    private long nonMatchingValues = 0L;
    private List<String> profilePropertyNames = null;
    private int length = 0;
    private String inferredDataType = null;
    private String inferredFormat = null;
    private int inferredLength = 0;
    private int inferredPrecision = 0;
    private int inferredScale = 0;
    private Date profileStartDate = null;
    private Date profileEndDate = null;
    private Map<String, String> profileProperties = null;
    private Map<String, Boolean> profileFlags = null;
    private Map<String, Date> profileDates = null;
    private Map<String, Long> profileCounts = null;
    private Map<String, Double> profileDoubles = null;
    private List<String> valueList = null;
    private Map<String, Integer> valueCount = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private String averageValue = null;
    private Map<String, String> resourceProperties = null;
    private Date createTime = null;
    private Date modifiedTime = null;
    private long size = 0L;
    private String encoding = null;
    private String qualityDimension = null;
    private int qualityScore = 0;
    private String relatedEntityGUID = null;
    private String relationshipTypeName = null;
    private Map<String, String> relationshipProperties = null;
    private String surveyActivity = null;
    private String actionRequested = null;
    private Map<String, String> actionProperties = null;
    private String schemaName = null;
    private String schemaTypeName = null;
    private String informalTerm = null;
    private String informalTopic = null;
    private List<String> candidateGlossaryTermGUIDs = null;
    private List<String> candidateGlossaryCategoryGUIDs = null;

    AnnotationBuilder(String annotationType, String summary, int confidenceLevel, String expression, String explanation, String analysisStep, String jsonProperties, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, List<Classification> existingClassifications, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, extendedProperties, InstanceStatus.ACTIVE, existingClassifications, repositoryHelper, serviceName, serverName);
        this.annotationType = annotationType;
        this.summary = summary;
        this.confidenceLevel = confidenceLevel;
        this.expression = expression;
        this.explanation = explanation;
        this.analysisStep = analysisStep;
        this.jsonProperties = jsonProperties;
        this.additionalProperties = additionalProperties;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    void setClassificationSubtypeProperties(Map<String, String> candidateClassifications) {
        this.candidateClassifications = candidateClassifications;
    }

    void setDataClassSubtypeProperties(List<String> candidateDataClassGUIDs, long matchingValues, long nonMatchingValues) {
        this.candidateDataClassGUIDs = candidateDataClassGUIDs;
        this.matchingValues = matchingValues;
        this.nonMatchingValues = nonMatchingValues;
    }

    void setResourceProfileSubtypeProperties(List<String> profilePropertyNames, int length, String inferredDataType, String inferredFormat, int inferredLength, int inferredPrecision, int inferredScale, Date profileStartDate, Date profileEndDate, Map<String, String> profileProperties, Map<String, Boolean> profileFlags, Map<String, Date> profileDates, Map<String, Long> profileCounts, Map<String, Double> profileDoubles, List<String> valueList, Map<String, Integer> valueCount, String valueRangeFrom, String valueRangeTo, String averageValue) {
        this.profilePropertyNames = profilePropertyNames;
        this.length = length;
        this.inferredDataType = inferredDataType;
        this.inferredFormat = inferredFormat;
        this.inferredLength = inferredLength;
        this.inferredPrecision = inferredPrecision;
        this.inferredScale = inferredScale;
        this.profileStartDate = profileStartDate;
        this.profileEndDate = profileEndDate;
        this.profileProperties = profileProperties;
        this.profileFlags = profileFlags;
        this.profileDates = profileDates;
        this.profileCounts = profileCounts;
        this.profileDoubles = profileDoubles;
        this.valueList = valueList;
        this.valueCount = valueCount;
        this.valueRangeFrom = valueRangeFrom;
        this.valueRangeTo = valueRangeTo;
        this.averageValue = averageValue;
    }

    void setResourceMeasurementSubtypeProperties(Map<String, String> resourceProperties) {
        this.resourceProperties = resourceProperties;
    }

    void setResourcePhysicalStatusSubtypeProperties(Map<String, String> resourceProperties, Date createTime, Date modifiedTime, long size, String encoding) {
        this.resourceProperties = resourceProperties;
        this.createTime = createTime;
        this.modifiedTime = modifiedTime;
        this.size = size;
        this.encoding = encoding;
    }

    void setQualitySubtypeProperties(String qualityDimension, int qualityScore) {
        this.qualityDimension = qualityDimension;
        this.qualityScore = qualityScore;
    }

    void setRelationshipAdviceSubtypeProperties(String relatedEntityGUID, String relationshipTypeName, Map<String, String> relationshipProperties) {
        this.relatedEntityGUID = relatedEntityGUID;
        this.relationshipTypeName = relationshipTypeName;
        this.relationshipProperties = relationshipProperties;
    }

    void setRequestForActionSubtypeProperties(String discoveryActivity, String actionRequested, Map<String, String> actionProperties) {
        this.surveyActivity = discoveryActivity;
        this.actionRequested = actionRequested;
        this.actionProperties = actionProperties;
    }

    void setSchemaAnalysisSubTypeProperties(String schemaName, String schemaTypeName) {
        this.schemaName = schemaName;
        this.schemaTypeName = schemaTypeName;
    }

    void setSemanticSubTypeProperties(String informalTerm, String informalTopic, List<String> candidateGlossaryTermGUIDs, List<String> candidateGlossaryCategoryGUIDs) {
        this.informalTerm = informalTerm;
        this.informalTopic = informalTopic;
        this.candidateGlossaryTermGUIDs = candidateGlossaryTermGUIDs;
        this.candidateGlossaryCategoryGUIDs = candidateGlossaryCategoryGUIDs;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANNOTATION_TYPE.name, this.annotationType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUMMARY.name, this.summary, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE_LEVEL.name, this.confidenceLevel, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXPRESSION.name, this.expression, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXPLANATION.name, this.explanation, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ANALYSIS_STEP.name, this.analysisStep, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.JSON_PROPERTIES.name, this.jsonProperties, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, this.additionalProperties, methodName);
        this.setEffectivityDates(properties);
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName)) {
            return this.addClassificationAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.DATA_CLASS_ANNOTATION.typeName)) {
            return this.addDataClassAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName)) {
            return this.addResourceProfileAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName)) {
            return this.addResourcePhysicalStatusAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName)) {
            return this.addResourceMeasurementAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.QUALITY_ANNOTATION.typeName)) {
            return this.addQualityAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName)) {
            return this.addRelationshipAdviceAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName)) {
            return this.addRequestForActionAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName)) {
            return this.addSchemaAnalysisAnnotationInstanceProperties(properties, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, OpenMetadataType.SEMANTIC_ANNOTATION.typeName)) {
            return this.addSemanticAnnotationInstanceProperties(properties, methodName);
        }
        return properties;
    }

    private InstanceProperties addClassificationAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.name, this.candidateClassifications, methodName);
        return properties;
    }

    private InstanceProperties addDataClassAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.name, this.candidateDataClassGUIDs, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MATCHING_VALUES.name, this.matchingValues, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NON_MATCHING_VALUES.name, this.nonMatchingValues, methodName);
        return properties;
    }

    private InstanceProperties addResourceProfileAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_PROPERTY_NAMES.name, this.profilePropertyNames, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LENGTH.name, this.length, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFERRED_DATA_TYPE.name, this.inferredDataType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFERRED_FORMAT.name, this.inferredFormat, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFERRED_LENGTH.name, this.inferredLength, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFERRED_PRECISION.name, this.inferredPrecision, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFERRED_SCALE.name, this.inferredScale, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_START_DATE.name, this.profileStartDate, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_END_DATE.name, this.profileEndDate, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_PROPERTIES.name, this.profileProperties, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_FLAGS.name, this.profileFlags, methodName);
        properties = this.repositoryHelper.addDateMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_DATES.name, this.profileDates, methodName);
        properties = this.repositoryHelper.addLongMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_COUNTS.name, this.profileCounts, methodName);
        properties = this.repositoryHelper.addDoubleMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROFILE_DOUBLES.name, this.profileDoubles, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VALUE_LIST.name, this.valueList, methodName);
        properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VALUE_COUNT.name, this.valueCount, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VALUE_RANGE_FROM.name, this.valueRangeFrom, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VALUE_RANGE_TO.name, this.valueRangeTo, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.AVERAGE_VALUE.name, this.averageValue, methodName);
        return properties;
    }

    private InstanceProperties addResourcePhysicalStatusAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.addResourceMeasurementAnnotationInstanceProperties(properties, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_CREATE_TIME.name, this.createTime, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_UPDATE_TIME.name, this.modifiedTime, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SIZE.name, this.size, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ENCODING.name, this.encoding, methodName);
        return properties;
    }

    private InstanceProperties addResourceMeasurementAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_PROPERTIES.name, this.resourceProperties, methodName);
        return properties;
    }

    private InstanceProperties addQualityAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUALITY_DIMENSION.name, this.qualityDimension, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUALITY_SCORE.name, this.qualityScore, methodName);
        return properties;
    }

    private InstanceProperties addRelationshipAdviceAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RELATED_ENTITY_GUID.name, this.relatedEntityGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name, this.relationshipTypeName, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RELATIONSHIP_PROPERTIES.name, this.relationshipProperties, methodName);
        return properties;
    }

    private InstanceProperties addRequestForActionAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_SOURCE_NAME.name, this.surveyActivity, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_REQUESTED.name, this.actionRequested, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_PROPERTIES.name, this.actionProperties, methodName);
        return properties;
    }

    private InstanceProperties addSchemaAnalysisAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SCHEMA_NAME.name, this.schemaName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SCHEMA_TYPE.name, this.schemaTypeName, methodName);
        return properties;
    }

    private InstanceProperties addSemanticAnnotationInstanceProperties(InstanceProperties properties, String methodName) {
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFORMAL_TERM.name, this.informalTerm, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.INFORMAL_CATEGORY.name, this.informalTopic, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.name, this.candidateGlossaryTermGUIDs, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.name, this.candidateGlossaryCategoryGUIDs, methodName);
        return properties;
    }
}

