/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.AnnotationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class AnnotationReviewBuilder
extends OpenMetadataAPIGenericBuilder {
    private final int annotationStatus;
    private final Date reviewDate;
    private final String steward;
    private final String reviewComment;

    public AnnotationReviewBuilder(int annotationStatus, Date reviewDate, String steward, String reviewComment, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, extendedProperties, null, null, repositoryHelper, serviceName, serverName);
        this.annotationStatus = annotationStatus;
        this.reviewDate = reviewDate;
        this.steward = steward;
        this.reviewComment = reviewComment;
        this.extendedProperties = extendedProperties;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public InstanceProperties getReviewLinkInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANNOTATION_STATUS.name, AnnotationStatus.getOpenTypeGUID(), AnnotationStatus.getOpenTypeName(), this.annotationStatus, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, AnnotationStatus.getOpenTypeName());
        }
        return properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) {
        InstanceProperties properties = new InstanceProperties();
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REVIEW_DATE.name, this.reviewDate, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, this.steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMMENT.name, this.reviewComment, methodName);
        return properties;
    }
}

