/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetHandler<B>
extends ReferenceableHandler<B> {
    private final List<String> supportedTypesForSearch;
    private final ConnectionHandler<OpenMetadataAPIDummyBean> connectionHandler;

    public AssetHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, List<String> supportedTypesForSearch, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.supportedTypesForSearch = supportedTypesForSearch;
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public AssetHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.supportedTypesForSearch = null;
        this.connectionHandler = new ConnectionHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTypesOfAssetList() {
        if (this.supportedTypesForSearch != null) {
            return this.supportedTypesForSearch;
        }
        return this.repositoryHelper.getSubTypesOf(this.serviceName, OpenMetadataType.ASSET.typeName);
    }

    public Map<String, String> getTypesOfAssetDescriptions() {
        List<String> assetTypeList = this.getTypesOfAssetList();
        HashMap<String, String> assetDescriptions = new HashMap<String, String>();
        if (assetTypeList != null) {
            for (String assetTypeName : assetTypeList) {
                TypeDef assetTypeDef;
                if (assetTypeName == null || (assetTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, assetTypeName)) == null) continue;
                assetDescriptions.put(assetTypeName, assetTypeDef.getDescription());
            }
        }
        if (assetDescriptions.isEmpty()) {
            return null;
        }
        return assetDescriptions;
    }

    public String getExternalSourceID(boolean externalSourceIsHome, String externalSourceID) {
        if (externalSourceIsHome) {
            return externalSourceID;
        }
        return null;
    }

    public void addGovernanceMeasurementsDataSetClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_MEASUREMENTS_RESULTS_DATA_SET_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_MEASUREMENTS_RESULTS_DATA_SET_CLASSIFICATION.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceMeasurementsDataSetClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_MEASUREMENTS_RESULTS_DATA_SET_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_MEASUREMENTS_RESULTS_DATA_SET_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void attachSchemaTypeToAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.removeAssociatedSchemaType(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeAssociatedSchemaType(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkAllElements(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void attachAssetToSoftwareServerCapability(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String softwareServerCapabilityGUID, String softwareServerCapabilityGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (assetGUID != null && softwareServerCapabilityGUID != null) {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, softwareServerCapabilityGUID, softwareServerCapabilityGUIDParameterName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
    }

    public String detachSchemaTypeFromAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.unlinkConnectedElement(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, effectiveTime, methodName);
    }

    public String addAssetFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String expectedTypeGUID, String expectedTypeName, String qualifiedName, String qualifiedNameParameterName, String name, String versionIdentifier, String description, String deployedImplementationType, String pathName, String networkAddress, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        Relationship connectionEndpointRelationship;
        Relationship assetConnectionRelationship;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        HashMap<String, Object> extendedProperties = null;
        if (pathName != null) {
            extendedProperties = new HashMap<String, Object>();
            extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        }
        AssetBuilder builder = new AssetBuilder(qualifiedName, name, name, versionIdentifier, description, deployedImplementationType, null, expectedTypeGUID, expectedTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail templateEntity = this.getEntityFromRepository(userId, templateGUID, templateGUIDParameterName, OpenMetadataType.ASSET.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        builder.setAnchors(userId, null, templateEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName, null, methodName);
        String assetGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, expectedTypeGUID, expectedTypeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        if (assetGUID != null && (assetConnectionRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null && (connectionEndpointRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID = assetConnectionRelationship.getEntityOneProxy().getGUID(), OpenMetadataType.CONNECTION.typeName, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            String endpointGUIDParameterName = "endpointGUID";
            String endpointGUID = connectionEndpointRelationship.getEntityOneProxy().getGUID();
            EntityDetail endpointEntity = this.getEntityFromRepository(userId, endpointGUID, "endpointGUID", OpenMetadataType.ENDPOINT.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)endpointEntity, methodName);
            if (assetGUID.equals(anchorIdentifiers.anchorGUID)) {
                InstanceProperties endpointProperties = endpointEntity.getProperties();
                endpointProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, endpointProperties, OpenMetadataProperty.NETWORK_ADDRESS.name, networkAddress, methodName);
                this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, endpointGUID, endpointEntity, OpenMetadataType.ENDPOINT.typeGUID, OpenMetadataType.ENDPOINT.typeName, endpointProperties, methodName);
            }
        }
        return assetGUID;
    }

    public String createAssetInRepository(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String versionIdentifier, String resourceDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createAssetInRepository(userId, externalSourceGUID, externalSourceName, qualifiedName, name, name, versionIdentifier, resourceDescription, deployedImplementationType, additionalProperties, typeName, extendedProperties, instanceStatus, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String createAssetInRepository(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String name, String resourceName, String versionIdentifier, String resourceDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetTypeName = OpenMetadataType.ASSET.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        String assetTypeId = this.invalidParameterHandler.validateTypeName(assetTypeName, OpenMetadataType.ASSET.typeName, this.serviceName, methodName, this.repositoryHelper);
        AssetBuilder builder = new AssetBuilder(qualifiedName, name, resourceName, versionIdentifier, resourceDescription, deployedImplementationType, additionalProperties, assetTypeId, assetTypeName, extendedProperties, instanceStatus, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (this.defaultZones != null) {
            builder.setAssetZones(userId, this.defaultZones, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, assetTypeId, assetTypeName, OpenMetadataType.ASSET.typeName, null, builder, true, effectiveTime, methodName);
    }

    public String createAssetWithConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUIDParameterName, String assetQualifiedName, String name, String resourceName, String versionIdentifier, String resourceDescription, String deployedImplementationType, Map<String, String> additionalProperties, String assetTypeName, Map<String, Object> extendedProperties, InstanceStatus instanceStatus, boolean anchorEndpointToAsset, Map<String, Object> configurationProperties, String connectorProviderClassName, String networkAddress, String protocol, String encryptionMethod, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUID = this.createAssetInRepository(userId, externalSourceGUID, externalSourceName, assetQualifiedName, name, resourceName, versionIdentifier, resourceDescription, deployedImplementationType, additionalProperties, assetTypeName, extendedProperties, instanceStatus, effectiveFrom, effectiveTo, effectiveTime, methodName);
        if (assetGUID != null) {
            this.connectionHandler.addAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetTypeName, assetQualifiedName, anchorEndpointToAsset, configurationProperties, connectorProviderClassName, networkAddress, protocol, encryptionMethod, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return assetGUID;
    }

    public void updateAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String name, String resourceName, String versionIdentifier, String technicalDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ASSET.typeName, this.serviceName, methodName, this.repositoryHelper);
        this.updateAsset(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, qualifiedName, name, resourceName, versionIdentifier, technicalDescription, deployedImplementationType, additionalProperties, typeGUID, typeName, this.supportedZones, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAsset(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, qualifiedName, technicalName, technicalName, versionIdentifier, technicalDescription, deployedImplementationType, additionalProperties, typeGUID, typeName, this.supportedZones, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateAsset(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String name, String resourceName, String versionIdentifier, String resourceDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeGUID, String typeName, List<String> suppliedSupportedZones, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetBuilder builder = new AssetBuilder(qualifiedName, name, resourceName, versionIdentifier, resourceDescription, deployedImplementationType, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void updateAssetWithConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String name, String resourceName, String versionIdentifier, String description, String deployedImplementationType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, String assetSummary, Connection connection, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAsset(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, qualifiedName, name, resourceName, versionIdentifier, description, deployedImplementationType, additionalProperties, typeGUID, typeName, serviceSupportedZones, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        Relationship assetConnectionRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, OpenMetadataType.ASSET.typeName, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (assetConnectionRelationship != null) {
            this.unlinkConnectedElement(userId, false, null, null, assetGUID, assetGUIDParameterName, typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, effectiveTime, methodName);
        }
        assetConnectionRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (connection == null) {
            this.unlinkConnectedElement(userId, false, null, null, assetGUID, assetGUIDParameterName, typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, effectiveTime, methodName);
        } else {
            String connectionGUID = this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, assetGUIDParameterName, typeName, qualifiedName, connection, assetSummary, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (assetConnectionRelationship == null) {
                this.repositoryHandler.createRelationship(userId, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, null, null, assetGUID, connectionGUID, null, methodName);
            }
        }
    }

    public void classifyAssetAsReferenceData(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.setClassificationInRepository(userId, null, null, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeGUID, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName, null, false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void declassifyAssetAsReferenceData(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeGUID, OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, String organizationGUID, String organizationGUIDParameterName, String businessCapabilityGUID, String businessCapabilityGUIDParameterName, Map<String, String> otherOriginValues, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (organizationGUID != null) {
            this.validateEntityAndAnchorForRead(userId, organizationGUID, organizationGUIDParameterName, OpenMetadataType.ORGANIZATION.typeName, true, false, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveFrom, methodName);
        }
        if (businessCapabilityGUID != null) {
            this.validateEntityAndAnchorForRead(userId, businessCapabilityGUID, businessCapabilityGUIDParameterName, OpenMetadataType.BUSINESS_CAPABILITY.typeName, true, false, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveFrom, methodName);
        }
        AssetBuilder builder = new AssetBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getOriginProperties(organizationGUID, OpenMetadataProperty.GUID.name, businessCapabilityGUID, OpenMetadataProperty.GUID.name, otherOriginValues, methodName);
        this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, null, null, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeGUID, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeName, properties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeAssetOrigin(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeGUID, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAssetsFromOrigin(String userId, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties classificationMatchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ORGANIZATION.name, organizationGUID, methodName);
        classificationMatchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationMatchProperties, OpenMetadataProperty.BUSINESS_CAPABILITY.name, businessCapabilityGUID, methodName);
        classificationMatchProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, classificationMatchProperties, OpenMetadataProperty.OTHER_ORIGIN_VALUES.name, otherOriginValues, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeName, classificationMatchProperties, MatchCriteria.ALL, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, entities);
    }

    public void publishAsset(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAssetZones(userId, assetGUID, assetGUIDParameterName, this.publishZones, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawAsset(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateAssetZones(userId, assetGUID, assetGUIDParameterName, this.defaultZones, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateAssetZones(String userId, String assetGUID, String assetGUIDParameterName, List<String> assetZones, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        AssetBuilder builder = new AssetBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeGUID, OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeName, builder.getZoneMembershipProperties(assetZones, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    @Deprecated
    public void updateAssetOwner(String userId, String assetGUID, String assetGUIDParameterName, String ownerId, int ownerType, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String ownerTypeName = null;
        if (ownerType == 0) {
            ownerTypeName = OpenMetadataType.USER_IDENTITY.typeName;
        } else if (ownerType == 1) {
            ownerTypeName = OpenMetadataType.ACTOR_PROFILE.typeName;
        }
        this.addOwner(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, ownerId, ownerTypeName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String getAssetForConnection(String userId, String connectionGUID, String connectionGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUID = this.getAttachedElementGUID(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, OpenMetadataType.ASSET.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (assetGUID != null) {
            return assetGUID;
        }
        return this.getAttachedElementGUID(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, OpenMetadataType.ASSET.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String getAssetForConnectionName(String userId, String connectionName, String connectionNameParameter, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        List<String> connectionGUIDs = this.getEntityGUIDsByValue(userId, connectionName, connectionNameParameter, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (connectionGUIDs != null) {
            for (String connectionGUID : connectionGUIDs) {
                if (connectionGUID == null) continue;
                return this.getAssetForConnection(userId, connectionGUID, connectionNameParameter, serviceSupportedZones, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    public B getAssetWithConnection(String userId, String assetGUID, String assetGUIDParameterName, String assetTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail assetEntity = this.getEntityFromRepository(userId, assetGUID, assetGUIDParameterName, assetTypeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (assetEntity != null) {
            return this.getAssetWithConnectionBean(userId, assetEntity, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return null;
    }

    public B getAssetByNameWithConnection(String userId, String name, String nameParameterName, String assetTypeGUID, String assetTypeName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.RESOURCE_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        List<EntityDetail> results = this.getEntitiesByValue(userId, name, nameParameterName, assetTypeGUID, assetTypeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results != null && results.size() == 1) {
            return this.getAssetWithConnectionBean(userId, results.get(0), forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        this.errorHandler.handleAmbiguousEntityName(name, nameParameterName, assetTypeName, results, methodName);
        return null;
    }

    public List<B> getAllAssetsWithConnection(String userId, String assetTypeGUID, String assetTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getEntitiesByType(userId, assetTypeGUID, assetTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null && !entities.isEmpty()) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getAssetWithConnectionBean(userId, entity, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private B getAssetWithConnectionBean(String userId, EntityDetail assetEntity, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (assetEntity != null) {
            EntityDetail connectionEntity = null;
            EntityProxy connectionProxy = null;
            Relationship relationshipToConnection = this.repositoryHandler.getUniqueRelationshipByType(userId, assetEntity.getGUID(), assetEntity.getType().getTypeDefName(), OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (relationshipToConnection != null) {
                connectionProxy = relationshipToConnection.getEntityTwoProxy();
            } else {
                relationshipToConnection = this.repositoryHandler.getUniqueRelationshipByType(userId, assetEntity.getGUID(), assetEntity.getType().getTypeDefName(), OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (relationshipToConnection != null) {
                    connectionProxy = relationshipToConnection.getEntityOneProxy();
                }
            }
            if (connectionProxy != null) {
                String connectionGUIDParameterName = "relationshipToConnection.getEntityProxy().getGUID()";
                connectionEntity = this.getEntityFromRepository(userId, connectionProxy.getGUID(), "relationshipToConnection.getEntityProxy().getGUID()", OpenMetadataType.CONNECTION.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            }
            ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            if (connectionEntity != null && connectionEntity.getType() != null) {
                supplementaryEntities.add(connectionEntity);
                supplementaryRelationships.add(relationshipToConnection);
                List<Relationship> connectionRelationships = this.getEmbeddedConnectionRelationships(userId, (EntitySummary)connectionEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                if (connectionRelationships != null) {
                    supplementaryRelationships.addAll(connectionRelationships);
                    for (Relationship relationship : connectionRelationships) {
                        if (relationship == null || relationship.getType() == null) continue;
                        EntityProxy entityProxy = null;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName)) {
                            entityProxy = relationship.getEntityTwoProxy();
                        } else if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName)) {
                            entityProxy = relationship.getEntityOneProxy();
                        }
                        if (entityProxy == null || entityProxy.getGUID() == null || entityProxy.getType() == null) continue;
                        String entityGUIDParameterName = "embeddedRelationship proxy";
                        EntityDetail supplementaryEntity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "embeddedRelationship proxy", entityProxy.getType().getTypeDefName(), null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                        if (supplementaryEntity == null) continue;
                        supplementaryEntities.add(supplementaryEntity);
                    }
                }
            }
            if (supplementaryEntities.isEmpty()) {
                supplementaryEntities = null;
            }
            if (supplementaryRelationships.isEmpty()) {
                supplementaryEntities = null;
            }
            return this.converter.getNewComplexBean(this.beanClass, assetEntity, supplementaryEntities, supplementaryRelationships, methodName);
        }
        return null;
    }

    private List<Relationship> getEmbeddedConnectionRelationships(String userId, EntitySummary connectionEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
        if (connectionEntity != null && connectionEntity.getType() != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, connectionEntity.getGUID(), connectionEntity.getType().getTypeDefName(), null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                List<Relationship> embeddedConnectionRelationships;
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName)) {
                    supplementaryRelationships.add(relationship);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName)) continue;
                supplementaryRelationships.add(relationship);
                EntityProxy embeddedConnectionEnd = relationship.getEntityTwoProxy();
                if (embeddedConnectionEnd == null || embeddedConnectionEnd.getGUID() == null || (embeddedConnectionRelationships = this.getEmbeddedConnectionRelationships(userId, (EntitySummary)embeddedConnectionEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                supplementaryRelationships.addAll(embeddedConnectionRelationships);
            }
        }
        if (supplementaryRelationships.isEmpty()) {
            return null;
        }
        return supplementaryRelationships;
    }

    public List<B> assetScan(String userId, String subTypeGUID, String subTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetZoneScan(userId, null, subTypeGUID, subTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> assetZoneScan(String userId, String zoneName, String subTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (subTypeName == null) {
            return this.assetZoneScan(userId, zoneName, null, null, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        String subTypeGUID = this.invalidParameterHandler.validateTypeName(subTypeName, OpenMetadataType.ASSET.typeName, this.serviceName, methodName, this.repositoryHelper);
        return this.assetZoneScan(userId, zoneName, subTypeGUID, subTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> assetZoneScan(String userId, String zoneName, String subTypeGUID, String subTypeName, List<String> suppliedSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (subTypeGUID != null) {
            resultTypeGUID = subTypeGUID;
        }
        if (subTypeName != null) {
            resultTypeName = subTypeName;
        }
        InstanceProperties matchClassificationProperties = null;
        if (zoneName != null) {
            matchClassificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ZONE_MEMBERSHIP.name, zoneName, methodName);
        }
        List retrievedEntities = this.repositoryHandler.getEntitiesForClassificationType(userId, resultTypeGUID, OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeName, matchClassificationProperties, MatchCriteria.ANY, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, suppliedSupportedZones, methodName, retrievedEntities);
    }

    public List<B> findAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssetsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.RESOURCE_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getAssetGUIDsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetGUIDsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> getAssetGUIDsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.RESOURCE_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        return this.getEntityGUIDsByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetsByName(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAssetsByName(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.RESOURCE_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PATH_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssetsByDeployedImplementationType(String userId, String typeGUID, String typeName, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetsByDeployedImplementationType(userId, typeGUID, typeName, name, nameParameterName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAssetsByDeployedImplementationType(String userId, String typeGUID, String typeName, String name, String nameParameterName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        if (name == null) {
            return this.getBeansByType(userId, resultTypeGUID, resultTypeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name);
        return this.getBeansByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssetsByMetadataCollectionId(String userId, String typeName, String metadataCollectionId, String metadataCollectionIdParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.METADATA_COLLECTION_ID.name);
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeName != null) {
            resultTypeName = typeName;
            resultTypeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ASSET.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        return this.getBeansByValue(userId, metadataCollectionId, metadataCollectionIdParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> findAssetGUIDs(String userId, String searchString, String searchStringParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssetGUIDs(userId, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, searchString, searchStringParameter, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<String> findAssetGUIDs(String userId, String typeGUID, String typeName, String searchString, String searchStringParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getEntityGUIDsByValue(userId, searchString, searchStringParameter, resultTypeGUID, resultTypeName, null, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findAssets(String userId, String searchString, String searchStringParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.findAssets(userId, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, searchString, searchStringParameter, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findAssets(String userId, String typeGUID, String typeName, String searchString, String searchStringParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.ASSET.typeGUID;
        String resultTypeName = OpenMetadataType.ASSET.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.findBeans(userId, searchString, searchStringParameter, resultTypeGUID, resultTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<String> getAssetGUIDsByTag(String userId, String tagGUID, String tagGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElementGUIDs(userId, tagGUID, tagGUIDParameterName, OpenMetadataType.INFORMAL_TAG.typeName, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, OpenMetadataType.ASSET.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

