/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CollectionBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String collectionType = null;

    CollectionBuilder(String qualifiedName, String displayName, String description, String collectionType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.collectionType = collectionType;
    }

    CollectionBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.COLLECTION.typeGUID, OpenMetadataType.COLLECTION.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    CollectionBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.COLLECTION.typeGUID, OpenMetadataType.COLLECTION.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COLLECTION_TYPE.name, this.collectionType, methodName);
        return properties;
    }

    void setupCollectionClassification(String userId, String classificationName, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, classificationName);
        }
    }

    InstanceProperties getFolderProperties(int orderBy, String orderPropertyName, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.COLLECTION_ORDER.name, orderBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ORDER_BY_PROPERTY_NAME.name, orderPropertyName, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }
}

