/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CollectionMembershipConverter<B>
extends OMFConverter<B> {
    public CollectionMembershipConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                CollectionProperties collectionProperties = new CollectionProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    collectionProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    collectionProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    collectionProperties.setName(this.removeName(instanceProperties));
                    collectionProperties.setDescription(this.removeDescription(instanceProperties));
                    collectionProperties.setCollectionType(this.removeCollectionType(instanceProperties));
                    collectionProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    collectionProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    collectionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    collectionProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(collectionProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

