/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CommentBuilder
extends ReferenceableBuilder {
    private final int commentType;
    private final String commentText;
    private final boolean isPublic;

    public CommentBuilder(String qualifiedName, int commentType, String commentText, boolean isPublic, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, repositoryHelper, serviceName, serverName);
        this.commentText = commentText;
        this.commentType = commentType;
        this.isPublic = isPublic;
    }

    public InstanceProperties getRelationshipInstanceProperties(String methodName) {
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IS_PUBLIC.name, this.isPublic, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TEXT.name, this.commentText, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMMENT_TYPE.name, CommentType.getOpenTypeGUID(), CommentType.getOpenTypeName(), this.commentType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.COMMENT_TYPE.name);
        }
        return properties;
    }
}

