/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CommunityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.communities.CommunityProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommunityConverter<B>
extends OMFConverter<B> {
    public CommunityConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CommunityElement) {
                CommunityElement bean = (CommunityElement)returnBean;
                CommunityProperties communityProperties = new CommunityProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                if (entity != null) {
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    communityProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    communityProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    communityProperties.setName(this.removeName(instanceProperties));
                    communityProperties.setDescription(this.removeDescription(instanceProperties));
                    communityProperties.setMission(this.removeMission(instanceProperties));
                    communityProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    communityProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    communityProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    communityProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                bean.setProperties(communityProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof CommunityElement) {
            CommunityElement bean = (CommunityElement)returnBean;
            bean.setRelatedBy(super.getRelatedBy(beanClass, relationship, methodName));
        }
        return returnBean;
    }
}

