/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommunityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class CommunityHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public CommunityHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createCommunity(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String mission, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = OpenMetadataType.COMMUNITY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.COMMUNITY.typeName, this.serviceName, methodName, this.repositoryHelper);
        CommunityBuilder builder = new CommunityBuilder(qualifiedName, displayName, description, mission, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public String createCommunityFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        CommunityBuilder builder = new CommunityBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.COMMUNITY.typeName, OpenMetadataType.COMMUNITY.typeName, null, methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.COMMUNITY.typeGUID, OpenMetadataType.COMMUNITY.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
    }

    public void updateCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, String communityGUIDParameterName, String qualifiedName, String displayName, String description, String mission, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(communityGUID, communityGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String typeName = OpenMetadataType.COMMUNITY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.COMMUNITY.typeName, this.serviceName, methodName, this.repositoryHelper);
        CommunityBuilder builder = new CommunityBuilder(qualifiedName, displayName, description, mission, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, communityGUID, communityGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addRoleToCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, String communityGUIDParameterName, String memberGUID, String memberGUIDParameterName, int membershipType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties;
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.MEMBERSHIP_TYPE.name, CommunityMembershipType.getOpenTypeGUID(), CommunityMembershipType.getOpenTypeName(), membershipType, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)classificationNotSupported, OpenMetadataProperty.MEMBERSHIP_TYPE.name);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, communityGUID, communityGUIDParameterName, OpenMetadataType.COMMUNITY.typeName, memberGUID, memberGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeRoleFromCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, String communityGUIDParameterName, String memberGUID, String memberGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, communityGUID, communityGUIDParameterName, OpenMetadataType.COMMUNITY.typeName, memberGUID, memberGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeCommunity(String userId, String externalSourceGUID, String externalSourceName, String communityGUID, String communityGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, communityGUID, communityGUIDParameterName, OpenMetadataType.COMMUNITY.typeGUID, OpenMetadataType.COMMUNITY.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findCommunities(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.COMMUNITY.typeGUID, OpenMetadataType.COMMUNITY.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getCommunitiesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.COMMUNITY.typeGUID, OpenMetadataType.COMMUNITY.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCommunities(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.COMMUNITY.typeGUID, OpenMetadataType.COMMUNITY.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getCommunityByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.COMMUNITY.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

