/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EmbeddedConnectionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBean;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionHandler<B>
extends ReferenceableHandler<B> {
    private final EndpointHandler<OpenMetadataAPIDummyBean> endpointHandler;
    private final ConnectorTypeHandler<OpenMetadataAPIDummyBean> connectorTypeHandler;

    public ConnectionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.endpointHandler = new EndpointHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler<OpenMetadataAPIDummyBean>(new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), OpenMetadataAPIDummyBean.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findConnection(String userId, String connectionGUID, String qualifiedName, String displayName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectionGUID";
        String qualifiedNameParameter = "qualifiedName";
        String displayNameParameter = "displayName";
        if (connectionGUID != null) {
            try {
                if (this.getEntityFromRepository(userId, connectionGUID, "connectionGUID", OpenMetadataType.CONNECTION.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName) != null) {
                    return connectionGUID;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
        String retrievedGUID = null;
        if (qualifiedName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, qualifiedName, "qualifiedName", OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, effectiveTime, methodName);
        }
        if (retrievedGUID == null && displayName != null) {
            retrievedGUID = this.getBeanGUIDByUniqueName(userId, displayName, "displayName", OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, effectiveTime, methodName);
        }
        return retrievedGUID;
    }

    public String saveConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, String parentQualifiedName, Connection connection, String assetSummary, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionParameterName = "connection";
        String connectorTypeParameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection, "connection", methodName);
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", methodName);
        String existingConnectionGUID = this.findConnection(userId, connection.getGUID(), connection.getQualifiedName(), connection.getDisplayName(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (existingConnectionGUID == null) {
            return this.addConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, assetGUID, assetGUIDParameterName, assetTypeName, parentQualifiedName, connection, assetSummary, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
        return this.updateConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, existingConnectionGUID, connection, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    private void saveAssociatedConnectionEntities(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String connectionGUID, String connectionQualifiedName, Endpoint endpoint, ConnectorType connectorType, List<EmbeddedConnection> embeddedConnections, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUIDParameterName = "connectionGUID";
        if (endpoint != null) {
            String endpointGUID = this.endpointHandler.saveEndpoint(userId, externalSourceGUID, externalSourceName, connectionQualifiedName, endpoint, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (endpointGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, OpenMetadataType.ENDPOINT.typeName, null, null, connectionGUID, endpointGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, OpenMetadataType.CONNECTION.typeName, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, OpenMetadataType.CONNECTION.typeName, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (connectorType != null) {
            String connectorTypeGUID = this.connectorTypeHandler.saveConnectorType(userId, externalSourceGUID, externalSourceName, connectionQualifiedName, connectorType, methodName);
            if (connectorTypeGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, externalSourceGUID, externalSourceName, OpenMetadataType.CONNECTION.typeName, connectionGUID, connectorTypeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, OpenMetadataType.CONNECTION.typeName, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.unlinkAllElements(userId, false, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName, effectiveTime, methodName);
        if (embeddedConnections != null && !embeddedConnections.isEmpty()) {
            for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                if (embeddedConnection == null) continue;
                Connection realConnection = embeddedConnection.getEmbeddedConnection();
                String realConnectionGUID = this.saveConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, null, null, null, connectionQualifiedName, realConnection, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (realConnection == null) continue;
                EmbeddedConnectionBuilder embeddedConnectionBuilder = new EmbeddedConnectionBuilder(embeddedConnection.getPosition(), embeddedConnection.getArguments(), embeddedConnection.getDisplayName(), this.repositoryHelper, this.serviceName, this.serverName);
                this.repositoryHandler.createRelationship(userId, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeGUID, externalSourceGUID, externalSourceName, connectionGUID, realConnectionGUID, embeddedConnectionBuilder.getInstanceProperties(methodName), methodName);
            }
        }
    }

    private String addConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String assetGUID, String assetGUIDParameterName, String assetTypeName, String parentQualifiedName, Connection connection, String assetSummary, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        EntityDetail anchorEntity;
        Object connectionQualifiedName;
        String connectionParameterName = "connection";
        String anchorGUIDParameterName = "anchorGUID";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeGUID = OpenMetadataType.CONNECTION.typeGUID;
        String connectionTypeName = OpenMetadataType.CONNECTION.typeName;
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            connectionTypeGUID = OpenMetadataType.VIRTUAL_CONNECTION.typeGUID;
            connectionTypeName = OpenMetadataType.VIRTUAL_CONNECTION.typeName;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        if ((connectionQualifiedName = connection.getQualifiedName()) == null && parentQualifiedName != null) {
            connectionQualifiedName = parentQualifiedName + "-" + connectionTypeName;
        }
        ConnectionBuilder connectionBuilder = new ConnectionBuilder((String)connectionQualifiedName, connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, connection.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorGUID != null && OpenMetadataType.ASSET.typeName.equals((anchorEntity = this.setUpAnchorsClassificationFromAnchor(userId, anchorGUID, "anchorGUID", null, connectionBuilder, forLineage, forDuplicateProcessing, effectiveTime, methodName)).getType().getTypeDefName())) {
            this.invalidParameterHandler.validateAssetInSupportedZone(anchorEntity.getGUID(), "anchorGUID", serviceSupportedZones, this.securityVerifier.getSupportedZones(userId, serviceSupportedZones), this.serviceName, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeGUID, connectionTypeName, this.getDomainName(connectionTypeName), null, connectionBuilder, anchorGUID == null, effectiveTime, methodName)) != null) {
            this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, connectionGUID, (String)connectionQualifiedName, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
            if (assetGUID != null) {
                InstanceProperties properties = null;
                if (assetSummary != null) {
                    properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ASSET_SUMMARY.name, assetSummary, methodName);
                }
                this.linkElementToElement(userId, null, null, assetGUID, assetGUIDParameterName, assetTypeName, connectionGUID, "connection", OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, properties, null, null, effectiveTime, methodName);
            }
        }
        return connectionGUID;
    }

    private String updateConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String existingConnectionGUID, Connection connection, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "connection";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection", methodName);
        String connectionTypeName = OpenMetadataType.CONNECTION.typeName;
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            connectionTypeName = OpenMetadataType.VIRTUAL_CONNECTION.typeName;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        this.updateConnection(userId, externalSourceGUID, externalSourceName, existingConnectionGUID, "connection", connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectionTypeName, connection.getExtendedProperties(), false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, anchorGUID, existingConnectionGUID, connection.getQualifiedName(), connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        return existingConnectionGUID;
    }

    public void addAssetConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetTypeName, String assetQualifiedName, boolean anchorEndpointToAsset, Map<String, Object> configurationProperties, String connectorProviderClassName, String networkAddress, String protocol, String encryptionMethod, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectorTypeGUID;
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        if (connectorProviderClassName != null) {
            String connectorTypeName = assetTypeName + "::" + assetQualifiedName + " ConnectorType";
            connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForConnection(userId, null, null, assetGUID, connectorTypeName, connectorTypeName, null, assetTypeName, null, null, connectorProviderClassName, "Open Connector Framework (OCF)", "Java", null, null, null, null, null, null, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForAsset(userId, assetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (connectorTypeGUID != null) {
            String endpointGUIDParameterName = "endpointGUID";
            String endpointDescription = "Access information to connect to the actual asset: ";
            String endpointName = assetQualifiedName + " Endpoint";
            String connectionName = assetQualifiedName + " Connection";
            String anchorGUID = null;
            if (anchorEndpointToAsset) {
                anchorGUID = assetGUID;
            }
            String endpointGUID = this.endpointHandler.getEndpointForConnection(userId, externalSourceGUID, externalSourceName, anchorGUID, endpointName, endpointName, "Access information to connect to the actual asset: " + networkAddress, networkAddress, protocol, encryptionMethod, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, connectionName, connectionName, null, null, null, configurationProperties, null, null, null, OpenMetadataType.CONNECTION.typeName, null, connectorTypeGUID, "connectorTypeGUID", endpointGUID, "endpointGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        }
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.createConnection(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, OpenMetadataType.CONNECTION.typeName, null, connectorTypeGUID, connectorTypeGUIDParameterName, endpointGUID, endpointGUIDParameterName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public String createConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String suppliedConnectionTypeName, Map<String, Object> extendedProperties, String connectorTypeGUID, String connectorTypeGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID;
        EntityDetail assetEntity;
        String nameParameter = "qualifiedName";
        String connectionGUIDParameterName = "connectionGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String connectionTypeName = OpenMetadataType.CONNECTION.typeName;
        if (suppliedConnectionTypeName != null) {
            connectionTypeName = suppliedConnectionTypeName;
        }
        String connectionTypeId = this.invalidParameterHandler.validateTypeName(connectionTypeName, OpenMetadataType.CONNECTION.typeName, this.serviceName, methodName, this.repositoryHelper);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, connectionTypeId, connectionTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (assetGUID != null && (assetEntity = this.setUpAnchorsClassificationFromAnchor(userId, assetGUID, assetGUIDParameterName, null, builder, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetEntity.getGUID(), assetGUIDParameterName, serviceSupportedZones, this.securityVerifier.getSupportedZones(userId, serviceSupportedZones), this.serviceName, methodName);
        }
        if ((connectionGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionTypeId, connectionTypeName, this.getDomainName(connectionTypeName), null, builder, assetGUID == null, effectiveTime, methodName)) != null) {
            if (assetGUID != null) {
                this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, connectionGUID, "connectionGUID", OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), methodName);
            }
            if (connectorTypeGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            if (endpointGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", connectionTypeName, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
        }
        return connectionGUID;
    }

    public void addEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String virtualConnectionGUID, String virtualConnectionGUIDParameterName, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID, String embeddedConnectionGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(virtualConnectionGUID, virtualConnectionGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, embeddedConnectionGUIDParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.POSITION.name, position, methodName);
        if (displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        }
        if (arguments != null && !arguments.isEmpty()) {
            properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARGUMENTS.name, arguments, methodName);
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, virtualConnectionGUID, virtualConnectionGUIDParameterName, OpenMetadataType.VIRTUAL_CONNECTION.typeName, embeddedConnectionGUID, embeddedConnectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String embeddedConnectionGUID, String embeddedConnectionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.VIRTUAL_CONNECTION.typeName, embeddedConnectionGUID, embeddedConnectionGUIDParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public String createConnectionFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String templateGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, templateGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, templateGUIDParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
    }

    public void updateConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, String> securedProperties, Map<String, Object> configurationProperties, String connectorUserId, String clearPassword, String encryptedPassword, String typeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.CONNECTION.typeName, this.serviceName, methodName, this.repositoryHelper);
        ConnectionBuilder builder = new ConnectionBuilder(qualifiedName, displayName, description, additionalProperties, securedProperties, configurationProperties, connectorUserId, clearPassword, encryptedPassword, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addConnectionConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String connectorTypeGUID, String connectorTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeConnectionConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String connectorTypeGUID, String connectorTypeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, connectorTypeGUID, connectorTypeGUIDParameterName, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addConnectionEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeConnectionEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String endpointGUID, String endpointGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeGUID, OpenMetadataType.ENDPOINT.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, effectiveTime, methodName);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, endpointGUID, endpointGUIDParameterName, OpenMetadataType.ENDPOINT.typeName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addConnectionToAsset(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String assetGUID, String assetGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail connectionEntity = this.getEntityFromRepository(userId, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, null, effectiveTime, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        EntityDetail assetEntity = this.repositoryHandler.getEntityByGUID(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (assetEntity != null) {
            this.addAnchorsClassification(userId, connectionEntity, connectionGUIDParameterName, assetGUID, assetEntity.getType().getTypeDefName(), OpenMetadataType.ASSET.typeName, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void removeConnectionToAsset(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionGUIDParameterName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeGUID, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, effectiveTime, methodName);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, connectionGUID, connectionGUIDParameterName, OpenMetadataType.CONNECTION.typeName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeGUID, OpenMetadataType.ASSET.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeConnection(String userId, String externalSourceGUID, String externalSourceName, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, guid, guidParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getConnectionForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail assetEntity = this.getEntityFromRepository(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        List<EntityDetail> connectionEntities = this.getAttachedEntities(userId, assetEntity, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (connectionEntities == null) {
            connectionEntities = this.getAttachedEntities(userId, assetEntity, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        }
        if (connectionEntities == null) {
            return null;
        }
        EntityDetail selectedEntity = this.securityVerifier.selectConnection(userId, assetEntity, connectionEntities, this.repositoryHelper, this.serviceName, methodName);
        return this.getFullConnection(userId, selectedEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private B getFullConnection(String userId, EntityDetail connectionEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connectionEntity != null && connectionEntity.getType() != null) {
            List<Relationship> supplementaryRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)connectionEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            if (supplementaryRelationships != null) {
                for (Relationship relationship : supplementaryRelationships) {
                    if (relationship == null || relationship.getType() == null) continue;
                    EntityProxy entityProxy = null;
                    if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName)) {
                        entityProxy = relationship.getEntityTwoProxy();
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName)) {
                        entityProxy = relationship.getEntityOneProxy();
                    }
                    if (entityProxy == null || entityProxy.getGUID() == null || entityProxy.getType() == null) continue;
                    String entityGUIDParameterName = "embeddedRelationship proxy";
                    EntityDetail supplementaryEntity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "embeddedRelationship proxy", entityProxy.getType().getTypeDefName(), null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                    if (supplementaryEntity == null) continue;
                    supplementaryEntities.add(supplementaryEntity);
                }
            }
            if (supplementaryEntities.isEmpty()) {
                supplementaryEntities = null;
            }
            return this.converter.getNewComplexBean(this.beanClass, connectionEntity, supplementaryEntities, supplementaryRelationships, methodName);
        }
        return null;
    }

    private List<Relationship> getEmbeddedRelationships(String userId, EntitySummary connectionEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        ArrayList<Relationship> supplementaryRelationships = new ArrayList<Relationship>();
        if (connectionEntity != null && connectionEntity.getType() != null) {
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, connectionEntity.getGUID(), connectionEntity.getType().getTypeDefName(), null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                List<Relationship> embeddedConnectionRelationships;
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName)) {
                    supplementaryRelationships.add(relationship);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName)) continue;
                supplementaryRelationships.add(relationship);
                EntityProxy embeddedConnectionEnd = relationship.getEntityTwoProxy();
                if (embeddedConnectionEnd == null || embeddedConnectionEnd.getGUID() == null || embeddedConnectionEnd.getGUID().equals(connectionEntity.getGUID()) || (embeddedConnectionRelationships = this.getEmbeddedRelationships(userId, (EntitySummary)embeddedConnectionEnd, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                supplementaryRelationships.addAll(embeddedConnectionRelationships);
            }
        }
        if (supplementaryRelationships.isEmpty()) {
            return null;
        }
        return supplementaryRelationships;
    }

    private List<B> getFullConnections(String userId, List<EntityDetail> entities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                B bean;
                if (entity == null || (bean = this.getFullConnection(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<B> getConnectionsForAsset(String userId, String assetGUID, String assetGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entities = super.getAttachedEntities(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (entities == null) {
            entities = super.getAttachedEntities(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, OpenMetadataType.CONNECTION.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        }
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findConnections(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, null, null, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getConnectionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, OpenMetadataType.CONNECTION.typeGUID, OpenMetadataType.CONNECTION.typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getFullConnections(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getConnectionByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, OpenMetadataType.CONNECTION.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return this.getFullConnection(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }
}

