/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final String description;
    private String supportedAssetTypeName = null;
    private String supportedDeployedImplementationType = null;
    private String expectedDataFormat = null;
    private String connectorProviderClassName = null;
    private String connectorFrameworkName = null;
    private String connectorInterfaceLanguage = null;
    private List<String> connectorInterfaces = null;
    private String targetTechnologySource = null;
    private String targetTechnologyName = null;
    private List<String> targetTechnologyInterfaces = null;
    private List<String> targetTechnologyVersions = null;
    private List<String> recognizedAdditionalProperties = null;
    private List<String> recognizedConfigurationProperties = null;
    private List<String> recognizedSecuredProperties = null;

    public ConnectorTypeBuilder(String qualifiedName, String displayName, String description, String supportedAssetTypeName, String supportedDeployedImplementationType, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.supportedAssetTypeName = supportedAssetTypeName;
        this.supportedDeployedImplementationType = supportedDeployedImplementationType;
        this.expectedDataFormat = expectedDataFormat;
        this.connectorProviderClassName = connectorProviderClassName;
        this.connectorFrameworkName = connectorFrameworkName;
        this.connectorInterfaceLanguage = connectorInterfaceLanguage;
        this.connectorInterfaces = connectorInterfaces;
        this.targetTechnologySource = targetTechnologySource;
        this.targetTechnologyName = targetTechnologyName;
        this.targetTechnologyInterfaces = targetTechnologyInterfaces;
        this.targetTechnologyVersions = targetTechnologyVersions;
        this.recognizedAdditionalProperties = recognizedAdditionalProperties;
        this.recognizedSecuredProperties = recognizedSecuredProperties;
        this.recognizedConfigurationProperties = recognizedConfigurationProperties;
    }

    ConnectorTypeBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUPPORTED_ASSET_TYPE_NAME.name, this.supportedAssetTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUPPORTED_DEPLOYED_IMPLEMENTATION_TYPE.name, this.supportedDeployedImplementationType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXPECTED_DATA_FORMAT.name, this.expectedDataFormat, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name, this.connectorProviderClassName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONNECTOR_FRAMEWORK_NAME.name, this.connectorFrameworkName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONNECTOR_INTERFACE_LANGUAGE.name, this.connectorInterfaceLanguage, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONNECTOR_INTERFACES.name, this.connectorInterfaces, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_SOURCE.name, this.targetTechnologySource, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_NAME.name, this.targetTechnologyName, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_INTERFACES.name, this.targetTechnologyInterfaces, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_VERSIONS.name, this.targetTechnologyVersions, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES.name, this.recognizedAdditionalProperties, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES.name, this.recognizedSecuredProperties, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES.name, this.recognizedConfigurationProperties, methodName);
        return properties;
    }
}

