/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeHandler<B>
extends ReferenceableHandler<B> {
    public ConnectorTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    private String findConnectorType(String userId, ConnectorType connectorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectorType.getGUID";
        String qualifiedNameParameter = "connectorType.getQualifiedName";
        String displayNameParameter = "connectorType.getDisplayName";
        if (connectorType != null) {
            if (connectorType.getGUID() != null) {
                try {
                    if (this.getEntityFromRepository(userId, connectorType.getGUID(), "connectorType.getGUID", OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, false, false, this.supportedZones, null, methodName) != null) {
                        return connectorType.getGUID();
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    // empty catch block
                }
            }
            String retrievedGUID = null;
            if (connectorType.getQualifiedName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, connectorType.getQualifiedName(), "connectorType.getQualifiedName", OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, null, methodName);
            }
            if (retrievedGUID == null && connectorType.getDisplayName() != null) {
                retrievedGUID = this.getBeanGUIDByUniqueName(userId, connectorType.getDisplayName(), "connectorType.getDisplayName", OpenMetadataProperty.DISPLAY_NAME.name, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, null, methodName);
            }
            return retrievedGUID;
        }
        return null;
    }

    String saveConnectorType(String userId, String externalSourceGUID, String externalSourceName, String parentQualifiedName, ConnectorType connectorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connectorType != null) {
            String existingConnectorType = this.findConnectorType(userId, connectorType, methodName);
            if (existingConnectorType == null) {
                Object connectorTypeQualifiedName = connectorType.getQualifiedName();
                if (connectorTypeQualifiedName == null) {
                    connectorTypeQualifiedName = parentQualifiedName + "-ConnectorType";
                }
                return this.createConnectorType(userId, externalSourceGUID, externalSourceName, null, (String)connectorTypeQualifiedName, connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getSupportedDeployedImplementationType(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), null, null, null, null, new Date(), methodName);
            }
            String connectorTypeGUIDParameterName = "connectorType.getGUID";
            this.updateConnectorType(userId, externalSourceGUID, externalSourceName, existingConnectorType, "connectorType.getGUID", connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getSupportedDeployedImplementationType(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), null, null, null, null, true, false, false, new Date(), methodName);
            return existingConnectorType;
        }
        return null;
    }

    public String createConnectorType(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String supportedDeployedImplementationType, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "connectorType.qualifiedName";
        String anchorGUIDParameter = "anchorGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "connectorType.qualifiedName", methodName);
        String typeName = OpenMetadataType.CONNECTOR_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.CONNECTOR_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, supportedAssetTypeName, supportedDeployedImplementationType, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public String createConnectorTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.CONNECTOR_TYPE.typeName, OpenMetadataType.CONNECTOR_TYPE.typeName, null, methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
    }

    public String getConnectorTypeForAsset(String userId, String supportedAssetTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "supportedAssetTypeName";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.SUPPORTED_ASSET_TYPE_NAME.name);
        List<EntityDetail> connectorTypes = this.getEntitiesByValue(userId, supportedAssetTypeName, parameterName, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        String otherConnectorTypeGUID = null;
        if (connectorTypes != null) {
            for (EntityDetail connectorType : connectorTypes) {
                if (connectorType == null) continue;
                String framework = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_FRAMEWORK_NAME.name, connectorType.getProperties(), methodName);
                String language = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_INTERFACE_LANGUAGE.name, connectorType.getProperties(), methodName);
                if (framework != null && !"Open Connector Framework (OCF)".equals(framework)) continue;
                if (language == null || "Java".equals(language)) {
                    return connectorType.getGUID();
                }
                otherConnectorTypeGUID = connectorType.getGUID();
            }
        }
        return otherConnectorTypeGUID;
    }

    public String getConnectorTypeForConnection(String userId, String externalSourceGUID, String externalSourceName, String anchorGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String supportedDeployedImplementationType, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String connectorProviderClassNameParameterName = "connectorProviderClassName";
        String connectorTypeGUID = this.getBeanGUIDByUniqueName(userId, connectorProviderClassName, "connectorProviderClassName", OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (connectorTypeGUID == null) {
            connectorTypeGUID = this.getBeanGUIDByUniqueName(userId, qualifiedName, "qualifiedName", OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        }
        if (connectorTypeGUID == null) {
            connectorTypeGUID = this.createConnectorType(userId, externalSourceGUID, externalSourceName, anchorGUID, qualifiedName, displayName, description, supportedAssetTypeName, supportedDeployedImplementationType, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, null, null, null, null, effectiveTime, methodName);
        }
        return connectorTypeGUID;
    }

    public void updateConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String connectorTypeGUIDParameterName, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String supportedDeployedImplementationType, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "qualifiedName";
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.CONNECTOR_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.CONNECTOR_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ConnectorTypeBuilder builder = new ConnectorTypeBuilder(qualifiedName, displayName, description, supportedAssetTypeName, supportedDeployedImplementationType, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedAdditionalProperties, recognizedSecuredProperties, recognizedConfigurationProperties, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, connectorTypeGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeConnectorType(String userId, String externalSourceGUID, String externalSourceName, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, guid, guidParameterName, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findConnectorTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getConnectorTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.CONNECTOR_TYPE.typeGUID, OpenMetadataType.CONNECTOR_TYPE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getConnectorTypeByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.CONNECTOR_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

