/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseColumnProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseQueryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseColumnConverter<B>
extends OMFConverter<B> {
    public DatabaseColumnConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DatabaseColumnElement) {
                DatabaseColumnElement bean = (DatabaseColumnElement)returnBean;
                DatabaseColumnProperties properties = new DatabaseColumnProperties();
                if (schemaAttributeEntity != null) {
                    InstanceProperties classificationProperties;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    super.setUpSchemaAttribute(schemaAttributeEntity, null, (SchemaAttributeProperties)properties);
                    properties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    if (schemaType instanceof SchemaTypeElement) {
                        SchemaTypeElement schemaTypeElement = (SchemaTypeElement)schemaType;
                        super.addSchemaTypeToAttribute(schemaTypeElement, (SchemaAttributeProperties)properties);
                        properties.setFormula(schemaTypeElement.getFormula());
                        if (schemaTypeElement.getQueries() != null && !schemaTypeElement.getQueries().isEmpty()) {
                            ArrayList<DatabaseQueryProperties> databaseQueryPropertiesList = new ArrayList<DatabaseQueryProperties>();
                            for (DerivedSchemaTypeQueryTargetProperties derivedSchemaTypeQueryTargetProperties : schemaTypeElement.getQueries()) {
                                if (derivedSchemaTypeQueryTargetProperties == null) continue;
                                DatabaseQueryProperties databaseQueryProperties = new DatabaseQueryProperties();
                                databaseQueryProperties.setQuery(derivedSchemaTypeQueryTargetProperties.getQuery());
                                databaseQueryProperties.setQueryId(derivedSchemaTypeQueryTargetProperties.getQueryId());
                                databaseQueryProperties.setQueryTargetGUID(derivedSchemaTypeQueryTargetProperties.getQueryTargetGUID());
                                databaseQueryPropertiesList.add(databaseQueryProperties);
                            }
                            properties.setQueries(databaseQueryPropertiesList);
                        }
                    }
                    if ((classificationProperties = super.getClassificationProperties(OpenMetadataType.PRIMARY_KEY_CLASSIFICATION.typeName, schemaAttributeEntity)) != null) {
                        DatabasePrimaryKeyProperties primaryKeyProperties = new DatabasePrimaryKeyProperties();
                        primaryKeyProperties.setName(this.removeName(classificationProperties));
                        primaryKeyProperties.setKeyPattern(this.removeKeyPattern(classificationProperties));
                        primaryKeyProperties.setExtendedProperties(this.getRemainingExtendedProperties(classificationProperties));
                        bean.setPrimaryKeyProperties(primaryKeyProperties);
                    }
                    if (schemaAttributeRelationships != null) {
                        for (Relationship relationship : schemaAttributeRelationships) {
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeName) || !schemaAttributeEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) continue;
                            DatabaseForeignKeyProperties databaseForeignKeyProperties = new DatabaseForeignKeyProperties();
                            InstanceProperties relationshipProperties = relationship.getProperties();
                            databaseForeignKeyProperties.setEffectiveFrom(relationshipProperties.getEffectiveFromTime());
                            databaseForeignKeyProperties.setEffectiveTo(relationshipProperties.getEffectiveToTime());
                            databaseForeignKeyProperties.setName(this.removeName(relationshipProperties));
                            databaseForeignKeyProperties.setDescription(this.removeDescription(relationshipProperties));
                            databaseForeignKeyProperties.setConfidence(this.removeConfidence(relationshipProperties));
                            databaseForeignKeyProperties.setSteward(this.removeSteward(relationshipProperties));
                            databaseForeignKeyProperties.setSource(this.removeSource(relationshipProperties));
                            databaseForeignKeyProperties.setExtendedProperties(this.getRemainingExtendedProperties(relationshipProperties));
                            bean.setForeignKeyProperties(databaseForeignKeyProperties);
                            bean.setReferencedColumnGUID(relationship.getEntityOneProxy().getGUID());
                            bean.setReferencedColumnQualifiedName(this.getQualifiedName(relationship.getEntityOneProxy().getUniqueProperties()));
                        }
                    }
                    bean.setDatabaseColumnProperties(properties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

