/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.databases.DatabaseViewProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseViewConverter<B>
extends OMFConverter<B> {
    public DatabaseViewConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof DatabaseViewElement) {
                DatabaseViewElement bean = (DatabaseViewElement)returnBean;
                DatabaseViewProperties databaseViewProperties = new DatabaseViewProperties();
                if (schemaAttributeEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    databaseViewProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseViewProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseViewProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    databaseViewProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseViewProperties.setAliases(this.removeAliases(instanceProperties));
                    databaseViewProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseViewProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setDatabaseViewProperties(databaseViewProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

