/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;

public class DisplayDataContainerHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private static final String qualifiedNameParameterName = "qualifiedName";
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE> dataContainerHandler;
    protected final RepositoryErrorHandler errorHandler;

    public DisplayDataContainerHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> dataContainerConverter, Class<SCHEMA_ATTRIBUTE> dataContainerClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(dataContainerConverter, dataContainerClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataContainerHandler = new SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>(dataContainerConverter, dataContainerClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public String createDataContainer(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, null, OpenMetadataType.ROOT_SCHEMA_TYPE.typeGUID, OpenMetadataType.ROOT_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String attributeTypeName = OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName;
            String attributeTypeId = OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID;
            if (typeName != null) {
                attributeTypeName = typeName;
                attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, this.serviceName, methodName, this.repositoryHelper);
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, null, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, parentGUID, "parentGUID", false, false, effectiveTime, this.supportedZones, schemaAttributeBuilder, methodName);
            SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":containerType", OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeGUID, OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
            String dataContainerGUID = this.dataContainerHandler.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (dataContainerGUID != null) {
                this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            return dataContainerGUID;
        }
        return null;
    }

    public String createDataContainerFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String parentGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "parentGUID";
        String parentElementGUIDParameterName = "parentGUID";
        String templateParameterName = "templateGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, null, OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeGUID, OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, parentGUID, "parentGUID", false, false, effectiveTime, this.supportedZones, builder, methodName);
            String dataContainerGUID = this.dataContainerHandler.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, qualifiedName, qualifiedNameParameterName, builder, this.supportedZones, true, false, null, methodName);
            if (dataContainerGUID != null) {
                String displaySchemaTypeGUIDParameterName = "displaySchemaTypeGUID";
                String dataContainerGUIDParameterName = "dataContainerGUID";
                this.dataContainerHandler.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, databaseSchemaTypeGUID, "displaySchemaTypeGUID", dataContainerGUID, "dataContainerGUID", OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, null, methodName);
                return dataContainerGUID;
            }
        }
        return null;
    }

    public void updateDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "dataContainerGUID";
        String qualifiedNameParameterName = qualifiedNameParameterName;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String attributeTypeName = OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName;
        String attributeTypeId = OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID;
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IS_DEPRECATED.name, isDeprecated, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, methodName);
            }
            catch (InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        if (effectiveFrom != null || effectiveTo != null) {
            if (properties == null) {
                properties = new InstanceProperties();
            }
            properties.setEffectiveFromTime(effectiveFrom);
            properties.setEffectiveToTime(effectiveTo);
        }
        this.dataContainerHandler.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, "dataContainerGUID", attributeTypeId, attributeTypeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, isMergeUpdate, effectiveTime, methodName);
        this.dataContainerHandler.setVendorProperties(userId, dataContainerGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDataContainer(String userId, String externalSourceGUID, String externalSourceName, String dataContainerGUID, String dataContainerGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        this.dataContainerHandler.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, dataContainerGUID, dataContainerGUIDParameterName, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findDataContainers(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.dataContainerHandler.findSchemaAttributes(userId, searchString, "searchString", OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getContainersForParent(String userId, String externalSourceGUID, String externalSourceName, String parentGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentGUID";
        String databaseSchemaTypeGUID = this.dataContainerHandler.getAssetSchemaTypeGUID(userId, externalSourceGUID, externalSourceName, parentGUID, "parentGUID", OpenMetadataType.ASSET.typeName, null, OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeGUID, OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String displaySchemaTypeGUIDParameterName = "displaySchemaTypeGUID";
            return this.dataContainerHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "displaySchemaTypeGUID", null, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getDataContainersByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataContainerHandler.getSchemaAttributesByName(userId, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeGUID, OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, name, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public SCHEMA_ATTRIBUTE getDataContainerByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.dataContainerHandler.getSchemaAttribute(userId, guid, "guid", OpenMetadataType.DISPLAY_DATA_CONTAINER.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

