/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class EngineActionBuilder
extends ReferenceableBuilder {
    private int domainIdentifier = 0;
    private String displayName = null;
    private String description = null;
    private String governanceEngineGUID = null;
    private String governanceEngineName = null;
    private String governanceActionTypeGUID = null;
    private String governanceActionTypeName = null;
    private String processName = null;
    private String governanceActionProcessStepGUID = null;
    private String governanceActionProcessStepName = null;
    private String requesterUserId = null;
    private String requestType = null;
    private Map<String, String> requestParameters = null;
    private List<String> mandatoryGuards = null;
    private List<String> receivedGuards = null;
    private int actionStatus = 0;
    private Date requestedStartDate = null;
    private Date startDate = null;
    private String processingEngineUserId = null;
    private Date completionDate = null;
    private List<String> completionGuards = null;

    EngineActionBuilder(String qualifiedName, int domainIdentifier, String displayName, String description, String governanceEngineGUID, String governanceEngineName, String governanceActionTypeGUID, String governanceActionTypeName, String processName, String processStepGUID, String processStepName, String requesterUserId, String requestType, Map<String, String> requestParameters, List<String> mandatoryGuards, List<String> receivedGuards, int actionStatus, Date requestedStartDate, String processingEngineUserId, Date completionDate, List<String> completionGuards, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, repositoryHelper, serviceName, serverName);
        this.domainIdentifier = domainIdentifier;
        this.displayName = displayName;
        this.description = description;
        this.governanceEngineGUID = governanceEngineGUID;
        this.governanceEngineName = governanceEngineName;
        this.governanceActionTypeGUID = governanceActionTypeGUID;
        this.governanceActionTypeName = governanceActionTypeName;
        this.processName = processName;
        this.governanceActionProcessStepGUID = processStepGUID;
        this.governanceActionProcessStepName = processStepName;
        this.requesterUserId = requesterUserId;
        this.requestType = requestType;
        this.requestParameters = requestParameters;
        this.mandatoryGuards = mandatoryGuards;
        this.receivedGuards = receivedGuards;
        this.actionStatus = actionStatus;
        this.requestedStartDate = requestedStartDate;
        this.processingEngineUserId = processingEngineUserId;
        this.completionDate = completionDate;
        this.completionGuards = completionGuards;
    }

    EngineActionBuilder(int actionStatus, String processingEngineUserId, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(null, null, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, repositoryHelper, serviceName, serverName);
        this.actionStatus = actionStatus;
        this.processingEngineUserId = processingEngineUserId;
    }

    EngineActionBuilder(int actionStatus, Date startDate, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(null, null, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, repositoryHelper, serviceName, serverName);
        this.actionStatus = actionStatus;
        this.startDate = startDate;
    }

    EngineActionBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, this.domainIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXECUTOR_ENGINE_GUID.name, this.governanceEngineGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXECUTOR_ENGINE_NAME.name, this.governanceEngineName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_GUID.name, this.governanceActionTypeGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_NAME.name, this.governanceActionTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESS_NAME.name, this.processName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESS_STEP_GUID.name, this.governanceActionProcessStepGUID, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESS_STEP_NAME.name, this.governanceActionProcessStepName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REQUESTER_USER_ID.name, this.requesterUserId, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REQUEST_TYPE.name, this.requestType, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REQUEST_PARAMETERS.name, this.requestParameters, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MANDATORY_GUARDS.name, this.mandatoryGuards, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RECEIVED_GUARDS.name, this.receivedGuards, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), this.actionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.ACTION_STATUS.name);
        }
        if (this.requestedStartDate == null) {
            this.requestedStartDate = new Date();
        }
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.REQUESTED_START_DATE.name, this.requestedStartDate, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.START_DATE.name, this.startDate, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, this.processingEngineUserId, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_DATE.name, this.completionDate, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_GUARDS.name, this.completionGuards, methodName);
        return properties;
    }

    InstanceProperties getClaimInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), this.actionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.ACTION_STATUS.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, this.processingEngineUserId, methodName);
        return properties;
    }

    InstanceProperties getCancelInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), this.actionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.ACTION_STATUS.name);
        }
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_DATE.name, new Date(), methodName);
        return properties;
    }

    InstanceProperties getCompletionInstanceProperties(InstanceProperties properties, int actionStatus, Date completionDate, List<String> completionGuards, String completionMessage, String methodName) throws InvalidParameterException {
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), actionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.ACTION_STATUS.name);
        }
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_DATE.name, completionDate, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_GUARDS.name, completionGuards, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.COMPLETION_MESSAGE.name, completionMessage, methodName);
        return properties;
    }
}

