/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ProcessBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessContainmentType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class EngineActionHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public EngineActionHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> serviceSupportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, serviceSupportedZones, defaultZones, publishZones, auditLog);
    }

    public String initiateGovernanceActionType(String userId, String governanceActionTypeQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Map<String, String> requestParameters, Date startTime, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "governanceActionTypeQualifiedName";
        Date effectiveTime = new Date();
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        EntityDetail governanceActionTypeEntity = this.getEntityByValue(userId, governanceActionTypeQualifiedName, "governanceActionTypeQualifiedName", OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, propertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (governanceActionTypeEntity != null) {
            return this.prepareEngineActionFromType(userId, governanceActionTypeEntity, startTime, requestParameters, requestSourceGUIDs, actionTargets, governanceActionTypeQualifiedName, originatorServiceName, originatorEngineName, serviceSupportedZones, methodName);
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_GOVERNANCE_ACTION_TYPE.getMessageDefinition(governanceActionTypeQualifiedName), this.getClass().getName(), methodName, "governanceActionTypeQualifiedName");
    }

    private Map<String, String> getExecutorRequestParameters(Relationship governanceActionExecutorRelationship, Map<String, String> suppliedRequestParameters) {
        List requestParameterFilter;
        Map requestParameterMap;
        String methodName = "getExecutorRequestParameters";
        HashMap<String, String> executorsRequestParameters = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, governanceActionExecutorRelationship.getProperties(), "getExecutorRequestParameters");
        if (executorsRequestParameters == null) {
            executorsRequestParameters = new HashMap<String, String>();
        }
        if (suppliedRequestParameters != null) {
            executorsRequestParameters.putAll(suppliedRequestParameters);
        }
        if ((requestParameterMap = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETER_MAP.name, governanceActionExecutorRelationship.getProperties(), "getExecutorRequestParameters")) != null) {
            HashMap<String, String> mappedRequestParameters = new HashMap<String, String>();
            for (String requestParameterName : executorsRequestParameters.keySet()) {
                if (requestParameterName == null) continue;
                if (requestParameterMap.containsKey(requestParameterName)) {
                    String newRequestParameterName = (String)requestParameterMap.get(requestParameterName);
                    mappedRequestParameters.put(newRequestParameterName, (String)executorsRequestParameters.get(requestParameterName));
                    continue;
                }
                mappedRequestParameters.put(requestParameterName, (String)executorsRequestParameters.get(requestParameterName));
            }
            executorsRequestParameters = mappedRequestParameters;
        }
        if ((requestParameterFilter = this.repositoryHelper.getStringArrayProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETER_FILTER.name, governanceActionExecutorRelationship.getProperties(), "getExecutorRequestParameters")) != null) {
            HashMap<String, String> filteredRequestParameters = new HashMap<String, String>();
            for (String requestParameterName : executorsRequestParameters.keySet()) {
                if (requestParameterName == null || requestParameterFilter.contains(requestParameterName)) continue;
                filteredRequestParameters.put(requestParameterName, (String)executorsRequestParameters.get(requestParameterName));
            }
            executorsRequestParameters = filteredRequestParameters;
        }
        if (executorsRequestParameters.isEmpty()) {
            executorsRequestParameters = null;
        }
        return executorsRequestParameters;
    }

    private List<NewActionTarget> getExecutorTargetsForAction(Relationship governanceActionExecutorRelationship, List<NewActionTarget> suppliedTargetsForAction) {
        String methodName = "getExecutorTargetsForAction";
        if (suppliedTargetsForAction != null && !suppliedTargetsForAction.isEmpty()) {
            List actionTargetFilter;
            HashMap<String, NewActionTarget> executorsActionTargets = new HashMap<String, NewActionTarget>();
            for (NewActionTarget newActionTarget : suppliedTargetsForAction) {
                if (newActionTarget == null || newActionTarget.getActionTargetName() == null) continue;
                executorsActionTargets.put(newActionTarget.getActionTargetName(), newActionTarget);
            }
            Map actionTargetMap = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_MAP.name, governanceActionExecutorRelationship.getProperties(), "getExecutorTargetsForAction");
            if (actionTargetMap != null) {
                HashMap<String, NewActionTarget> mappedTargetsForAction = new HashMap<String, NewActionTarget>();
                for (String actionTargetName : executorsActionTargets.keySet()) {
                    if (actionTargetName == null) continue;
                    if (actionTargetMap.containsKey(actionTargetName)) {
                        String newTargetForActionName = (String)actionTargetMap.get(actionTargetName);
                        mappedTargetsForAction.put(newTargetForActionName, (NewActionTarget)executorsActionTargets.get(actionTargetName));
                        continue;
                    }
                    mappedTargetsForAction.put(actionTargetName, (NewActionTarget)executorsActionTargets.get(actionTargetName));
                }
                executorsActionTargets = mappedTargetsForAction;
            }
            if ((actionTargetFilter = this.repositoryHelper.getStringArrayProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_FILTER.name, governanceActionExecutorRelationship.getProperties(), "getExecutorTargetsForAction")) != null) {
                HashMap<String, NewActionTarget> filteredTargetsForAction = new HashMap<String, NewActionTarget>();
                for (String actionTargetName : executorsActionTargets.keySet()) {
                    if (actionTargetName == null || actionTargetFilter.contains(actionTargetName)) continue;
                    filteredTargetsForAction.put(actionTargetName, (NewActionTarget)executorsActionTargets.get(actionTargetName));
                }
                executorsActionTargets = filteredTargetsForAction;
            }
            if (!executorsActionTargets.isEmpty()) {
                return new ArrayList<NewActionTarget>(executorsActionTargets.values());
            }
        }
        return null;
    }

    private String prepareEngineActionFromType(String userId, EntityDetail governanceActionTypeEntity, Date suppliedStartTime, Map<String, String> initialRequestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> callersActionTargets, String requestSourceName, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Relationship governanceActionExecutorRelationship;
        String guidParameterName = "governanceActionTypeEntity.getGUID()";
        String governanceActionTypeName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceActionTypeEntity.getProperties(), methodName);
        int domainIdentifier = this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, governanceActionTypeEntity.getProperties(), methodName);
        String displayName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, governanceActionTypeEntity.getProperties(), methodName);
        String description = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, governanceActionTypeEntity.getProperties(), methodName);
        int waitTime = this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.WAIT_TIME.name, governanceActionTypeEntity.getProperties(), methodName);
        Date requestedStartDate = suppliedStartTime;
        if (suppliedStartTime == null) {
            long startTime = new Date().getTime() + (long)waitTime * 1000L;
            requestedStartDate = new Date(startTime);
        }
        int startFrom = 0;
        List targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeEntity, OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
        ArrayList<NewActionTarget> newTargetsForAction = new ArrayList<NewActionTarget>();
        if (callersActionTargets != null) {
            newTargetsForAction.addAll(callersActionTargets);
        }
        while (targetsForAction != null) {
            for (Relationship targetForAction : targetsForAction) {
                if (targetForAction == null) continue;
                NewActionTarget newActionTarget = new NewActionTarget();
                newActionTarget.setActionTargetName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_NAME.name, targetForAction.getProperties(), methodName));
                newActionTarget.setActionTargetGUID(targetForAction.getEntityTwoProxy().getGUID());
                newTargetsForAction.add(newActionTarget);
            }
            targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionTypeEntity, OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
        }
        if (newTargetsForAction.isEmpty()) {
            newTargetsForAction = null;
        }
        if ((governanceActionExecutorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionTypeEntity.getGUID(), OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, true, OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, null, methodName)) == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXECUTOR.getMessageDefinition(governanceActionTypeEntity.getGUID(), OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeName), this.getClass().getName(), methodName, "governanceActionTypeEntity.getGUID()");
        }
        String governanceEngineName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceActionExecutorRelationship.getEntityTwoProxy().getUniqueProperties(), methodName);
        String requestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, governanceActionExecutorRelationship.getProperties(), methodName);
        Map<String, String> executorsRequestParameters = this.getExecutorRequestParameters(governanceActionExecutorRelationship, initialRequestParameters);
        String engineActionGUID = this.createEngineAction(userId, governanceActionTypeName + "::" + String.valueOf(UUID.randomUUID()), domainIdentifier, displayName, description, requestSourceGUIDs, this.getExecutorTargetsForAction(governanceActionExecutorRelationship, newTargetsForAction), null, null, requestedStartDate, governanceEngineName, userId, requestType, executorsRequestParameters, governanceActionTypeEntity.getGUID(), governanceActionTypeName, null, null, null, null, requestSourceName, originatorServiceName, originatorEngineName, serviceSupportedZones, methodName);
        if (engineActionGUID != null) {
            this.runEngineActionIfReady(userId, engineActionGUID, governanceActionTypeName + "::" + String.valueOf(UUID.randomUUID()), null, requestedStartDate, governanceEngineName, requestType, executorsRequestParameters, governanceActionTypeName, requestSourceName, serviceSupportedZones, methodName);
            return engineActionGUID;
        }
        return null;
    }

    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> callersActionTargets, Map<String, String> callersRequestParameters, Date requestedStartDate, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "processQualifiedName";
        String governanceActionProcessGUIDParameterName = "governanceActionProcessEntity.getGUID()";
        String governanceActionProcessInstanceGUIDParameterName = "governanceActionProcessInstanceGUID";
        String governanceActionProcessStepGUIDParameterName = "governanceActionProcessFlowRelationship.getEntityTwoProxy().getGUID()";
        String engineActionGUIDParameterName = "engineActionGUID";
        Date effectiveTime = new Date();
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        EntityDetail governanceActionProcessEntity = this.getEntityByValue(userId, processQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, propertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (governanceActionProcessEntity != null) {
            Relationship governanceActionFlowRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionProcessEntity.getGUID(), OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, true, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_FLOW_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_FLOW_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, effectiveTime, methodName);
            if (governanceActionFlowRelationship != null) {
                String governanceActionProcessStepGUID = governanceActionFlowRelationship.getEntityTwoProxy().getGUID();
                String guard = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, governanceActionFlowRelationship.getProperties(), methodName);
                Map additionalRequestParameters = this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, governanceActionFlowRelationship.getProperties(), methodName);
                HashMap<String, String> combinedRequestParameters = new HashMap<String, String>();
                if (additionalRequestParameters != null) {
                    combinedRequestParameters.putAll(additionalRequestParameters);
                }
                if (callersRequestParameters != null) {
                    combinedRequestParameters.putAll(callersRequestParameters);
                }
                if (combinedRequestParameters.isEmpty()) {
                    combinedRequestParameters = null;
                }
                ArrayList<NewActionTarget> newTargetsForAction = new ArrayList<NewActionTarget>();
                int startFrom = 0;
                if (callersActionTargets != null) {
                    newTargetsForAction.addAll(callersActionTargets);
                }
                List targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionProcessEntity, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.TARGET_FOR_ACTION_PROCESS_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_PROCESS_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
                while (targetsForAction != null) {
                    for (Relationship targetForAction : targetsForAction) {
                        if (targetForAction == null) continue;
                        NewActionTarget newActionTarget = new NewActionTarget();
                        newActionTarget.setActionTargetName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_NAME.name, targetForAction.getProperties(), methodName));
                        newActionTarget.setActionTargetGUID(targetForAction.getEntityTwoProxy().getGUID());
                        newTargetsForAction.add(newActionTarget);
                    }
                    targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionProcessEntity, OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.TARGET_FOR_ACTION_PROCESS_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_PROCESS_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
                }
                if (newTargetsForAction.isEmpty()) {
                    newTargetsForAction = null;
                }
                Date processInstanceStartTime = new Date();
                String processInstanceQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceActionProcessEntity.getProperties(), methodName) + "@" + processInstanceStartTime.getTime() + "::" + String.valueOf(UUID.randomUUID());
                String processInstanceName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.NAME.name, governanceActionProcessEntity.getProperties(), methodName) + "@" + String.valueOf(processInstanceStartTime);
                ProcessBuilder processBuilder = new ProcessBuilder(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeName, processInstanceQualifiedName, processInstanceName, null, null, null, processInstanceStartTime, null, this.repositoryHelper, this.serviceName, this.serverName);
                processBuilder.setAnchors(userId, governanceActionProcessEntity.getGUID(), OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName, OpenMetadataType.ASSET.typeName, null, methodName);
                String processInstanceGUID = this.createBeanInRepository(userId, null, null, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeName, OpenMetadataType.ASSET.typeName, null, processBuilder, false, new Date(), methodName);
                this.uncheckedLinkElementToElement(userId, null, null, governanceActionProcessEntity.getGUID(), "governanceActionProcessEntity.getGUID()", processInstanceGUID, "governanceActionProcessInstanceGUID", OpenMetadataType.PROCESS_HIERARCHY_RELATIONSHIP.typeGUID, processBuilder.getProcessHierarchyProperties(ProcessContainmentType.OWNED.getOrdinal()), methodName);
                String engineActionGUID = this.prepareEngineActionFromProcessStep(userId, processInstanceGUID, governanceActionProcessStepGUID, "governanceActionProcessFlowRelationship.getEntityTwoProxy().getGUID()", guard, false, requestedStartDate, null, userId, combinedRequestParameters, requestSourceGUIDs, newTargetsForAction, processInstanceQualifiedName, processQualifiedName, originatorServiceName, originatorEngineName, serviceSupportedZones, methodName);
                if (engineActionGUID != null) {
                    this.uncheckedLinkElementToElement(userId, null, null, processInstanceGUID, "governanceActionProcessInstanceGUID", engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE.typeGUID, this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.REQUEST_SOURCE_NAME.name, processInstanceName, methodName), methodName);
                }
                return processInstanceGUID;
            }
            throw new InvalidParameterException(GenericHandlersErrorCode.NO_PROCESS_IMPLEMENTATION.getMessageDefinition(processQualifiedName), this.getClass().getName(), methodName, "processQualifiedName");
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_PROCESS.getMessageDefinition(processQualifiedName), this.getClass().getName(), methodName, "processQualifiedName");
    }

    private String prepareEngineActionFromProcessStep(String userId, String anchorGUID, String governanceActionProcessStepGUID, String governanceActionProcessStepGUIDParameterName, String guard, boolean mandatoryGuard, Date suppliedStartTime, String previousEngineActionGUID, String requesterUserId, Map<String, String> initialRequestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> callersActionTargets, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        NewActionTarget newActionTarget;
        List targetsForAction;
        Relationship governanceActionProcessStepExecutorRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, governanceActionProcessStepGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, true, OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, null, methodName);
        if (governanceActionProcessStepExecutorRelationship == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXECUTOR.getMessageDefinition(governanceActionProcessStepGUID, OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeName), this.getClass().getName(), methodName, governanceActionProcessStepGUIDParameterName);
        }
        EntityDetail governanceActionProcessStepEntity = this.getEntityFromRepository(userId, governanceActionProcessStepGUID, governanceActionProcessStepGUIDParameterName, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, null, null, false, false, serviceSupportedZones, null, methodName);
        boolean ignoreMultipleTriggers = this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IGNORE_MULTIPLE_TRIGGERS.name, governanceActionProcessStepEntity.getProperties(), methodName);
        String governanceActionProcessStepName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceActionProcessStepEntity.getProperties(), methodName);
        int domainIdentifier = this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, governanceActionProcessStepEntity.getProperties(), methodName);
        String displayName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, governanceActionProcessStepEntity.getProperties(), methodName);
        String description = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, governanceActionProcessStepEntity.getProperties(), methodName);
        int waitTime = this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.WAIT_TIME.name, governanceActionProcessStepEntity.getProperties(), methodName);
        Date requestedStartDate = suppliedStartTime;
        if (suppliedStartTime == null) {
            long startTime = new Date().getTime() + (long)waitTime * 1000L;
            requestedStartDate = new Date(startTime);
        }
        ArrayList<String> receivedGuards = null;
        if (guard != null) {
            receivedGuards = new ArrayList<String>();
            receivedGuards.add(guard);
        }
        String governanceEngineName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, governanceActionProcessStepExecutorRelationship.getEntityTwoProxy().getUniqueProperties(), methodName);
        String requestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, governanceActionProcessStepExecutorRelationship.getProperties(), methodName);
        Map<String, String> requestParameters = this.getExecutorRequestParameters(governanceActionProcessStepExecutorRelationship, initialRequestParameters);
        ArrayList<NewActionTarget> newTargetsForAction = new ArrayList<NewActionTarget>();
        int startFrom = 0;
        if (callersActionTargets != null) {
            newTargetsForAction.addAll(callersActionTargets);
        }
        if (previousEngineActionGUID != null) {
            targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, previousEngineActionGUID, OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
            while (targetsForAction != null) {
                for (Relationship targetForAction : targetsForAction) {
                    if (targetForAction == null) continue;
                    newActionTarget = new NewActionTarget();
                    newActionTarget.setActionTargetName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_NAME.name, targetForAction.getProperties(), methodName));
                    newActionTarget.setActionTargetGUID(targetForAction.getEntityTwoProxy().getGUID());
                    newTargetsForAction.add(newActionTarget);
                }
                targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, previousEngineActionGUID, OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
            }
        }
        startFrom = 0;
        targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionProcessStepEntity, OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
        while (targetsForAction != null) {
            for (Relationship targetForAction : targetsForAction) {
                if (targetForAction == null) continue;
                newActionTarget = new NewActionTarget();
                newActionTarget.setActionTargetName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_NAME.name, targetForAction.getProperties(), methodName));
                newActionTarget.setActionTargetGUID(targetForAction.getEntityTwoProxy().getGUID());
                newTargetsForAction.add(newActionTarget);
            }
            targetsForAction = this.repositoryHandler.getRelationshipsByType(userId, governanceActionProcessStepEntity, OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize(), new Date(), methodName);
        }
        if (newTargetsForAction.isEmpty()) {
            newTargetsForAction = null;
        }
        List<String> mandatoryGuards = this.getMandatoryGuards(userId, governanceActionProcessStepGUID);
        String engineActionGUID = this.getEngineActionForProcessStep(userId, governanceActionProcessStepName + "::" + String.valueOf(UUID.randomUUID()), domainIdentifier, displayName, description, requestSourceGUIDs, newTargetsForAction, mandatoryGuards, ignoreMultipleTriggers, receivedGuards, requestedStartDate, governanceEngineName, requesterUserId, requestType, requestParameters, governanceActionProcessStepGUID, governanceActionProcessStepName, anchorGUID, processName, requestSourceName, originatorServiceName, originatorEngineName, serviceSupportedZones, methodName);
        if (engineActionGUID != null && previousEngineActionGUID != null) {
            InstanceProperties nextEngineActionProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.GUARD.name, guard, methodName);
            nextEngineActionProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, nextEngineActionProperties, OpenMetadataProperty.MANDATORY_GUARD.name, mandatoryGuard, methodName);
            this.repositoryHandler.createRelationship(userId, OpenMetadataType.NEXT_ENGINE_ACTION.typeGUID, null, null, previousEngineActionGUID, engineActionGUID, nextEngineActionProperties, methodName);
        }
        if (engineActionGUID != null) {
            this.runEngineActionIfReady(userId, engineActionGUID, governanceActionProcessStepName + "::" + String.valueOf(UUID.randomUUID()), mandatoryGuards, requestedStartDate, governanceEngineName, requestType, requestParameters, governanceActionProcessStepName, requestSourceName, serviceSupportedZones, methodName);
            return engineActionGUID;
        }
        return null;
    }

    private void runEngineActionIfReady(String userId, String engineActionGUID, String qualifiedName, List<String> mandatoryGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionProcessStepName, String requestSourceName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List previousResults = this.repositoryHandler.getRelationshipsByType(userId, engineActionGUID, OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataType.NEXT_ENGINE_ACTION.typeGUID, OpenMetadataType.NEXT_ENGINE_ACTION.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 0, null, methodName);
        ArrayList<String> receivedGuards = new ArrayList<String>();
        if (previousResults != null) {
            for (Relationship previousResult : previousResults) {
                if (previousResult == null || engineActionGUID.equals(previousResult.getEntityOneProxy().getGUID())) continue;
                String guard = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, previousResult.getProperties(), methodName);
                receivedGuards.add(guard);
            }
        }
        if (mandatoryGuards == null || mandatoryGuards.isEmpty() || new HashSet(receivedGuards).containsAll(mandatoryGuards)) {
            this.approveEngineAction(userId, engineActionGUID, qualifiedName, mandatoryGuards, receivedGuards, startTime, governanceEngineName, requestType, requestParameters, governanceActionProcessStepName, requestSourceName, serviceSupportedZones, methodName);
        }
    }

    public void approveEngineAction(String userId, String engineActionGUID, String qualifiedName, List<String> mandatoryGuards, List<String> receivedGuards, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String governanceActionProcessStepName, String requestSourceName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        String receivedGuardsString = "<null>";
        String mandatoryGuardsString = "<null>";
        String startTimeString = "<now>";
        String requestParameterNames = "<null>";
        if (receivedGuards != null) {
            receivedGuardsString = receivedGuards.toString();
        }
        if (mandatoryGuards != null) {
            mandatoryGuardsString = mandatoryGuards.toString();
        }
        if (startTime != null) {
            startTimeString = startTime.toString();
        }
        if (requestParameters != null) {
            requestParameterNames = requestParameters.keySet().toString();
        }
        if (governanceActionProcessStepName != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.INITIATE_ENGINE_ACTION_FROM_PROCESS_STEP.getMessageDefinition(qualifiedName, governanceActionProcessStepName, requestType, governanceEngineName, receivedGuardsString, mandatoryGuardsString, requestParameterNames, startTimeString, requestSourceName));
        } else {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.INITIATE_ENGINE_ACTION.getMessageDefinition(qualifiedName, requestType, governanceEngineName, receivedGuardsString, mandatoryGuardsString, requestParameterNames, startTimeString, requestSourceName));
        }
        this.updateEngineActionStatus(userId, engineActionGUID, EngineActionStatus.APPROVED.getOrdinal(), serviceSupportedZones, null, methodName);
    }

    public String createEngineAction(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> mandatoryGuards, List<String> receivedGuards, Date startTime, String governanceEngineName, String requesterUserId, String requestType, Map<String, String> requestParameters, String governanceActionTypeGUID, String governanceActionTypeName, String anchorGUID, String processName, String processStepGUID, String processStepName, String requestSourceName, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        String anchorGUIDParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        String governanceEngineGUID = this.validateGovernanceEngineName(userId, governanceEngineName, "governanceEngineName", requestType, serviceSupportedZones, methodName);
        EngineActionBuilder builder = new EngineActionBuilder(qualifiedName, domainIdentifier, displayName, description, governanceEngineGUID, governanceEngineName, governanceActionTypeGUID, governanceActionTypeName, processName, processStepGUID, processStepName, requesterUserId, requestType, requestParameters, mandatoryGuards, receivedGuards, EngineActionStatus.REQUESTED.getOrdinal(), startTime, null, null, null, null, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, anchorGUID, "anchorGUID", false, false, null, serviceSupportedZones, builder, methodName);
        String engineActionGUID = this.createBeanInRepository(userId, null, null, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, builder, null, methodName);
        if (engineActionGUID != null) {
            String engineActionGUIDParameterName = "engineActionGUID";
            InstanceProperties originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ORIGIN_GOVERNANCE_SERVICE.name, originatorServiceName, methodName);
            originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, OpenMetadataProperty.ORIGIN_GOVERNANCE_ENGINE.name, originatorEngineName, methodName);
            if (requestSourceGUIDs != null && !requestSourceGUIDs.isEmpty()) {
                String requestSourceGUIDParameterName = "requestSourceGUIDs[x]";
                originatorProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, originatorProperties, OpenMetadataProperty.REQUEST_SOURCE_NAME.name, requestSourceName, methodName);
                for (String requestSourceGUID : requestSourceGUIDs) {
                    if (requestSourceGUID == null) continue;
                    this.linkElementToElement(userId, null, null, requestSourceGUID, "requestSourceGUIDs[x]", OpenMetadataType.OPEN_METADATA_ROOT.typeName, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, true, true, serviceSupportedZones, OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE.typeGUID, OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE.typeName, originatorProperties, null, null, null, methodName);
                }
            }
            this.addActionTargets(userId, engineActionGUID, "engineActionGUID", qualifiedName, actionTargets, serviceSupportedZones, methodName);
        }
        return engineActionGUID;
    }

    private synchronized String getEngineActionForProcessStep(String userId, String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, List<String> mandatoryGuards, boolean ignoreMultipleTriggers, List<String> receivedGuards, Date startTime, String governanceEngineName, String requesterUserId, String requestType, Map<String, String> requestParameters, String governanceActionProcessStepGUID, String governanceActionProcessStepName, String anchorGUID, String processName, String requestSourceName, String originatorServiceName, String originatorEngineName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        String engineNameParameterName = "governanceEngineName";
        String requestTypeParameterName = "requestType";
        String nameParameterName = "governanceActionProcessStepGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", methodName);
        this.invalidParameterHandler.validateName(requestType, "requestType", methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.PROCESS_NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, processName, "governanceActionProcessStepGUID", OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, 0, 0, null, methodName);
        if (entities != null) {
            for (EntityDetail entity : entities) {
                String entityGovernanceActionProcessStepGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_STEP_GUID.name, entity.getProperties(), methodName);
                if (!governanceActionProcessStepGUID.equals(entityGovernanceActionProcessStepGUID)) continue;
                EngineActionStatus status = this.getActionStatus(OpenMetadataProperty.ACTION_STATUS.name, entity.getProperties());
                if (status == EngineActionStatus.REQUESTED) {
                    return entity.getGUID();
                }
                if (!ignoreMultipleTriggers) continue;
                return null;
            }
        }
        return this.createEngineAction(userId, governanceActionProcessStepName + "::" + String.valueOf(UUID.randomUUID()), domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, mandatoryGuards, receivedGuards, startTime, governanceEngineName, requesterUserId, requestType, requestParameters, null, null, anchorGUID, processName, governanceActionProcessStepGUID, governanceActionProcessStepName, requestSourceName, originatorServiceName, originatorEngineName, serviceSupportedZones, methodName);
    }

    private void addActionTargets(String userId, String engineActionGUID, String engineActionGUIDParameterName, String engineActionName, List<NewActionTarget> actionTargets, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (actionTargets != null && !actionTargets.isEmpty()) {
            String actionTargetGUIDParameterName = "actionTargets[x]";
            for (NewActionTarget actionTarget : actionTargets) {
                if (actionTarget == null) continue;
                String actionTargetGUID = actionTarget.getActionTargetGUID();
                String actionTargetName = actionTarget.getActionTargetName();
                if (actionTargetGUID == null) continue;
                InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTargetName, methodName);
                this.linkElementToElement(userId, null, null, engineActionGUID, engineActionGUIDParameterName, OpenMetadataType.ENGINE_ACTION.typeName, actionTargetGUID, "actionTargets[x]", OpenMetadataType.REFERENCEABLE.typeName, true, true, serviceSupportedZones, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName, properties, null, null, null, methodName);
                this.auditLog.logMessage(methodName, GenericHandlersAuditCode.ADD_ACTION_TARGETS.getMessageDefinition(actionTargetName, actionTargetGUID, engineActionName, engineActionGUID));
            }
        }
    }

    private String validateGovernanceEngineName(String userId, String governanceEngineName, String governanceEngineNameParameterName, String requestType, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceEngineGUID = this.getBeanGUIDByUniqueName(userId, governanceEngineName, governanceEngineNameParameterName, OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, new Date(), methodName);
        if (governanceEngineGUID == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(governanceEngineName, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        List<Relationship> relationships = this.getAttachmentLinks(userId, governanceEngineGUID, governanceEngineNameParameterName, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, null, OpenMetadataType.GOVERNANCE_SERVICE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, 0, 0, new Date(), methodName);
        if (relationships == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.NO_REQUEST_TYPE_FOR_ENGINE.getMessageDefinition(governanceEngineName, governanceEngineGUID, requestType, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
        }
        for (Relationship relationship : relationships) {
            String relationshipRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, relationship.getProperties(), methodName);
            if (!requestType.equals(relationshipRequestType)) continue;
            return governanceEngineGUID;
        }
        throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_REQUEST_TYPE.getMessageDefinition(governanceEngineName, governanceEngineGUID, requestType, this.serviceName, this.serverName), this.getClass().getName(), methodName, governanceEngineNameParameterName);
    }

    public B getEngineAction(String userId, String engineActionGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String engineActionGUIDParameterName = "engineActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", methodName);
        EntityDetail primaryEntity = this.getEntityFromRepository(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        return this.getEngineAction(userId, primaryEntity, serviceSupportedZones, effectiveTime, methodName);
    }

    public B getEngineAction(String userId, EntityDetail primaryEntity, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String actionTargetGUIDParameterName = "actionTargetGUID";
        String requestSourceGUIDParameterName = "requestSourceGUID";
        if (primaryEntity != null) {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            ArrayList<EntityDetail> supplementaryEntities = new ArrayList<EntityDetail>();
            RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, primaryEntity.getGUID(), OpenMetadataType.ENGINE_ACTION.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
            while (iterator.moreToReceive()) {
                Relationship relationship = iterator.getNext();
                if (relationship == null || relationship.getType() == null) continue;
                String actualTypeName = relationship.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName)) {
                    relationships.add(relationship);
                    String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, actionTargetGUID, "actionTargetGUID", OpenMetadataType.REFERENCEABLE.typeName, null, null, true, true, serviceSupportedZones, effectiveTime, methodName));
                    continue;
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE.typeName)) {
                    relationships.add(relationship);
                    String requestSourceGUID = relationship.getEntityOneProxy().getGUID();
                    supplementaryEntities.add(this.getEntityFromRepository(userId, requestSourceGUID, "requestSourceGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, true, true, serviceSupportedZones, effectiveTime, methodName));
                    continue;
                }
                relationships.add(relationship);
            }
            return this.converter.getNewComplexBean(this.beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
        }
        return null;
    }

    public EngineActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        EngineActionStatus engineActionStatus = EngineActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    engineActionStatus = EngineActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    engineActionStatus = EngineActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    engineActionStatus = EngineActionStatus.WAITING;
                    break;
                }
                case 3: {
                    engineActionStatus = EngineActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    engineActionStatus = EngineActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    engineActionStatus = EngineActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    engineActionStatus = EngineActionStatus.INVALID;
                    break;
                }
                case 12: {
                    engineActionStatus = EngineActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    engineActionStatus = EngineActionStatus.FAILED;
                    break;
                }
                case 14: {
                    engineActionStatus = EngineActionStatus.CANCELLED;
                }
            }
        }
        return engineActionStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void claimEngineAction(String userId, String engineActionGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "engineActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION_PROPERTIES.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        EngineActionStatus status = this.getActionStatus(OpenMetadataProperty.ACTION_STATUS.name, properties);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, properties, methodName);
        if (status != EngineActionStatus.APPROVED || processingEngineUserId != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.INVALID_ENGINE_ACTION_STATUS.getMessageDefinition(userId, engineActionGUID, processingEngineUserId, status.getName()), this.getClass().getName(), methodName);
        }
        EngineActionBuilder builder = new EngineActionBuilder(EngineActionStatus.WAITING.getOrdinal(), userId, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, false, false, serviceSupportedZones, builder.getClaimInstanceProperties(methodName), true, effectiveTime, methodName);
        this.auditLog.logMessage(methodName, GenericHandlersAuditCode.SUCCESSFUL_ACTION_CLAIM_REQUEST.getMessageDefinition(userId, engineActionGUID));
    }

    public void cancelEngineAction(String userId, String engineActionGUID, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties;
        String guidParameterName = "engineActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (entity != null) {
            properties = entity.getProperties();
            if (properties == null) {
                throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION_PROPERTIES.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
            }
        } else {
            throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        }
        EngineActionStatus status = this.getActionStatus(OpenMetadataProperty.ACTION_STATUS.name, properties);
        EngineActionBuilder builder = new EngineActionBuilder(EngineActionStatus.CANCELLED.getOrdinal(), userId, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, false, false, serviceSupportedZones, builder.getCancelInstanceProperties(methodName), true, effectiveTime, methodName);
        this.auditLog.logMessage(methodName, GenericHandlersAuditCode.ENGINE_ACTION_CANCELLED.getMessageDefinition(engineActionGUID, userId, status.name()));
    }

    private String getEngineActionStatusName(int ordinal) {
        for (EngineActionStatus engineActionStatus : EngineActionStatus.values()) {
            if (engineActionStatus.getOrdinal() != ordinal) continue;
            return engineActionStatus.name().toUpperCase();
        }
        return "UNKNOWN";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateEngineActionStatus(String userId, String engineActionGUID, int engineActionStatus, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "engineActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", methodName);
        EntityDetail entity = this.getEntityFromRepository(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (entity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = entity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION_PROPERTIES.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        int currentStatus = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ACTION_STATUS.name, properties, methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, properties, methodName);
        if ((processingEngineUserId != null || engineActionStatus != EngineActionStatus.APPROVED.getOrdinal()) && !userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, engineActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), engineActionStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.ACTION_STATUS.name);
        }
        if (engineActionStatus == EngineActionStatus.IN_PROGRESS.getOrdinal()) {
            properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.START_DATE.name, new Date(), methodName);
        }
        this.updateBeanInRepository(userId, null, null, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, false, false, serviceSupportedZones, properties, true, effectiveTime, methodName);
        this.auditLog.logMessage(methodName, GenericHandlersAuditCode.ENGINE_ACTION_STATUS_CHANGE.getMessageDefinition(this.getEngineActionStatusName(currentStatus), this.getEngineActionStatusName(engineActionStatus), engineActionGUID, userId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordCompletionStatus(String userId, String engineActionGUID, int status, Map<String, String> callerRequestParameters, List<String> outputGuards, List<NewActionTarget> newActionTargets, String completionMessage, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "engineActionGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(engineActionGUID, "engineActionGUID", methodName);
        EntityDetail engineActionEntity = this.getEntityFromRepository(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, methodName);
        if (engineActionEntity == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        InstanceProperties properties = engineActionEntity.getProperties();
        if (properties == null) throw new PropertyServerException(GenericHandlersErrorCode.MISSING_ENGINE_ACTION_PROPERTIES.getMessageDefinition(engineActionGUID, "engineActionGUID", this.serviceName, methodName), this.getClass().getName(), methodName);
        String processingEngineUserId = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, properties, methodName);
        String governanceActionProcessStepGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_STEP_GUID.name, properties, methodName);
        int storedStatus = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ACTION_STATUS.name, properties, methodName);
        if (storedStatus != EngineActionStatus.REQUESTED.getOrdinal() && storedStatus != EngineActionStatus.APPROVED.getOrdinal() && storedStatus != EngineActionStatus.WAITING.getOrdinal() && storedStatus != EngineActionStatus.ACTIVATING.getOrdinal() && storedStatus != EngineActionStatus.IN_PROGRESS.getOrdinal()) return;
        if (!userId.equals(processingEngineUserId)) throw new UserNotAuthorizedException(GenericHandlersErrorCode.INVALID_PROCESSING_USER.getMessageDefinition(userId, methodName, engineActionGUID, processingEngineUserId), this.getClass().getName(), methodName, userId);
        EngineActionBuilder builder = new EngineActionBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, null, null, engineActionGUID, engineActionEntity, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, builder.getCompletionInstanceProperties(engineActionEntity.getProperties(), status, new Date(), outputGuards, completionMessage, methodName), methodName);
        this.markActionTargetsAsComplete(userId, engineActionGUID, serviceSupportedZones, effectiveTime, status);
        OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)engineActionEntity, methodName);
        String anchorGUID = null;
        if (anchorIdentifiers != null) {
            anchorGUID = anchorIdentifiers.anchorGUID;
        }
        String processName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_NAME.name, properties, methodName);
        String requesterUserId = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUESTER_USER_ID.name, properties, methodName);
        this.initiateNextEngineActions(userId, engineActionGUID, governanceActionProcessStepGUID, anchorGUID, processName, requesterUserId, outputGuards, newActionTargets, callerRequestParameters, serviceSupportedZones, effectiveTime, methodName);
    }

    private void markActionTargetsAsComplete(String userId, String engineActionGUID, List<String> serviceSupportedZones, Date effectiveTime, int status) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markActionTargetsAsComplete";
        String guidParameterName = "engineActionGUID";
        this.validateEntityAndAnchorForRead(userId, engineActionGUID, "engineActionGUID", OpenMetadataType.ENGINE_ACTION.typeName, true, false, true, false, serviceSupportedZones, effectiveTime, "markActionTargetsAsComplete");
        List actionTargetRelationships = this.repositoryHandler.getRelationshipsByType(userId, engineActionGUID, OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeGUID, OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, false, 0, 0, effectiveTime, "markActionTargetsAsComplete");
        if (actionTargetRelationships != null) {
            for (Relationship actionTarget : actionTargetRelationships) {
                InstanceProperties newActionTargetProperties;
                InstanceProperties actionTargetProperties;
                if (actionTarget == null || (actionTargetProperties = actionTarget.getProperties()).getPropertyValue(OpenMetadataProperty.ACTION_STATUS.name) != null) continue;
                try {
                    newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), status, "markActionTargetsAsComplete");
                }
                catch (TypeErrorException error) {
                    throw new PropertyServerException((OMFCheckedExceptionBase)error);
                }
                newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, OpenMetadataProperty.COMPLETION_DATE.name, new Date(), "markActionTargetsAsComplete");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, "markActionTargetsAsComplete");
            }
        }
    }

    private void initiateNextEngineActions(String userId, String previousEngineActionGUID, String previousGovernanceActionProcessStepGUID, String anchorGUID, String processName, String requesterUserId, List<String> outputGuards, List<NewActionTarget> newActionTargets, Map<String, String> callerRequestParameters, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nextGovernanceActionProcessStepParameterName = "nextActionProcessStep.getEntityTwoProxy().getGUID()";
        if (previousGovernanceActionProcessStepGUID != null) {
            List nextActionProcessSteps = this.repositoryHandler.getRelationshipsByType(userId, previousGovernanceActionProcessStepGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, OpenMetadataType.NEXT_GOVERNANCE_ACTION_PROCESS_STEP_RELATIONSHIP.typeGUID, OpenMetadataType.NEXT_GOVERNANCE_ACTION_PROCESS_STEP_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 0, effectiveTime, methodName);
            if (nextActionProcessSteps != null && !nextActionProcessSteps.isEmpty()) {
                for (Relationship nextActionProcessStep : nextActionProcessSteps) {
                    boolean validNextAction;
                    if (nextActionProcessStep == null) continue;
                    String guard = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, nextActionProcessStep.getProperties(), methodName);
                    boolean mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.MANDATORY_GUARD.name, nextActionProcessStep.getProperties(), methodName);
                    boolean bl = validNextAction = guard == null;
                    if (guard != null && outputGuards != null) {
                        for (String outputGuard : outputGuards) {
                            if (outputGuard == null || !outputGuard.equals(guard)) continue;
                            validNextAction = true;
                        }
                    }
                    if (!validNextAction) continue;
                    this.prepareEngineActionFromProcessStep(userId, anchorGUID, nextActionProcessStep.getEntityTwoProxy().getGUID(), "nextActionProcessStep.getEntityTwoProxy().getGUID()", guard, mandatoryGuard, null, previousEngineActionGUID, requesterUserId, callerRequestParameters, null, newActionTargets, processName, null, null, null, serviceSupportedZones, methodName);
                }
            } else {
                String processNameParameterName = "processName";
                ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
                specificMatchPropertyNames.add(OpenMetadataProperty.PROCESS_NAME.name);
                List<EntityDetail> actionsInProcess = this.getEntitiesByValue(userId, processName, "processName", OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, specificMatchPropertyNames, true, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, 0, 0, effectiveTime, methodName);
                if (actionsInProcess != null) {
                    int incompleteActions = 0;
                    for (EntityDetail actionInProcess : actionsInProcess) {
                        int storedStatus;
                        if (actionInProcess == null || (storedStatus = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ACTION_STATUS.name, actionInProcess.getProperties(), methodName)) != EngineActionStatus.REQUESTED.getOrdinal() && storedStatus != EngineActionStatus.APPROVED.getOrdinal() && storedStatus != EngineActionStatus.WAITING.getOrdinal() && storedStatus != EngineActionStatus.ACTIVATING.getOrdinal() && storedStatus != EngineActionStatus.IN_PROGRESS.getOrdinal()) continue;
                        ++incompleteActions;
                    }
                    if (incompleteActions == 0) {
                        String anchorGUIDParameterName = "anchorGUID";
                        this.updateBeanInRepository(userId, null, null, anchorGUID, "anchorGUID", OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE.typeName, false, false, serviceSupportedZones, this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, OpenMetadataProperty.PROCESS_END_TIME.name, new Date(), methodName), true, effectiveTime, methodName);
                    }
                }
            }
        }
    }

    private List<String> getMandatoryGuards(String userId, String governanceActionProcessStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMandatoryGuards";
        List dependedOnActionProcessSteps = this.repositoryHandler.getRelationshipsByType(userId, governanceActionProcessStepGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, OpenMetadataType.NEXT_GOVERNANCE_ACTION_PROCESS_STEP_RELATIONSHIP.typeGUID, OpenMetadataType.NEXT_GOVERNANCE_ACTION_PROCESS_STEP_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, 0, 0, null, "getMandatoryGuards");
        if (dependedOnActionProcessSteps != null) {
            ArrayList<String> mandatoryGuards = new ArrayList<String>();
            for (Relationship dependedOnActionType : dependedOnActionProcessSteps) {
                String guard;
                boolean mandatoryGuard;
                if (dependedOnActionType == null || dependedOnActionType.getEntityTwoProxy() == null || !governanceActionProcessStepGUID.equals(dependedOnActionType.getEntityTwoProxy().getGUID()) || !(mandatoryGuard = this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.MANDATORY_GUARD.name, dependedOnActionType.getProperties(), "getMandatoryGuards")) || (guard = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, dependedOnActionType.getProperties(), "getMandatoryGuards")) == null) continue;
                mandatoryGuards.add(guard);
            }
            if (mandatoryGuards.isEmpty()) {
                return null;
            }
            return mandatoryGuards;
        }
        return null;
    }

    public List<B> getEngineActions(String userId, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List<EntityDetail> retrievedEntities = this.getEntitiesByType(userId, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, startFrom, queryPageSize, effectiveTime, methodName);
        if (retrievedEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail nextEngineAction : retrievedEntities) {
                B bean = this.getEngineAction(userId, nextEngineAction, serviceSupportedZones, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            return results;
        }
        return null;
    }

    public List<B> getActiveEngineActions(String userId, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List<EntityDetail> retrievedEntities = this.getEntitiesByType(userId, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, startFrom, queryPageSize, effectiveTime, methodName);
        if (retrievedEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail nextEngineAction : retrievedEntities) {
                B bean;
                int status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ACTION_STATUS.name, nextEngineAction.getProperties(), methodName);
                if (status != EngineActionStatus.REQUESTED.getOrdinal() && status != EngineActionStatus.APPROVED.getOrdinal() && status != EngineActionStatus.WAITING.getOrdinal() && status != EngineActionStatus.IN_PROGRESS.getOrdinal() || (bean = this.getEngineAction(userId, nextEngineAction, serviceSupportedZones, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            return results;
        }
        return null;
    }

    public List<B> getActiveClaimedEngineActions(String userId, String governanceEngineGUID, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "governanceEngineGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, userId, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.ENGINE_ACTION.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, queryPageSize, effectiveTime, methodName);
        if (retrievedEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail nextEngineAction : retrievedEntities) {
                B bean;
                int status = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.ACTION_STATUS.name, nextEngineAction.getProperties(), methodName);
                String engineActionGovernanceEngineGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.EXECUTOR_ENGINE_GUID.name, nextEngineAction.getProperties(), methodName);
                if (!governanceEngineGUID.equals(engineActionGovernanceEngineGUID) || status != EngineActionStatus.WAITING.getOrdinal() && status != EngineActionStatus.IN_PROGRESS.getOrdinal() || (bean = this.getEngineAction(userId, nextEngineAction, serviceSupportedZones, effectiveTime, methodName)) == null) continue;
                results.add(bean);
            }
            return results;
        }
        return null;
    }

    public List<B> findEngineActions(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, searchStringParameterName, methodName);
        List<EntityDetail> entities = this.findEntities(userId, searchString, searchStringParameterName, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, null, null, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : entities) {
                B bean = this.getEngineAction(userId, entityDetail, serviceSupportedZones, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> getEngineActionsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.PROCESS_NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, nameParameterName, OpenMetadataType.ENGINE_ACTION.typeGUID, OpenMetadataType.ENGINE_ACTION.typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : entities) {
                B bean = this.getEngineAction(userId, entityDetail, serviceSupportedZones, effectiveTime, methodName);
                if (bean == null) continue;
                results.add(bean);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public void updateActionTargetStatus(String userId, String actionTargetGUID, int status, Date startDate, Date completionDate, String completionMessage, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "actionTargetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(actionTargetGUID, "actionTargetGUID", methodName);
        Relationship actionTarget = this.repositoryHandler.getRelationshipByGUID(userId, actionTargetGUID, "actionTargetGUID", OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName, effectiveTime, methodName);
        if (actionTarget != null) {
            InstanceProperties newActionTargetProperties;
            try {
                newActionTargetProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, actionTarget.getProperties(), OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), status, methodName);
            }
            catch (TypeErrorException error) {
                throw new PropertyServerException((OMFCheckedExceptionBase)error);
            }
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, OpenMetadataProperty.START_DATE.name, startDate, methodName);
            newActionTargetProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, newActionTargetProperties, OpenMetadataProperty.COMPLETION_DATE.name, completionDate, methodName);
            newActionTargetProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, newActionTargetProperties, OpenMetadataProperty.COMPLETION_MESSAGE.name, completionMessage, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, null, null, actionTarget, newActionTargetProperties, methodName);
        }
    }
}

