/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EventTypeHandler<B>
extends ReferenceableHandler<B> {
    public EventTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createEventType(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(topicGUID, topicGUIDParameterName, methodName);
        String typeName = OpenMetadataType.EVENT_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.EVENT_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveFrom, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, topicGUID, topicGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        String eventTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (eventTypeGUID != null) {
            String eventTypeGUIDParameterName = "eventTypeGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", eventTypeGUID, "eventTypeGUID", OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, null, methodName);
        }
        return eventTypeGUID;
    }

    public String createEventTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String eventTypeListGUIDParameterName = "eventTypeListGUID";
        String eventTypeListGUID = this.getEventTypeListGUID(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, qualifiedName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveFrom, methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String eventTypeGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.EVENT_TYPE.typeGUID, OpenMetadataType.EVENT_TYPE.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        String eventTypeGUIDParameterName = "eventTypeGUID";
        this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, eventTypeListGUID, "eventTypeListGUID", eventTypeGUID, "eventTypeGUID", OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, null, methodName);
        return eventTypeGUID;
    }

    public void updateEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(eventTypeGUID, eventTypeGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.EVENT_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.EVENT_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeEventType(String userId, String externalSourceGUID, String externalSourceName, String eventTypeGUID, String eventTypeGUIDParameterName, String qualifiedName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, eventTypeGUID, eventTypeGUIDParameterName, OpenMetadataType.EVENT_TYPE.typeGUID, OpenMetadataType.EVENT_TYPE.typeName, false, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findEventTypes(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.EVENT_TYPE.typeGUID, OpenMetadataType.EVENT_TYPE.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getEventTypesForEventSet(String userId, String eventSetGUID, String eventSetGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, eventSetGUID, eventSetGUIDParameterName, OpenMetadataType.EVENT_SET.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataType.EVENT_TYPE.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.EVENT_TYPE.typeGUID, OpenMetadataType.EVENT_TYPE.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getEventTypesForTopic(String userId, String topicGUID, String topicGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail eventTypeListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.EVENT_TYPE_LIST.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (eventTypeListEntity != null) {
            String eventTypeListGUIDParameterName = "eventTypeListGUID";
            return this.getAttachedElements(userId, eventTypeListEntity.getGUID(), "eventTypeListGUID", OpenMetadataType.EVENT_TYPE_LIST.typeName, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeName, OpenMetadataType.EVENT_TYPE.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
        }
        return null;
    }

    private String getEventTypeListGUID(String userId, String externalSourceGUID, String externalSourceName, String topicGUID, String topicGUIDParameterName, String topicQualifiedName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String eventTypeListGUID;
        EntityDetail eventListEntity = this.getAttachedEntity(userId, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.EVENT_TYPE_LIST.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (eventListEntity == null) {
            SchemaTypeBuilder builder = new SchemaTypeBuilder(topicQualifiedName + "_EventList", OpenMetadataType.EVENT_TYPE_LIST.typeGUID, OpenMetadataType.EVENT_TYPE_LIST.typeName, this.repositoryHelper, this.serviceName, this.serverName);
            this.addAnchorGUIDToBuilder(userId, topicGUID, topicGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
            builder.setEffectivityDates(effectiveFrom, effectiveTo);
            eventTypeListGUID = this.repositoryHandler.createEntity(userId, OpenMetadataType.EVENT_TYPE_LIST.typeGUID, OpenMetadataType.EVENT_TYPE_LIST.typeName, externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), builder.getEntityClassifications(), builder.getInstanceStatus(), methodName);
            if (eventTypeListGUID != null) {
                String eventTypeListGUIDParameterName = "eventTypeListGUID";
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, topicGUID, topicGUIDParameterName, OpenMetadataType.TOPIC.typeName, eventTypeListGUID, "eventTypeListGUID", OpenMetadataType.EVENT_TYPE_LIST.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            } else {
                this.errorHandler.logNullInstance(OpenMetadataType.EVENT_TYPE_LIST.typeName, methodName);
            }
        } else {
            eventTypeListGUID = eventListEntity.getGUID();
        }
        return eventTypeListGUID;
    }

    public B getEventTypeByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.EVENT_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

