/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

class ExternalIdentifierBuilder
extends ReferenceableBuilder {
    private String identifier = null;
    private int keyPattern = 0;
    private String externalInstanceTypeName = null;
    private String externalInstanceCreatedBy = null;
    private Date externalInstanceCreationTime = null;
    private String externalInstanceLastUpdatedBy = null;
    private Date externalInstanceLastUpdateTime = null;
    private long externalInstanceVersion = 0L;

    ExternalIdentifierBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, repositoryHelper, serviceName, serverName);
    }

    ExternalIdentifierBuilder(String identifier, int keyPattern, String externalInstanceTypeName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(identifier + "::" + String.valueOf(UUID.randomUUID()), OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, repositoryHelper, serviceName, serverName);
        this.identifier = identifier;
        this.keyPattern = keyPattern;
        this.externalInstanceTypeName = externalInstanceTypeName;
        this.externalInstanceCreatedBy = externalInstanceCreatedBy;
        this.externalInstanceCreationTime = externalInstanceCreationTime;
        this.externalInstanceLastUpdatedBy = externalInstanceLastUpdatedBy;
        this.externalInstanceLastUpdateTime = externalInstanceLastUpdateTime;
        this.externalInstanceVersion = externalInstanceVersion;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IDENTIFIER.name, this.identifier, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeGUID(), KeyPattern.getOpenTypeName(), this.keyPattern, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.KEY_PATTERN.name);
        }
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_TYPE_NAME.name, this.externalInstanceTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.name, this.externalInstanceCreatedBy, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.name, this.externalInstanceCreationTime, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.name, this.externalInstanceLastUpdatedBy, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.name, this.externalInstanceLastUpdateTime, methodName);
        properties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXT_INSTANCE_VERSION.name, this.externalInstanceVersion, methodName);
        return properties;
    }

    InstanceProperties getExternalIdResourceLinkProperties(String description, String usage, String source, Map<String, String> mappingProperties, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, usage, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MAPPING_PROPERTIES.name, mappingProperties, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LAST_SYNCHRONIZED.name, new Date(), methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getExternalIdScopeProperties(String description, int permittedSynchronization, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, PermittedSynchronization.getOpenTypeGUID(), PermittedSynchronization.getOpenTypeName(), permittedSynchronization, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name);
        }
        this.setEffectivityDates(properties);
        return properties;
    }
}

