/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelatedEntitiesIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalIdentifierHandler<EXTERNAL_ID, OPEN_METADATA_ELEMENT_HEADER>
extends ReferenceableHandler<EXTERNAL_ID> {
    private final OpenMetadataAPIGenericConverter<OPEN_METADATA_ELEMENT_HEADER> elementConverter;
    private final Class<OPEN_METADATA_ELEMENT_HEADER> elementBeanClass;

    public ExternalIdentifierHandler(OpenMetadataAPIGenericConverter<EXTERNAL_ID> converter, Class<EXTERNAL_ID> beanClass, OpenMetadataAPIGenericConverter<OPEN_METADATA_ELEMENT_HEADER> elementConverter, Class<OPEN_METADATA_ELEMENT_HEADER> elementBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.elementConverter = elementConverter;
        this.elementBeanClass = elementBeanClass;
    }

    public void setUpExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, int identifierKeyPattern, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String externalInstanceTypeName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, String scopeDomainName, int permittedSynchronization, String synchronizationDescription, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdGUID;
        String externalIdGUIDParameterName = "externalIdGUID";
        EntityDetail externalIdEntity = this.getExternalIdEntity(userId, identifier, identifierParameterName, scopeGUID, scopeGUIDParameterName, scopeQualifiedName, scopeTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (externalIdEntity == null) {
            externalIdGUID = this.createExternalIdentifier(userId, identifier, identifierKeyPattern, externalInstanceTypeName, externalInstanceCreatedBy, externalInstanceCreationTime, externalInstanceLastUpdatedBy, externalInstanceLastUpdateTime, externalInstanceVersion, scopeGUID, scopeGUIDParameterName, scopeTypeName, scopeDomainName, permittedSynchronization, synchronizationDescription, serviceSupportedZones, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.SETTING_UP_EXTERNAL_ID.getMessageDefinition(this.serviceName, elementTypeName, elementGUID, identifier, scopeQualifiedName, scopeGUID, methodName));
        } else {
            externalIdGUID = externalIdEntity.getGUID();
            this.updateExternalIdentifier(userId, externalIdGUID, "externalIdGUID", identifier, identifierKeyPattern, externalInstanceTypeName, externalInstanceCreatedBy, externalInstanceCreationTime, externalInstanceLastUpdatedBy, externalInstanceLastUpdateTime, externalInstanceVersion, serviceSupportedZones, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.updateScopeProperties(userId, externalIdGUID, "externalIdGUID", scopeGUID, scopeGUIDParameterName, scopeTypeName, permittedSynchronization, synchronizationDescription, serviceSupportedZones, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        Relationship resourceLink = this.getResourceLinkRelationship(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, serviceSupportedZones, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (resourceLink == null) {
            this.createExternalIdLink(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, "externalIdGUID", identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, serviceSupportedZones, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.updateExternalIdLink(userId, resourceLink, identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
        }
    }

    public void logRelationshipCreation(String scopeGUID, String scopeQualifiedName, String relationshipType, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String methodName) {
        if (scopeGUID != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.NEW_EXTERNAL_RELATIONSHIP.getMessageDefinition(this.serviceName, relationshipType, end1TypeName, end1GUID, end2TypeName, end2GUID, methodName, scopeGUID, scopeQualifiedName));
        }
    }

    public void logRelationshipUpdate(String scopeGUID, String scopeQualifiedName, String relationshipType, String relationshipGUID, String methodName) {
        if (scopeGUID != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.EXTERNAL_RELATIONSHIP_UPDATED.getMessageDefinition(this.serviceName, relationshipType, relationshipGUID, methodName, scopeGUID, scopeQualifiedName));
        }
    }

    public void logRelationshipRemoval(String scopeGUID, String scopeQualifiedName, String relationshipType, String end1GUID, String end1TypeName, String end2GUID, String end2TypeName, String methodName) {
        if (scopeGUID != null) {
            this.auditLog.logMessage(methodName, GenericHandlersAuditCode.EXTERNAL_RELATIONSHIP_REMOVED.getMessageDefinition(this.serviceName, relationshipType, end1TypeName, end1GUID, end2TypeName, end2GUID, methodName, scopeGUID, scopeQualifiedName));
        }
    }

    public void removeExternalIdentifier(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, List<String> serviceSupportedZones, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(identifier, identifierParameterName, methodName);
        EntityDetail externalIdEntity = this.getExternalIdEntity(userId, identifier, identifierParameterName, scopeGUID, scopeGUIDParameterName, scopeQualifiedName, scopeTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (externalIdEntity == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXTERNAL_IDENTITY.getMessageDefinition(this.serviceName, identifier, scopeQualifiedName, scopeGUID, elementTypeName, elementGUID), this.getClass().getName(), methodName, identifierParameterName);
        }
        this.deleteBeanInRepository(userId, scopeGUID, scopeQualifiedName, externalIdEntity.getGUID(), identifierParameterName, OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public void removeExternalScope(String userId, String scopeGUID, String scopeGUIDParameterName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.deleteBeanInRepository(userId, scopeGUID, null, scopeGUID, scopeGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, false, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public EntityDetail confirmSynchronization(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String identifier, String identifierParameterName, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(identifier, identifierParameterName, methodName);
        EntityDetail externalIdEntity = this.getExternalIdEntity(userId, identifier, identifierParameterName, scopeGUID, scopeGUIDParameterName, scopeQualifiedName, scopeTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (externalIdEntity == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_EXTERNAL_IDENTITY.getMessageDefinition(this.serviceName, identifier, scopeQualifiedName, scopeGUID, elementTypeName, elementGUID), this.getClass().getName(), methodName, identifierParameterName);
        }
        Relationship resourceLink = this.getResourceLinkRelationship(userId, elementGUID, elementGUIDParameterName, elementTypeName, externalIdEntity.getGUID(), serviceSupportedZones, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (resourceLink == null) {
            throw new InvalidParameterException(GenericHandlersErrorCode.UNKNOWN_RESOURCE_LINK.getMessageDefinition(this.serviceName, identifier, scopeQualifiedName, scopeGUID, elementTypeName, elementGUID), this.getClass().getName(), methodName, identifierParameterName);
        }
        InstanceProperties newProperties = resourceLink.getProperties() == null ? this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, OpenMetadataProperty.LAST_SYNCHRONIZED.name, new Date(), methodName) : this.repositoryHelper.addDatePropertyToInstance(this.serviceName, new InstanceProperties(resourceLink.getProperties()), OpenMetadataProperty.LAST_SYNCHRONIZED.name, new Date(), methodName);
        this.repositoryHandler.updateRelationshipProperties(userId, null, null, resourceLink, newProperties, methodName);
        return externalIdEntity;
    }

    private EntityDetail getExternalIdEntity(String userId, String identifier, String identifierParameterName, String scopeGUID, String scopeGUIDParameterName, String scopeQualifiedName, String scopeTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(identifier, identifierParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.getMaxPagingSize();
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IDENTIFIER.name, identifier, methodName);
        List externalIdEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.EXTERNAL_ID.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, queryPageSize, effectiveTime, methodName);
        if (externalIdEntities != null) {
            for (EntityDetail externalIdEntity : externalIdEntities) {
                if (!this.validateExternalIdentifierScope(identifier, externalIdEntity, scopeGUID, scopeQualifiedName, scopeTypeName, methodName)) continue;
                return externalIdEntity;
            }
        }
        return null;
    }

    private Relationship getResourceLinkRelationship(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String externalIdGUID, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        List<Relationship> resourceLinks = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName, externalIdGUID, OpenMetadataType.EXTERNAL_ID.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (resourceLinks != null) {
            for (Relationship relationship : resourceLinks) {
                if (relationship == null || relationship.getEntityOneProxy() == null || !elementGUID.equals(relationship.getEntityOneProxy().getGUID())) continue;
                return relationship;
            }
        }
        return null;
    }

    private boolean validateExternalIdentifierScope(String identifier, EntityDetail externalIdEntity, String scopeGUID, String scopeQualifiedName, String scopeTypeName, String methodName) throws PropertyServerException {
        if (externalIdEntity != null && scopeGUID != null) {
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)externalIdEntity, methodName);
            return scopeGUID.equals(anchorIdentifiers.anchorGUID) || anchorIdentifiers.anchorGUID == null && scopeGUID.equals(externalIdEntity.getGUID());
        }
        throw new PropertyServerException(GenericHandlersErrorCode.NULL_EXTERNAL_ID_ENTITY.getMessageDefinition(identifier, scopeTypeName, scopeQualifiedName, scopeGUID), this.getClass().getName(), methodName);
    }

    private String createExternalIdentifier(String userId, String identifier, int identifierKeyPattern, String externalInstanceTypeName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, String scopeGUID, String scopeGUIDParameterName, String scopeTypeName, String scopeDomainName, int permittedSynchronization, String synchronizationDescription, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdGUIDParameterName = "externalIdentifierGUID";
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(identifier, identifierKeyPattern, externalInstanceTypeName, externalInstanceCreatedBy, externalInstanceCreationTime, externalInstanceLastUpdatedBy, externalInstanceLastUpdateTime, externalInstanceVersion, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, scopeGUID, scopeTypeName, scopeDomainName, scopeGUID, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String externalIdGUID = this.createBeanInRepository(userId, null, null, OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, builder, effectiveTime, methodName);
        if (externalIdGUID != null) {
            InstanceProperties scopeProperties = builder.getExternalIdScopeProperties(synchronizationDescription, permittedSynchronization, methodName);
            this.uncheckedLinkElementToElement(userId, null, null, scopeGUID, scopeGUIDParameterName, externalIdGUID, "externalIdentifierGUID", OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID, scopeProperties, methodName);
        }
        return externalIdGUID;
    }

    private void updateExternalIdentifier(String userId, String externalIdGUID, String externalIdGUIDParameterName, String identifier, int identifierKeyPattern, String externalInstanceTypeName, String externalInstanceCreatedBy, Date externalInstanceCreationTime, String externalInstanceLastUpdatedBy, Date externalInstanceLastUpdateTime, long externalInstanceVersion, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(identifier, identifierKeyPattern, externalInstanceTypeName, externalInstanceCreatedBy, externalInstanceCreationTime, externalInstanceLastUpdatedBy, externalInstanceLastUpdateTime, externalInstanceVersion, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, null, null, externalIdGUID, externalIdGUIDParameterName, OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, builder.getInstanceProperties(methodName), true, effectiveTime, methodName);
    }

    private void createExternalIdLink(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String externalIdGUID, String externalIdGUIDParameterName, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, List<String> serviceSupportedZones, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties resourceLinkProperties = builder.getExternalIdResourceLinkProperties(identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.linkElementToElement(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, externalIdGUID, externalIdGUIDParameterName, OpenMetadataType.EXTERNAL_ID.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName, resourceLinkProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    private void updateExternalIdLink(String userId, Relationship externalIdLink, String identifierDescription, String identifierUsage, String identifierSource, Map<String, String> identifierMappingProperties, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        InstanceProperties existingProperties;
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        if (externalIdLink != null && (this.propertyUpdateNeeded(identifierDescription, OpenMetadataProperty.DESCRIPTION.name, existingProperties = externalIdLink.getProperties(), methodName) || this.propertyUpdateNeeded(identifierUsage, OpenMetadataProperty.USAGE.name, existingProperties, methodName) || this.propertyUpdateNeeded(identifierSource, OpenMetadataProperty.SOURCE.name, existingProperties, methodName))) {
            InstanceProperties properties = builder.getExternalIdResourceLinkProperties(identifierDescription, identifierUsage, identifierSource, identifierMappingProperties, methodName);
            this.repositoryHandler.updateRelationshipProperties(userId, null, null, externalIdLink, properties, methodName);
        }
    }

    private boolean propertyUpdateNeeded(String newValue, String propertyName, InstanceProperties existingProperties, String methodName) {
        String existingValue = this.repositoryHelper.getStringProperty(this.serviceName, propertyName, existingProperties, methodName);
        if (existingValue == null && newValue == null) {
            return false;
        }
        if (existingValue == null) {
            return true;
        }
        return !existingValue.equals(newValue);
    }

    private void updateScopeProperties(String userId, String externalIdGUID, String externalIdGUIDParameterName, String scopeGUID, String scopeGUIDParameterName, String scopeTypeName, int permittedSynchronization, String synchronizationDescription, List<String> serviceSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ExternalIdentifierBuilder builder = new ExternalIdentifierBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getExternalIdScopeProperties(synchronizationDescription, permittedSynchronization, methodName);
        this.updateElementToElementLink(userId, null, null, scopeGUID, scopeGUIDParameterName, scopeTypeName, externalIdGUID, externalIdGUIDParameterName, OpenMetadataType.EXTERNAL_ID.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName, false, properties, effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForElement(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, serviceSupportedZones, null, OpenMetadataType.REFERENCEABLE.typeName, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForScope(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, String scopeGUID, String scopeQualifiedName, boolean forLineage, boolean forDuplicateProcessing, int startingFrom, int pageSize, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getExternalIdentifiersForScope(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, scopeGUID, scopeQualifiedName, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<EXTERNAL_ID> getExternalIdentifiersForScope(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, String scopeGUID, String scopeTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ArrayList results = new ArrayList();
        List<Relationship> externalIdLinks = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName, null, OpenMetadataType.EXTERNAL_ID.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        if (externalIdLinks != null) {
            for (Relationship externalIdLink : externalIdLinks) {
                List<Relationship> externalIdScopes;
                if (externalIdLink == null || externalIdLink.getEntityTwoProxy() == null) continue;
                String externalIdGUIDParameterName = "externalIdLink.getEntityTwoProxy().getGUID()";
                String externalIdGUID = externalIdLink.getEntityTwoProxy().getGUID();
                EntityDetail externalIdEntity = this.getEntityFromRepository(userId, externalIdGUID, "externalIdLink.getEntityTwoProxy().getGUID()", OpenMetadataType.EXTERNAL_ID.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                if (externalIdEntity == null || externalIdEntity.getType() == null || (externalIdScopes = this.getAttachmentLinks(userId, externalIdEntity, "externalIdLink.getEntityTwoProxy().getGUID()", OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName, null, scopeTypeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName)) == null) continue;
                for (Relationship externalIdScope : externalIdScopes) {
                    if (externalIdScope == null || externalIdScope.getEntityOneProxy() == null || scopeGUID != null && !scopeGUID.equals(externalIdScope.getEntityOneProxy().getGUID())) continue;
                    ArrayList<Relationship> externalIdRelationships = new ArrayList<Relationship>();
                    externalIdRelationships.add(externalIdLink);
                    externalIdRelationships.add(externalIdScope);
                    Object bean = this.converter.getNewComplexBean(this.beanClass, externalIdEntity, externalIdRelationships, methodName);
                    if (bean == null) continue;
                    results.add(bean);
                }
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<EntityDetail> getElementEntitiesForScope(String userId, String scopeGUID, String scopeParameterName, String scopeTypeName, String requestedTypeName, int startingFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String requestedTypeNameParameterName = "requestedTypeName";
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeParameterName, methodName);
        this.invalidParameterHandler.validateName(requestedTypeName, "requestedTypeName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        RepositoryRelatedEntitiesIterator externalIdIterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, scopeGUID, scopeTypeName, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        int skippedResults = 0;
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        while (externalIdIterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
            EntityDetail externalIdEntity = externalIdIterator.getNext();
            if (externalIdEntity == null) continue;
            RepositoryRelatedEntitiesIterator elementIterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, this.invalidParameterHandler, userId, externalIdEntity.getGUID(), OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
            while (externalIdIterator.moreToReceive() && (queryPageSize == 0 || results.size() < queryPageSize)) {
                EntityDetail elementEntity = elementIterator.getNext();
                if (elementEntity == null || elementEntity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, elementEntity.getType().getTypeDefName(), requestedTypeName)) continue;
                if (skippedResults < startingFrom) {
                    ++skippedResults;
                    continue;
                }
                results.add(elementEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<OPEN_METADATA_ELEMENT_HEADER> getElementsForExternalIdentifier(String userId, String scopeGUID, String scopeParameterName, String scopeTypeName, String scopeQualifiedName, String externalIdentifier, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String externalIdentifierParameterName = "externalIdentifier";
        this.invalidParameterHandler.validateGUID(scopeGUID, scopeParameterName, methodName);
        this.invalidParameterHandler.validateName(externalIdentifier, "externalIdentifier", methodName);
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.IDENTIFIER.name);
        List<EntityDetail> matchingExternalIds = this.getEntitiesByValue(userId, externalIdentifier, "externalIdentifier", OpenMetadataType.EXTERNAL_ID.typeGUID, OpenMetadataType.EXTERNAL_ID.typeName, propertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (matchingExternalIds != null) {
            String matchingEntityGUIDParameterName = "matchingEntity.getGUID()";
            for (EntityDetail matchingExternalId : matchingExternalIds) {
                List<Relationship> externalIdRelationships;
                if (matchingExternalId == null || (externalIdRelationships = this.getAttachmentLinks(userId, matchingExternalId, "matchingEntity.getGUID()", OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName, scopeGUID, scopeTypeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) == null || !externalIdRelationships.isEmpty()) continue;
                return this.getElementHeaders(userId, matchingExternalId, "matchingEntity.getGUID()", serviceSupportedZones, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private List<OPEN_METADATA_ELEMENT_HEADER> getElementHeaders(String userId, EntityDetail externalId, String externalIdGUIDParameterName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> elementEntities = this.getAttachedEntities(userId, externalId, externalIdGUIDParameterName, OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        ArrayList<OPEN_METADATA_ELEMENT_HEADER> results = new ArrayList<OPEN_METADATA_ELEMENT_HEADER>();
        if (elementEntities != null) {
            for (EntityDetail elementEntity : elementEntities) {
                OPEN_METADATA_ELEMENT_HEADER bean;
                if (elementEntity == null || (bean = this.elementConverter.getNewBean(this.elementBeanClass, elementEntity, methodName)) == null) continue;
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

