/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String language = null;
    private String usage = null;

    GlossaryBuilder(String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.language = language;
        this.usage = usage;
    }

    public GlossaryBuilder(String qualifiedName, String displayName, String description, String language, String usage, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.GLOSSARY.typeGUID, OpenMetadataType.GLOSSARY.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.language = language;
        this.usage = usage;
    }

    GlossaryBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.GLOSSARY.typeGUID, OpenMetadataType.GLOSSARY.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    GlossaryBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.GLOSSARY.typeGUID, OpenMetadataType.GLOSSARY.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LANGUAGE.name, this.language, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USAGE.name, this.usage, methodName);
        return properties;
    }

    InstanceProperties getEditingGlossaryProperties(String description, String methodName) {
        InstanceProperties properties = null;
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getStagingGlossaryProperties(String description, String methodName) {
        InstanceProperties properties = null;
        if (description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getTaxonomyProperties(String organizingPrinciple, String methodName) {
        InstanceProperties properties = null;
        if (organizingPrinciple != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ORGANIZING_PRINCIPLE.name, organizingPrinciple, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCanonicalVocabularyProperties(String scope, String methodName) {
        InstanceProperties properties = null;
        if (scope != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.SCOPE.name, scope, methodName);
        }
        this.setEffectivityDates(properties);
        return properties;
    }
}

