/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryCategoryBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;

    GlossaryCategoryBuilder(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.GLOSSARY_CATEGORY.typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public GlossaryCategoryBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    GlossaryCategoryBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.GLOSSARY_CATEGORY.typeName, repositoryHelper, serviceName, serverName);
    }

    public void setRootCategory(String userId, String methodName) throws InvalidParameterException {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.ROOT_CATEGORY_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, null);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (Exception error) {
            this.errorHandler.handleUnsupportedType(error, methodName, OpenMetadataType.ROOT_CATEGORY_CLASSIFICATION.typeName);
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        return properties;
    }
}

